/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.authentications;

import java.util.Collections;
import java.util.List;
import org.alfresco.rest.api.Authentications;
import org.alfresco.rest.api.model.LoginTicket;
import org.alfresco.rest.api.model.LoginTicketResponse;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiNoAuth;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="tickets", title="Authentication tickets")
public class AuthenticationTicketsEntityResource
implements EntityResourceAction.Create<LoginTicket>,
EntityResourceAction.ReadByIdWithResponse<LoginTicket>,
EntityResourceAction.DeleteWithResponse,
InitializingBean {
    public static final String COLLECTION_RESOURCE_NAME = "tickets";
    private Authentications authentications;

    public void setAuthentications(Authentications authentications) {
        this.authentications = authentications;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"authentications", (Object)this.authentications);
    }

    @Override
    @WebApiDescription(title="Login", description="Login.")
    @WebApiNoAuth
    public List<LoginTicket> create(List<LoginTicket> entity, Parameters parameters) {
        if (entity == null || entity.size() != 1) {
            throw new InvalidArgumentException("Please specify one login request only.");
        }
        LoginTicketResponse result = this.authentications.createTicket(entity.get(0), parameters);
        return Collections.singletonList(result);
    }

    @Override
    @WebApiDescription(title="Validate login ticket", description="Validate login ticket.")
    public LoginTicket readById(String me, Parameters parameters, WithResponse withResponse) {
        return this.authentications.validateTicket(me, parameters, withResponse);
    }

    @Override
    @WebApiDescription(title="Logout", description="Logout.")
    public void delete(String me, Parameters parameters, WithResponse withResponse) {
        this.authentications.deleteTicket(me, parameters, withResponse);
    }
}

