/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.rules.ActionPermissionValidator;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.impl.rules.RuleLoader;
import org.alfresco.rest.api.impl.rules.RuleSetLoader;
import org.alfresco.rest.api.impl.rules.RulesImpl;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.api.model.rules.InclusionType;
import org.alfresco.rest.api.model.rules.Rule;
import org.alfresco.rest.api.model.rules.RuleExecution;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RulesImplTest
extends TestCase {
    private static final String FOLDER_NODE_ID = "dummy-folder-node-id";
    private static final String RULE_SET_ID = "dummy-rule-set-id";
    private static final String RULE_ID = "dummy-rule-id";
    private static final String RULE_ID_INHERITED = "dummy-rule-id-inherited";
    private static final NodeRef FOLDER_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-folder-node-id");
    private static final NodeRef RULE_SET_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-rule-set-id");
    private static final NodeRef RULE_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-rule-id");
    private static final Paging PAGING = Paging.DEFAULT;
    private static final List<String> INCLUDE = Collections.emptyList();
    private static final boolean INCLUDE_SUB_FOLDERS = true;
    private static final boolean EXECUTE_INHERITED_RULES = true;
    @Mock
    private Nodes nodesMock;
    @Mock
    private ActionService actionServiceMock;
    @Mock
    private RestModelMapper<Rule, org.alfresco.service.cmr.rule.Rule> ruleMapper;
    @Mock
    private NodeValidator nodeValidatorMock;
    @Mock
    private RuleService ruleServiceMock;
    @Mock
    private RuleLoader ruleLoaderMock;
    @Mock
    private RuleSetLoader ruleSetLoaderMock;
    @Mock
    private ActionPermissionValidator actionPermissionValidatorMock;
    @Mock
    private org.alfresco.service.cmr.rule.Rule serviceRuleMock;
    @Mock
    private Rule ruleMock;
    @Mock
    private RuleSet ruleSetMock;
    @Mock
    private Action actionMock;
    private org.alfresco.service.cmr.rule.Rule ruleModel = RulesImplTest.createRule("dummy-rule-id");
    private org.alfresco.service.cmr.rule.Rule ruleModelInherited = RulesImplTest.createRule("dummy-rule-id-inherited");
    @InjectMocks
    private RulesImpl rules;

    @Before
    public void setUp() throws Exception {
        this.ruleModel.applyToChildren(true);
        this.ruleModelInherited.applyToChildren(true);
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)RULE_SET_NODE_REF);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)RULE_NODE_REF);
        BDDMockito.given((Object)this.ruleServiceMock.getRule(RULE_NODE_REF)).willReturn((Object)this.ruleModel);
        BDDMockito.given((Object)this.ruleServiceMock.getRules(FOLDER_NODE_REF, false)).willReturn(List.of(this.ruleModel));
        BDDMockito.given((Object)this.ruleServiceMock.getOwningNodeRef(RULE_SET_NODE_REF)).willReturn((Object)FOLDER_NODE_REF);
        BDDMockito.given((Object)this.ruleSetMock.getInclusionType()).willReturn((Object)InclusionType.INHERITED);
        BDDMockito.given((Object)this.ruleLoaderMock.loadRule(this.ruleModel, INCLUDE)).willReturn((Object)this.ruleMock);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(RULE_SET_NODE_REF, FOLDER_NODE_REF, List.of("inclusionType"))).willReturn((Object)this.ruleSetMock);
    }

    @Test
    public void testGetRules() {
        CollectionWithPagingInfo rulesPage = this.rules.getRules(FOLDER_NODE_ID, RULE_SET_ID, INCLUDE, PAGING);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getOwningNodeRef(RULE_SET_NODE_REF);
        ((RuleSetLoader)BDDMockito.then((Object)this.ruleSetLoaderMock).should()).loadRuleSet(RULE_SET_NODE_REF, FOLDER_NODE_REF, List.of("inclusionType"));
        BDDMockito.then((Object)this.ruleSetLoaderMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRules(FOLDER_NODE_REF, false);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        ((RuleLoader)BDDMockito.then((Object)this.ruleLoaderMock).should()).loadRule(this.ruleModel, Collections.emptyList());
        BDDMockito.then((Object)this.ruleLoaderMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)rulesPage).isNotNull()).extracting(CollectionWithPagingInfo::getCollection).isNotNull()).extracting(Collection::size).isEqualTo((Object)1);
        Assertions.assertThat((Object)((Rule)rulesPage.getCollection().stream().findFirst().get())).isEqualTo((Object)this.ruleMock);
    }

    @Test
    public void testGetRules_ruleNotAppliedToChildren() {
        BDDMockito.given((Object)this.ruleSetMock.getInclusionType()).willReturn((Object)InclusionType.INHERITED);
        BDDMockito.given((Object)this.ruleServiceMock.getRules(FOLDER_NODE_REF, false)).willReturn(List.of(this.ruleModel, this.ruleModelInherited));
        this.ruleModelInherited.applyToChildren(false);
        CollectionWithPagingInfo rulesPage = this.rules.getRules(FOLDER_NODE_ID, RULE_SET_ID, INCLUDE, PAGING);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getOwningNodeRef(RULE_SET_NODE_REF);
        ((RuleSetLoader)BDDMockito.then((Object)this.ruleSetLoaderMock).should()).loadRuleSet(RULE_SET_NODE_REF, FOLDER_NODE_REF, List.of("inclusionType"));
        BDDMockito.then((Object)this.ruleSetLoaderMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRules(FOLDER_NODE_REF, false);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        ((RuleLoader)BDDMockito.then((Object)this.ruleLoaderMock).should()).loadRule(this.ruleModel, Collections.emptyList());
        BDDMockito.then((Object)this.ruleLoaderMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)rulesPage).isNotNull()).extracting(CollectionWithPagingInfo::getCollection).isNotNull()).extracting(Collection::size).isEqualTo((Object)1);
        Assertions.assertThat((Object)((Rule)rulesPage.getCollection().stream().findFirst().get())).isEqualTo((Object)this.ruleMock);
    }

    @Test
    public void testGetRules_inheritedRuleSet() {
        BDDMockito.given((Object)this.ruleSetMock.getInclusionType()).willReturn((Object)InclusionType.INHERITED);
        this.ruleModelInherited.applyToChildren(false);
        BDDMockito.given((Object)this.ruleServiceMock.getRules(FOLDER_NODE_REF, false)).willReturn(List.of(this.ruleModel, this.ruleModelInherited));
        CollectionWithPagingInfo rulesPage = this.rules.getRules(FOLDER_NODE_ID, RULE_SET_ID, INCLUDE, PAGING);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getOwningNodeRef(RULE_SET_NODE_REF);
        ((RuleSetLoader)BDDMockito.then((Object)this.ruleSetLoaderMock).should()).loadRuleSet(RULE_SET_NODE_REF, FOLDER_NODE_REF, List.of("inclusionType"));
        BDDMockito.then((Object)this.ruleSetLoaderMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRules(FOLDER_NODE_REF, false);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        ((RuleLoader)BDDMockito.then((Object)this.ruleLoaderMock).should()).loadRule(this.ruleModel, Collections.emptyList());
        BDDMockito.then((Object)this.ruleLoaderMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)rulesPage).isNotNull()).extracting(CollectionWithPagingInfo::getCollection).isNotNull()).extracting(Collection::size).isEqualTo((Object)1);
        Assertions.assertThat((Object)((Rule)rulesPage.getCollection().stream().findFirst().get())).isEqualTo((Object)this.ruleMock);
    }

    @Test
    public void testGetRules_emptyResult() {
        BDDMockito.given((Object)this.ruleServiceMock.getRules(FOLDER_NODE_REF, false)).willReturn(Collections.emptyList());
        CollectionWithPagingInfo rulesPage = this.rules.getRules(FOLDER_NODE_ID, RULE_SET_ID, INCLUDE, PAGING);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getOwningNodeRef(RULE_SET_NODE_REF);
        ((RuleSetLoader)BDDMockito.then((Object)this.ruleSetLoaderMock).should()).loadRuleSet(RULE_SET_NODE_REF, FOLDER_NODE_REF, List.of("inclusionType"));
        BDDMockito.then((Object)this.ruleSetLoaderMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRules(FOLDER_NODE_REF, false);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)rulesPage).isNotNull()).extracting(CollectionWithPagingInfo::getCollection).isNotNull()).extracting(Collection::isEmpty).isEqualTo((Object)true);
    }

    @Test
    public void testGetRules_invalidFolder() {
        for (Exception exception : RulesImplTest.folderValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.getRules(FOLDER_NODE_ID, RULE_SET_ID, INCLUDE, PAGING));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testGetRules_invalidRuleSet() {
        for (Exception exception : RulesImplTest.ruleSetValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.getRules(FOLDER_NODE_ID, RULE_SET_ID, INCLUDE, PAGING));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testGetRuleById() {
        Rule rule = this.rules.getRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID, INCLUDE);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleNode(RULE_ID, RULE_SET_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRule(RULE_NODE_REF);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)rule).isEqualTo((Object)this.ruleMock);
    }

    @Test
    public void testGetRuleById_invalidFolder() {
        for (Exception exception : RulesImplTest.folderValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.getRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID, INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testGetRuleById_invalidRuleSet() {
        for (Exception exception : RulesImplTest.ruleSetValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.getRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID, INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testGetRuleById_invalidRule() {
        for (Exception exception : RulesImplTest.ruleValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)RULE_SET_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.getRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID, INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleNode(RULE_ID, RULE_SET_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testCreateRules() {
        List<Rule> ruleList = List.of(this.ruleMock);
        BDDMockito.given((Object)((org.alfresco.service.cmr.rule.Rule)this.ruleMapper.toServiceModel((Object)this.ruleMock))).willReturn((Object)this.serviceRuleMock);
        BDDMockito.given((Object)this.ruleMock.getActions()).willReturn(List.of(this.actionMock));
        BDDMockito.given((Object)this.ruleServiceMock.saveRule(FOLDER_NODE_REF, this.serviceRuleMock)).willAnswer(arg -> arg.getArguments()[1]);
        BDDMockito.given((Object)this.ruleLoaderMock.loadRule(this.serviceRuleMock, INCLUDE)).willReturn((Object)this.ruleMock);
        BDDMockito.given((Object)this.actionPermissionValidatorMock.validateRulePermissions((org.alfresco.service.cmr.rule.Rule)ArgumentMatchers.any())).willAnswer(arg -> arg.getArguments()[0]);
        List actual = this.rules.createRules(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), ruleList, INCLUDE);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((ActionPermissionValidator)BDDMockito.then((Object)this.actionPermissionValidatorMock).should()).validateRulePermissions(this.serviceRuleMock);
        BDDMockito.then((Object)this.actionPermissionValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).saveRule(FOLDER_NODE_REF, this.serviceRuleMock);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        List<Rule> expected = List.of(this.ruleMock);
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void testCreateRules_defaultRuleSet() {
        List<Rule> ruleList = List.of(this.ruleMock);
        BDDMockito.given((Object)((org.alfresco.service.cmr.rule.Rule)this.ruleMapper.toServiceModel((Object)this.ruleMock))).willReturn((Object)this.serviceRuleMock);
        BDDMockito.given((Object)this.ruleMock.getActions()).willReturn(List.of(this.actionMock));
        BDDMockito.given((Object)this.ruleServiceMock.saveRule(FOLDER_NODE_REF, this.serviceRuleMock)).willAnswer(arg -> arg.getArguments()[1]);
        BDDMockito.given((Object)this.ruleLoaderMock.loadRule(this.serviceRuleMock, INCLUDE)).willReturn((Object)this.ruleMock);
        BDDMockito.given((Object)this.actionPermissionValidatorMock.validateRulePermissions((org.alfresco.service.cmr.rule.Rule)ArgumentMatchers.any())).willAnswer(arg -> arg.getArguments()[0]);
        List actual = this.rules.createRules(FOLDER_NODE_REF.getId(), "-default-", ruleList, INCLUDE);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((ActionPermissionValidator)BDDMockito.then((Object)this.actionPermissionValidatorMock).should()).validateRulePermissions(this.serviceRuleMock);
        BDDMockito.then((Object)this.actionPermissionValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).saveRule(FOLDER_NODE_REF, this.serviceRuleMock);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        List<Rule> expected = List.of(this.ruleMock);
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void testCreateRules_emptyRuleList() {
        List ruleList = Collections.emptyList();
        List actual = this.rules.createRules(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), ruleList, INCLUDE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        Assertions.assertThat((List)actual).isEqualTo(Collections.emptyList());
    }

    @Test
    public void testCreateRules_createMultipleRules() {
        ArrayList ruleBodyList = new ArrayList();
        ArrayList expected = new ArrayList();
        IntStream.range(0, 3).forEach(i -> {
            Rule ruleBodyMock = (Rule)Mockito.mock(Rule.class);
            BDDMockito.given((Object)ruleBodyMock.getActions()).willReturn(List.of(this.actionMock));
            ruleBodyList.add(ruleBodyMock);
            org.alfresco.service.cmr.rule.Rule serviceRuleMockInner = (org.alfresco.service.cmr.rule.Rule)Mockito.mock(org.alfresco.service.cmr.rule.Rule.class);
            BDDMockito.given((Object)((org.alfresco.service.cmr.rule.Rule)this.ruleMapper.toServiceModel((Object)ruleBodyMock))).willReturn((Object)serviceRuleMockInner);
            BDDMockito.given((Object)this.ruleServiceMock.saveRule(FOLDER_NODE_REF, serviceRuleMockInner)).willAnswer(arg -> arg.getArguments()[1]);
            Rule ruleMockInner = (Rule)Mockito.mock(Rule.class);
            BDDMockito.given((Object)this.ruleLoaderMock.loadRule(serviceRuleMockInner, INCLUDE)).willReturn((Object)ruleMockInner);
            expected.add(ruleMockInner);
            BDDMockito.given((Object)this.actionPermissionValidatorMock.validateRulePermissions((org.alfresco.service.cmr.rule.Rule)ArgumentMatchers.any())).willAnswer(arg -> arg.getArguments()[0]);
        });
        List actual = this.rules.createRules(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), ruleBodyList, INCLUDE);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        for (Rule ruleBody : ruleBodyList) {
            ((ActionPermissionValidator)BDDMockito.then((Object)this.actionPermissionValidatorMock).should()).validateRulePermissions((org.alfresco.service.cmr.rule.Rule)this.ruleMapper.toServiceModel((Object)ruleBody));
            ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).saveRule(FOLDER_NODE_REF, (org.alfresco.service.cmr.rule.Rule)this.ruleMapper.toServiceModel((Object)ruleBody));
        }
        BDDMockito.then((Object)this.actionPermissionValidatorMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void testCreateRules_invalidFolder() {
        for (Exception exception : RulesImplTest.folderValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.createRules(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), Collections.emptyList(), INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testCreateRules_invalidRuleSet() {
        for (Exception exception : RulesImplTest.ruleSetValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.createRules(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), Collections.emptyList(), INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testCreateRuleWithoutActionsShouldFail() {
        List<Rule> ruleList = List.of(this.ruleMock);
        BDDMockito.given((Object)this.ruleMock.getActions()).willReturn(null);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.rules.createRules(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), ruleList, INCLUDE));
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.actionPermissionValidatorMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testUpdateRuleById() {
        BDDMockito.given((Object)((org.alfresco.service.cmr.rule.Rule)this.ruleMapper.toServiceModel((Object)this.ruleMock))).willReturn((Object)this.serviceRuleMock);
        BDDMockito.given((Object)this.ruleMock.getActions()).willReturn(List.of(this.actionMock));
        BDDMockito.given((Object)this.ruleServiceMock.saveRule(FOLDER_NODE_REF, this.serviceRuleMock)).willAnswer(a -> a.getArguments()[1]);
        BDDMockito.given((Object)this.ruleLoaderMock.loadRule(this.serviceRuleMock, INCLUDE)).willReturn((Object)this.ruleMock);
        BDDMockito.given((Object)this.actionPermissionValidatorMock.validateRulePermissions((org.alfresco.service.cmr.rule.Rule)ArgumentMatchers.any())).willAnswer(arg -> arg.getArguments()[0]);
        Rule updatedRule = this.rules.updateRuleById(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), RULE_ID, this.ruleMock, INCLUDE);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleNode(RULE_ID, RULE_SET_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).saveRule(FOLDER_NODE_REF, this.serviceRuleMock);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        ((ActionPermissionValidator)BDDMockito.then((Object)this.actionPermissionValidatorMock).should()).validateRulePermissions(this.serviceRuleMock);
        BDDMockito.then((Object)this.actionPermissionValidatorMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)updatedRule).isEqualTo((Object)this.ruleMock);
    }

    @Test
    public void testUpdateRuleById_invalidFolder() {
        for (Exception exception : RulesImplTest.folderValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.updateRuleById(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), RULE_ID, (Rule)Mockito.mock(Rule.class), INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testUpdateRuleById_invalidRuleSet() {
        for (Exception exception : RulesImplTest.ruleSetValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.updateRuleById(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), RULE_ID, (Rule)Mockito.mock(Rule.class), INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testUpdateRuleById_invalidRule() {
        for (Exception exception : RulesImplTest.ruleValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)RULE_SET_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.updateRuleById(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), RULE_ID, (Rule)Mockito.mock(Rule.class), INCLUDE));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleNode(RULE_ID, RULE_SET_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testUpdateRuleWithoutActionShouldFail() {
        BDDMockito.given((Object)this.ruleMock.getActions()).willReturn(Collections.emptyList());
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.rules.updateRuleById(FOLDER_NODE_REF.getId(), RULE_SET_NODE_REF.getId(), RULE_ID, this.ruleMock, INCLUDE));
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleNode(RULE_ID, RULE_SET_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.actionPermissionValidatorMock).shouldHaveNoInteractions();
    }

    @Test
    public void testDeleteRuleById() {
        this.rules.deleteRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleNode(RULE_ID, RULE_SET_NODE_REF);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRule(RULE_NODE_REF);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).removeRule(FOLDER_NODE_REF, this.ruleModel);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testDeleteRuleById_invalidFolder() {
        for (Exception exception : RulesImplTest.folderValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.deleteRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testDeleteRuleById_invalidRuleSet() {
        for (Exception exception : RulesImplTest.ruleSetValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.deleteRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testDeleteRuleById_invalidRule() {
        for (Exception exception : RulesImplTest.ruleValidationExceptions()) {
            Mockito.reset((Object[])new NodeValidator[]{this.nodeValidatorMock});
            BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)RULE_SET_NODE_REF);
            BDDMockito.given((Object)this.nodeValidatorMock.validateRuleNode((String)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willThrow(new Throwable[]{exception});
            Assertions.assertThatExceptionOfType(exception.getClass()).isThrownBy(() -> this.rules.deleteRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID));
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, true);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE_REF);
            ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleNode(RULE_ID, RULE_SET_NODE_REF);
            BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
            BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        }
    }

    @Test
    public void testExecuteRule() {
        RuleExecution actualRuleExecution = this.rules.executeRules(FOLDER_NODE_ID, true);
        RuleExecution expectedRuleExecution = RuleExecution.builder().eachSubFolderIncluded(true).create();
        ActionImpl expectedAction = new ActionImpl(null, null, "execute-all-rules");
        expectedAction.setNodeRef(FOLDER_NODE_REF);
        expectedAction.setParameterValues(Map.of("run-all-rules-on-children", true, "execute-inherited-rules", true, "actionContext", "v1"));
        ArgumentCaptor actionCaptor = ArgumentCaptor.forClass(ActionImpl.class);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_NODE_ID, false);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((ActionService)BDDMockito.then((Object)this.actionServiceMock).should()).executeAction((org.alfresco.service.cmr.action.Action)actionCaptor.capture(), (NodeRef)ArgumentMatchers.eq((Object)FOLDER_NODE_REF), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false));
        BDDMockito.then((Object)this.actionServiceMock).shouldHaveNoMoreInteractions();
        ActionImpl actualAction = (ActionImpl)actionCaptor.getValue();
        ((ObjectAssert)Assertions.assertThat((Object)actualAction).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id"}).isEqualTo((Object)expectedAction);
        ((ObjectAssert)Assertions.assertThat((Object)actualRuleExecution).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedRuleExecution);
    }

    private static org.alfresco.service.cmr.rule.Rule createRule(String id) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id);
        org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
        rule.setNodeRef(nodeRef);
        rule.setRuleType("ruleType");
        return rule;
    }

    private static List<Exception> folderValidationExceptions() {
        return List.of(new EntityNotFoundException(FOLDER_NODE_ID), new InvalidArgumentException(), new PermissionDeniedException());
    }

    private static List<Exception> ruleSetValidationExceptions() {
        return List.of(new EntityNotFoundException(RULE_SET_ID), new InvalidArgumentException(), new RelationshipResourceNotFoundException(RULE_SET_ID, "fake-relationship-id"));
    }

    private static List<Exception> ruleValidationExceptions() {
        return List.of(new EntityNotFoundException(RULE_ID), new InvalidArgumentException(), new RelationshipResourceNotFoundException(RULE_ID, "fake-relationship-id"));
    }
}

