/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.util.Arrays;
import junit.framework.TestCase;
import org.alfresco.rest.api.search.SearchApiWebscript;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.junit.Assert;
import org.junit.Test;

public class SearchApiWebscriptTests {
    static SearchApiWebscript webscript = new SearchApiWebscript();

    @Test
    public void testPaging() throws Exception {
        Params params = webscript.getParams(null, null, null, null);
        TestCase.assertNotNull((Object)params.getPaging());
        TestCase.assertEquals((int)100, (int)params.getPaging().getMaxItems());
        TestCase.assertEquals((int)0, (int)params.getPaging().getSkipCount());
        params = webscript.getParams(null, null, null, Paging.valueOf((int)4, (int)20));
        TestCase.assertEquals((int)20, (int)params.getPaging().getMaxItems());
        TestCase.assertEquals((int)4, (int)params.getPaging().getSkipCount());
    }

    @Test
    public void testFilter() throws Exception {
        Params params = webscript.getParams(null, null, null, null);
        TestCase.assertNotNull((Object)params.getFilter());
        params = webscript.getParams(null, null, Arrays.asList("name", "size"), null);
        TestCase.assertTrue((String)"This isn't used until include is also specfied", (boolean)params.getFilter().isAllowed("name"));
        TestCase.assertTrue((String)"Anything is allowed if include hasn't been specfied", (boolean)params.getFilter().isAllowed("horse"));
        params = webscript.getParams(null, Arrays.asList("cat", "dog"), null, null);
        TestCase.assertTrue((boolean)params.getFilter().isAllowed("cat"));
        TestCase.assertTrue((boolean)params.getFilter().isAllowed("dog"));
        Assert.assertFalse((boolean)params.getFilter().isAllowed("horse"));
        params = webscript.getParams(null, Arrays.asList("cat", "dog"), Arrays.asList("name", "size"), null);
        TestCase.assertTrue((boolean)params.getFilter().isAllowed("cat"));
        Assert.assertFalse((boolean)params.getFilter().isAllowed("horse"));
        TestCase.assertTrue((String)"name and size should be automatically added to the filter list", (boolean)params.getFilter().isAllowed("name"));
        TestCase.assertTrue((String)"name and size should be automatically added to the filter list", (boolean)params.getFilter().isAllowed("size"));
    }

    @Test
    public void testInclude() throws Exception {
        Params params = webscript.getParams(null, null, null, null);
        TestCase.assertNotNull((Object)params.getInclude());
        TestCase.assertEquals((int)0, (int)params.getInclude().size());
        params = webscript.getParams(null, null, Arrays.asList("name", "size"), null);
        TestCase.assertNotNull((Object)params.getInclude());
        TestCase.assertEquals((int)2, (int)params.getInclude().size());
    }
}

