/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.archive.ArchivedNodesCannedQueryBuilder;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.ScriptPagingDetails;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractArchivedNodeWebScript
extends DeclarativeWebScript {
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String NODEREF = "nodeRef";
    public static final String ARCHIVED_BY = "archivedBy";
    public static final String ARCHIVED_DATE = "archivedDate";
    public static final String DISPLAY_PATH = "displayPath";
    public static final String USER_NAME = "userName";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String NODE_TYPE = "nodeType";
    public static final String DELETED_NODES = "deletedNodes";
    public static final int DEFAULT_MAX_ITEMS_PER_PAGE = 50;
    protected ServiceRegistry serviceRegistry;
    protected NodeArchiveService nodeArchiveService;
    protected int maxSizeView = 1000;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setNodeArchiveService(NodeArchiveService nodeArchiveService) {
        this.nodeArchiveService = nodeArchiveService;
    }

    public void setMaxSizeView(int maxSizeView) {
        this.maxSizeView = maxSizeView;
    }

    protected StoreRef parseRequestForStoreRef(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        String storeId = (String)templateVars.get("store_id");
        StoreRef storeRef = new StoreRef(storeType, storeId);
        return storeRef;
    }

    protected NodeRef parseRequestForNodeRef(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        String storeId = (String)templateVars.get("store_id");
        String id = (String)templateVars.get("id");
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        return new NodeRef(storeType, storeId, id);
    }

    protected int getIntParameter(WebScriptRequest req, String paramName, int defaultValue) {
        String paramString = req.getParameter(paramName);
        if (paramString != null) {
            try {
                int param = Integer.valueOf(paramString);
                if (param >= 0) {
                    return param;
                }
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, e.getMessage());
            }
        }
        return defaultValue;
    }

    protected PagingResults<NodeRef> getArchivedNodesFrom(StoreRef storeRef, ScriptPagingDetails paging, String filter) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        NodeRef archiveStoreRootNodeRef = nodeService.getStoreArchiveNode(storeRef);
        ArchivedNodesCannedQueryBuilder queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(archiveStoreRootNodeRef, (PagingRequest)paging).filter(filter).sortOrderAscending(false).build();
        PagingResults result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        return result;
    }

    protected void validatePermission(NodeRef nodeRef, String currentUser) {
        if (!this.nodeArchiveService.hasFullAccess(nodeRef)) {
            throw new WebScriptException(403, "You don't have permission to act on the node.");
        }
    }
}

