/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.content;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Locale;
import org.alfresco.rest.framework.resource.content.ContentInfo;
import org.alfresco.service.cmr.repository.ContentReader;

public class BinaryProperty
implements ContentInfo,
Serializable {
    private static final long serialVersionUID = 7392073427641063968L;
    private final String mimeType;
    private final String encoding;
    private final long length;
    private final Locale locale;

    public BinaryProperty(String mimeType, String encoding) {
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.length = 0L;
        this.locale = null;
    }

    public BinaryProperty(ContentReader reader) {
        this.mimeType = reader.getMimetype();
        this.encoding = reader.getEncoding();
        this.length = reader.getSize();
        this.locale = reader.getLocale();
    }

    public BinaryProperty(String mimeType, String encoding, long length, Locale locale) {
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.length = length;
        this.locale = locale;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    @JsonIgnore
    public String getEncoding() {
        return this.encoding;
    }

    public Long getSizeInBytes() {
        return this.length > 0L ? Long.valueOf(this.length) : null;
    }

    @Override
    @JsonIgnore
    public long getLength() {
        return this.length;
    }

    @Override
    @JsonIgnore
    public Locale getLocale() {
        return this.locale;
    }
}

