/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.TagsImpl;
import org.alfresco.rest.api.model.Tag;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.TypeConstraint;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TagsImplTest {
    private static final String TAG_ID = "tag-node-id";
    private static final String PARENT_NODE_ID = "tag:tag-root";
    private static final String TAG_NAME = "tag-dummy-name";
    private static final NodeRef TAG_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "tag-node-id".concat("-").concat("tag-dummy-name"));
    private static final NodeRef TAG_PARENT_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "tag:tag-root");
    private static final String CONTENT_NODE_ID = "content-node-id";
    private static final NodeRef CONTENT_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "content-node-id");
    private static final String PARAM_INCLUDE_COUNT = "count";
    private final RecognizedParamsExtractor queryExtractor = new RecognizedParamsExtractor(){};
    @Mock
    private Nodes nodesMock;
    @Mock
    private ChildAssociationRef primaryParentMock;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private AuthorityService authorityServiceMock;
    @Mock
    private TaggingService taggingServiceMock;
    @Mock
    private Parameters parametersMock;
    @Mock
    private Paging pagingMock;
    @Mock
    private PagingResults<Pair<NodeRef, String>> pagingResultsMock;
    @Mock
    private TypeConstraint typeConstraintMock;
    @InjectMocks
    private TagsImpl objectUnderTest;

    @Before
    public void setup() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)true);
        BDDMockito.given((Object)this.nodesMock.validateNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID)).willReturn((Object)TAG_NODE_REF);
        BDDMockito.given((Object)this.taggingServiceMock.getTagName(TAG_NODE_REF)).willReturn((Object)TAG_NAME);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent(TAG_NODE_REF)).willReturn((Object)this.primaryParentMock);
        BDDMockito.given((Object)this.primaryParentMock.getParentRef()).willReturn((Object)TAG_PARENT_NODE_REF);
    }

    @Test
    public void testGetTags() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(new ArrayList());
        BDDMockito.given((Object)this.taggingServiceMock.getTags((StoreRef)ArgumentMatchers.eq((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), (List)ArgumentMatchers.any(), (Pair)ArgumentMatchers.any(), (Collection)ArgumentMatchers.isNull(), (Collection)ArgumentMatchers.isNull())).willReturn(Map.of(TAG_NODE_REF, 0L));
        BDDMockito.given((Object)this.nodeServiceMock.getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_NAME))).willReturn((Object)TAG_NAME);
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).getTags((StoreRef)ArgumentMatchers.eq((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), (List)ArgumentMatchers.any(), (Pair)ArgumentMatchers.any(), (Collection)ArgumentMatchers.isNull(), (Collection)ArgumentMatchers.isNull());
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoMoreInteractions();
        List<Tag> expectedTags = TagsImplTest.createTagsWithNodeRefs(List.of(TAG_NAME));
        Assert.assertEquals(expectedTags, (Object)actualTags.getCollection());
    }

    @Test
    public void testGetTags_verifyIfCountIsZero() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        BDDMockito.given((Object)this.taggingServiceMock.getTags((StoreRef)ArgumentMatchers.any(StoreRef.class), (List)ArgumentMatchers.any(), (Pair)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).willReturn(Map.of(TAG_NODE_REF, 0L));
        BDDMockito.given((Object)this.nodeServiceMock.getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_NAME))).willReturn((Object)TAG_NAME);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        List expectedTags = TagsImplTest.createTagsWithNodeRefs(List.of(TAG_NAME)).stream().peek(tag -> tag.setCount(Long.valueOf(0L))).collect(Collectors.toList());
        Assert.assertEquals(expectedTags, (Object)actualTags.getCollection());
    }

    @Test
    public void testGetTags_verifyCountPopulatedCorrectly() {
        NodeRef tagNodeA = new NodeRef("tag://A/");
        NodeRef tagNodeB = new NodeRef("tag://B/");
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(Collections.emptyList());
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        LinkedHashMap<NodeRef, Long> results = new LinkedHashMap<NodeRef, Long>();
        results.put(tagNodeA, 5L);
        results.put(tagNodeB, 0L);
        BDDMockito.given((Object)this.taggingServiceMock.getTags((StoreRef)ArgumentMatchers.any(StoreRef.class), (List)ArgumentMatchers.eq(List.of(PARAM_INCLUDE_COUNT)), (Pair)ArgumentMatchers.isNull(), (Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).willReturn(results);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_NAME))).willReturn((Object)"taga", (Object[])new Serializable[]{"tagb"});
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        List<Tag> expectedTags = List.of(Tag.builder().tag("tagA").nodeRef(tagNodeA).count(Long.valueOf(5L)).create(), Tag.builder().tag("tagB").nodeRef(tagNodeB).count(Long.valueOf(0L)).create());
        Assert.assertEquals(expectedTags, (Object)actualTags.getCollection());
    }

    @Test
    public void testGetTags_orderByCountAscendingOrder() {
        NodeRef tagNodeA = new NodeRef("tag://A/");
        NodeRef tagNodeB = new NodeRef("tag://B/");
        NodeRef tagNodeC = new NodeRef("tag://C/");
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(List.of(new SortColumn(PARAM_INCLUDE_COUNT, true)));
        LinkedHashMap<NodeRef, Long> results = new LinkedHashMap<NodeRef, Long>();
        results.put(tagNodeB, 0L);
        results.put(tagNodeC, 2L);
        results.put(tagNodeA, 5L);
        BDDMockito.given((Object)this.taggingServiceMock.getTags((StoreRef)ArgumentMatchers.any(StoreRef.class), (List)ArgumentMatchers.eq(List.of(PARAM_INCLUDE_COUNT)), (Pair)ArgumentMatchers.eq((Object)new Pair((Object)PARAM_INCLUDE_COUNT, (Object)true)), (Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).willReturn(results);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagNodeA, ContentModel.PROP_NAME)).willReturn((Object)"taga");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagNodeB, ContentModel.PROP_NAME)).willReturn((Object)"tagb");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagNodeC, ContentModel.PROP_NAME)).willReturn((Object)"tagc");
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        List<Tag> expectedTags = List.of(Tag.builder().tag("tagb").nodeRef(tagNodeB).count(Long.valueOf(0L)).create(), Tag.builder().tag("tagc").nodeRef(tagNodeC).count(Long.valueOf(2L)).create(), Tag.builder().tag("taga").nodeRef(tagNodeA).count(Long.valueOf(5L)).create());
        Assert.assertEquals(expectedTags, (Object)actualTags.getCollection());
    }

    @Test
    public void testGetTags_orderByCountDescendingOrder() {
        NodeRef tagNodeA = new NodeRef("tag://A/");
        NodeRef tagNodeB = new NodeRef("tag://B/");
        NodeRef tagNodeC = new NodeRef("tag://C/");
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(List.of(new SortColumn(PARAM_INCLUDE_COUNT, false)));
        LinkedHashMap<NodeRef, Long> results = new LinkedHashMap<NodeRef, Long>();
        results.put(tagNodeA, 5L);
        results.put(tagNodeC, 2L);
        results.put(tagNodeB, 0L);
        BDDMockito.given((Object)this.taggingServiceMock.getTags((StoreRef)ArgumentMatchers.any(StoreRef.class), (List)ArgumentMatchers.eq(List.of(PARAM_INCLUDE_COUNT)), (Pair)ArgumentMatchers.eq((Object)new Pair((Object)PARAM_INCLUDE_COUNT, (Object)false)), (Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).willReturn(results);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagNodeA, ContentModel.PROP_NAME)).willReturn((Object)"taga");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagNodeB, ContentModel.PROP_NAME)).willReturn((Object)"tagb");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagNodeC, ContentModel.PROP_NAME)).willReturn((Object)"tagc");
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        List<Tag> expectedTags = List.of(Tag.builder().tag("taga").nodeRef(tagNodeA).count(Long.valueOf(5L)).create(), Tag.builder().tag("tagc").nodeRef(tagNodeC).count(Long.valueOf(2L)).create(), Tag.builder().tag("tagb").nodeRef(tagNodeB).count(Long.valueOf(0L)).create());
        Assert.assertEquals(expectedTags, (Object)actualTags.getCollection());
    }

    @Test
    public void testGetTags_orderByTagAscendingOrder() {
        NodeRef tagApple = new NodeRef("tag://apple/");
        NodeRef tagBanana = new NodeRef("tag://banana/");
        NodeRef tagCoconut = new NodeRef("tag://coconut/");
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(Collections.emptyList());
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(List.of(new SortColumn("tag", true)));
        LinkedHashMap<NodeRef, Long> results = new LinkedHashMap<NodeRef, Long>();
        results.put(tagApple, 0L);
        results.put(tagBanana, 0L);
        results.put(tagCoconut, 0L);
        BDDMockito.given((Object)this.taggingServiceMock.getTags((StoreRef)ArgumentMatchers.any(StoreRef.class), (List)ArgumentMatchers.any(), (Pair)ArgumentMatchers.eq((Object)new Pair((Object)"tag", (Object)true)), (Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).willReturn(results);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagApple, ContentModel.PROP_NAME)).willReturn((Object)"apple");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagBanana, ContentModel.PROP_NAME)).willReturn((Object)"banana");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagCoconut, ContentModel.PROP_NAME)).willReturn((Object)"coconut");
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        List<Tag> expectedTags = List.of(Tag.builder().tag("apple").nodeRef(tagApple).create(), Tag.builder().tag("banana").nodeRef(tagBanana).create(), Tag.builder().tag("coconut").nodeRef(tagCoconut).create());
        Assert.assertEquals(expectedTags, (Object)actualTags.getCollection());
    }

    @Test
    public void testGetTags_orderByTagDescendingOrder() {
        NodeRef tagApple = new NodeRef("tag://apple/");
        NodeRef tagBanana = new NodeRef("tag://banana/");
        NodeRef tagCoconut = new NodeRef("tag://coconut/");
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(Collections.emptyList());
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(List.of(new SortColumn("tag", false)));
        LinkedHashMap<NodeRef, Long> results = new LinkedHashMap<NodeRef, Long>();
        results.put(tagCoconut, 0L);
        results.put(tagBanana, 0L);
        results.put(tagApple, 0L);
        BDDMockito.given((Object)this.taggingServiceMock.getTags((StoreRef)ArgumentMatchers.any(StoreRef.class), (List)ArgumentMatchers.any(), (Pair)ArgumentMatchers.eq((Object)new Pair((Object)"tag", (Object)false)), (Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).willReturn(results);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagApple, ContentModel.PROP_NAME)).willReturn((Object)"apple");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagBanana, ContentModel.PROP_NAME)).willReturn((Object)"banana");
        BDDMockito.given((Object)this.nodeServiceMock.getProperty(tagCoconut, ContentModel.PROP_NAME)).willReturn((Object)"coconut");
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        List<Tag> expectedTags = List.of(Tag.builder().tag("coconut").nodeRef(tagCoconut).create(), Tag.builder().tag("banana").nodeRef(tagBanana).create(), Tag.builder().tag("apple").nodeRef(tagApple).create());
        Assert.assertEquals(expectedTags, (Object)actualTags.getCollection());
    }

    @Test
    public void testGetTags_withEqualsClauseWhereQuery() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getQuery()).willReturn((Object)this.queryExtractor.getWhereClause("(tag=expectedName)"));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(new ArrayList());
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).getTags((StoreRef)ArgumentMatchers.eq((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), (List)ArgumentMatchers.eq(new ArrayList()), (Pair)ArgumentMatchers.any(), (Collection)ArgumentMatchers.eq(Set.of("expectedname")), (Collection)ArgumentMatchers.isNull());
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)actualTags).isNotNull();
    }

    @Test
    public void testGetTags_withInClauseWhereQuery() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getQuery()).willReturn((Object)this.queryExtractor.getWhereClause("(tag IN (expectedName1, expectedName2))"));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(new ArrayList());
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).getTags((StoreRef)ArgumentMatchers.eq((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), (List)ArgumentMatchers.any(), (Pair)ArgumentMatchers.any(), (Collection)ArgumentMatchers.eq(Set.of("expectedname1", "expectedname2")), (Collection)ArgumentMatchers.isNull());
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)actualTags).isNotNull();
    }

    @Test
    public void testGetTags_withMatchesClauseWhereQuery() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getQuery()).willReturn((Object)this.queryExtractor.getWhereClause("(tag MATCHES ('expectedName*'))"));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(new ArrayList());
        CollectionWithPagingInfo actualTags = this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock);
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).getTags((StoreRef)ArgumentMatchers.eq((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), (List)ArgumentMatchers.any(), (Pair)ArgumentMatchers.any(), (Collection)ArgumentMatchers.isNull(), (Collection)ArgumentMatchers.eq(Set.of("expectedname*")));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)actualTags).isNotNull();
    }

    @Test
    public void testGetTags_withBothInAndEqualsClausesInSingleWhereQuery() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getQuery()).willReturn((Object)this.queryExtractor.getWhereClause("(tag=expectedName AND tag IN (expectedName1, expectedName2))"));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testGetTags_withOtherClauseInWhereQuery() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getQuery()).willReturn((Object)this.queryExtractor.getWhereClause("(tag BETWEEN ('expectedName', 'expectedName2'))"));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testGetTags_withNotEqualsClauseInWhereQuery() {
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        BDDMockito.given((Object)this.parametersMock.getQuery()).willReturn((Object)this.queryExtractor.getWhereClause("(NOT tag=expectedName)"));
        BDDMockito.given((Object)this.parametersMock.getSorting()).willReturn(new ArrayList());
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.parametersMock));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
        Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidQueryException.class);
    }

    @Test
    public void testDeleteTagById() {
        this.objectUnderTest.deleteTagById(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID);
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).getTagName(TAG_NODE_REF);
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).deleteTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_NAME);
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testDeleteTagById_asNonAdminUser() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)false);
        Assert.assertThrows(PermissionDeniedException.class, () -> this.objectUnderTest.deleteTagById(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testDeleteTagById_nonExistentTag() {
        Assert.assertThrows(EntityNotFoundException.class, () -> this.objectUnderTest.deleteTagById(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-id"));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-id");
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testCreateTags() {
        List<String> tagNames = List.of("tag1", "99gat");
        List<Tag> tagsToCreate = TagsImplTest.createTags(tagNames);
        BDDMockito.given((Object)this.taggingServiceMock.createTags((StoreRef)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).willAnswer(invocation -> TagsImplTest.createTagAndNodeRefPairs((List)invocation.getArgument(1)));
        List actualCreatedTags = this.objectUnderTest.createTags(tagsToCreate, this.parametersMock);
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).createTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, tagNames);
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoMoreInteractions();
        List<Tag> expectedTags = TagsImplTest.createTagsWithNodeRefs(tagNames);
        ((ListAssert)Assertions.assertThat((List)actualCreatedTags).isNotNull()).usingRecursiveComparison().isEqualTo(expectedTags);
    }

    @Test
    public void testCreateTags_withoutPermission() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)false);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.createTags(List.of(TagsImplTest.createTag(TAG_NAME)), this.parametersMock));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(PermissionDeniedException.class)).hasMessageContaining("Current user does not have permission to manage a tag");
    }

    @Test
    public void testCreateTags_passingNullInsteadList() {
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.createTags(null, this.parametersMock));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("An invalid parameter has been supplied");
    }

    @Test
    public void testCreateTags_passingEmptyList() {
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.createTags(Collections.emptyList(), this.parametersMock));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("An invalid parameter has been supplied");
    }

    @Test
    public void testCreateTags_passingListOfNulls() {
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.createTags(Collections.singletonList(null), this.parametersMock));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("An invalid parameter has been supplied");
    }

    @Test
    public void testCreateTags_whileTagAlreadyExists() {
        BDDMockito.given((Object)this.taggingServiceMock.createTags((StoreRef)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).willThrow(new Throwable[]{new DuplicateChildNodeNameException(null, null, TAG_NAME, null)});
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.createTags(List.of(TagsImplTest.createTag(TAG_NAME)), this.parametersMock));
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).createTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, List.of(TAG_NAME));
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Throwable)actualException).isInstanceOf(DuplicateChildNodeNameException.class);
    }

    @Test
    public void testCreateTags_withRepeatedTagName() {
        List<String> tagNames = List.of(TAG_NAME, TAG_NAME);
        List<Tag> tagsToCreate = TagsImplTest.createTags(tagNames);
        BDDMockito.given((Object)this.taggingServiceMock.createTags((StoreRef)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).willAnswer(invocation -> TagsImplTest.createTagAndNodeRefPairs((List)invocation.getArgument(1)));
        List actualCreatedTags = this.objectUnderTest.createTags(tagsToCreate, this.parametersMock);
        ((TaggingService)BDDMockito.then((Object)this.taggingServiceMock).should()).createTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, List.of(TAG_NAME));
        List<Tag> expectedTags = List.of(TagsImplTest.createTagWithNodeRef(TAG_NAME));
        ((ListAssert)Assertions.assertThat((List)actualCreatedTags).isNotNull()).isEqualTo(expectedTags);
    }

    @Test
    public void testCreateTags_includingCount() {
        List<String> tagNames = List.of("tag1", "99gat");
        List<Tag> tagsToCreate = TagsImplTest.createTags(tagNames);
        BDDMockito.given((Object)this.taggingServiceMock.createTags((StoreRef)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).willAnswer(invocation -> TagsImplTest.createTagAndNodeRefPairs((List)invocation.getArgument(1)));
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        List actualCreatedTags = this.objectUnderTest.createTags(tagsToCreate, this.parametersMock);
        List expectedTags = TagsImplTest.createTagsWithNodeRefs(tagNames).stream().peek(tag -> tag.setCount(Long.valueOf(0L))).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)actualCreatedTags).isNotNull()).isEqualTo(expectedTags);
    }

    @Test(expected=EntityNotFoundException.class)
    public void testGetTagByIdNotFoundValidation() {
        BDDMockito.given((Object)this.nodesMock.validateNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID)).willThrow(EntityNotFoundException.class);
        this.objectUnderTest.getTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID, null);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.taggingServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testAddTags() {
        NodeRef tagNodeA = new NodeRef("tag://A/");
        NodeRef tagNodeB = new NodeRef("tag://B/");
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willReturn((Object)CONTENT_NODE_REF);
        BDDMockito.given((Object)this.typeConstraintMock.matches(CONTENT_NODE_REF)).willReturn((Object)true);
        List<Pair> pairs = List.of(new Pair((Object)"taga", (Object)new NodeRef("tag://A/")), new Pair((Object)"tagb", (Object)new NodeRef("tag://B/")));
        List tagNames = pairs.stream().map(Pair::getFirst).collect(Collectors.toList());
        List tags = tagNames.stream().map(name -> Tag.builder().tag(name).create()).collect(Collectors.toList());
        BDDMockito.given((Object)this.taggingServiceMock.addTags(CONTENT_NODE_REF, tagNames)).willReturn(pairs);
        BDDMockito.given((Object)this.taggingServiceMock.findTaggedNodesAndCountByTagName(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE)).willReturn(List.of(new Pair((Object)"taga", (Object)4)));
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        List actual = this.objectUnderTest.addTags(CONTENT_NODE_ID, tags, this.parametersMock);
        List<Tag> expected = List.of(Tag.builder().tag("taga").nodeRef(tagNodeA).count(Long.valueOf(5L)).create(), Tag.builder().tag("tagb").nodeRef(tagNodeB).count(Long.valueOf(1L)).create());
        Assert.assertEquals((String)"Unexpected tags returned.", expected, (Object)actual);
    }

    @Test(expected=InvalidArgumentException.class)
    public void testAddTagsToInvalidNode() {
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willThrow(new Throwable[]{new InvalidArgumentException()});
        List<Tag> tags = List.of(Tag.builder().tag("tag1").create());
        this.objectUnderTest.addTags(CONTENT_NODE_ID, tags, this.parametersMock);
    }

    @Test(expected=UnsupportedResourceOperationException.class)
    public void testAddTagsToWrongTypeOfNode() {
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willReturn((Object)CONTENT_NODE_REF);
        BDDMockito.given((Object)this.typeConstraintMock.matches(CONTENT_NODE_REF)).willReturn((Object)false);
        List<Tag> tags = List.of(Tag.builder().tag("tag1").create());
        this.objectUnderTest.addTags(CONTENT_NODE_ID, tags, this.parametersMock);
    }

    @Test
    public void testGetTagsForNode() {
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willReturn((Object)CONTENT_NODE_REF);
        BDDMockito.given((Object)this.parametersMock.getPaging()).willReturn((Object)this.pagingMock);
        List<Pair> pairs = List.of(new Pair((Object)new NodeRef("tag://A/"), (Object)"taga"), new Pair((Object)new NodeRef("tag://B/"), (Object)"tagb"));
        BDDMockito.given((Object)this.taggingServiceMock.getTags((NodeRef)ArgumentMatchers.eq((Object)CONTENT_NODE_REF), (PagingRequest)ArgumentMatchers.any(PagingRequest.class))).willReturn(this.pagingResultsMock);
        BDDMockito.given((Object)this.pagingResultsMock.getTotalResultCount()).willReturn((Object)new Pair(null, null));
        BDDMockito.given((Object)this.pagingResultsMock.getPage()).willReturn(pairs);
        CollectionWithPagingInfo actual = this.objectUnderTest.getTags(CONTENT_NODE_ID, this.parametersMock);
        List tags = pairs.stream().map(pair -> Tag.builder().tag((String)pair.getSecond()).nodeRef((NodeRef)pair.getFirst()).create()).collect(Collectors.toList());
        Assert.assertEquals((Object)actual.getCollection(), tags);
    }

    @Test(expected=InvalidArgumentException.class)
    public void testGetTagsFromInvalidNode() {
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willThrow(new Throwable[]{new InvalidArgumentException()});
        this.objectUnderTest.getTags(CONTENT_NODE_ID, this.parametersMock);
    }

    @Test
    public void testChangeTag() {
        Tag suppliedTag = Tag.builder().tag("new-name").create();
        BDDMockito.given((Object)this.taggingServiceMock.changeTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_NAME, "new-name")).willReturn((Object)TAG_NODE_REF);
        Tag tag = this.objectUnderTest.changeTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID, suppliedTag, this.parametersMock);
        Tag expected = Tag.builder().nodeRef(TAG_NODE_REF).tag("new-name").create();
        Assert.assertEquals((String)"Unexpected return value", (Object)expected, (Object)tag);
    }

    @Test
    public void testChangeTagAndGetCount() {
        Tag suppliedTag = Tag.builder().tag("new-name").create();
        BDDMockito.given((Object)this.taggingServiceMock.changeTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_NAME, "new-name")).willReturn((Object)TAG_NODE_REF);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        BDDMockito.given((Object)this.taggingServiceMock.findCountByTagName(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_NAME)).willReturn((Object)3L);
        Tag tag = this.objectUnderTest.changeTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID, suppliedTag, this.parametersMock);
        Tag expected = Tag.builder().nodeRef(TAG_NODE_REF).tag("new-name").count(Long.valueOf(3L)).create();
        Assert.assertEquals((String)"Unexpected return value", (Object)expected, (Object)tag);
    }

    @Test
    public void testGetTag() {
        Tag tag = this.objectUnderTest.getTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID, this.parametersMock);
        Tag expected = Tag.builder().nodeRef(TAG_NODE_REF).tag(TAG_NAME).create();
        Assert.assertEquals((String)"Unexpected tag returned", (Object)expected, (Object)tag);
    }

    @Test
    public void testGetTagWithCount() {
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of(PARAM_INCLUDE_COUNT));
        BDDMockito.given((Object)this.taggingServiceMock.findCountByTagName(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_NAME)).willReturn((Object)0L);
        Tag tag = this.objectUnderTest.getTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID, this.parametersMock);
        Tag expected = Tag.builder().nodeRef(TAG_NODE_REF).tag(TAG_NAME).count(Long.valueOf(0L)).create();
        Assert.assertEquals((String)"Unexpected tag returned", (Object)expected, (Object)tag);
    }

    private static List<Pair<String, NodeRef>> createTagAndNodeRefPairs(List<String> tagNames) {
        return tagNames.stream().map(tagName -> TagsImplTest.createPair(tagName, new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID.concat("-").concat((String)tagName)))).collect(Collectors.toList());
    }

    private static Pair<String, NodeRef> createPair(String tagName, NodeRef nodeRef) {
        return new Pair((Object)tagName, (Object)nodeRef);
    }

    private static List<Tag> createTags(List<String> tagNames) {
        return tagNames.stream().map(TagsImplTest::createTag).collect(Collectors.toList());
    }

    private static List<Tag> createTagsWithNodeRefs(List<String> tagNames) {
        return tagNames.stream().map(TagsImplTest::createTagWithNodeRef).collect(Collectors.toList());
    }

    private static Tag createTag(String tagName) {
        return Tag.builder().tag(tagName).create();
    }

    private static Tag createTagWithNodeRef(String tagName) {
        return Tag.builder().nodeRef(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_ID.concat("-").concat(tagName))).tag(tagName).create();
    }
}

