/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.webdav.ActivityPostProducer;
import org.alfresco.repo.webdav.WebDAVActivityPoster;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.webdav.WebDavService;

public class MkcolMethod
extends WebDAVMethod
implements ActivityPostProducer {
    private WebDAVActivityPoster activityPoster;

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
        if (this.m_request.getContentLength() > 0) {
            throw new WebDAVServerException(415);
        }
    }

    @Override
    protected void executeImpl() throws WebDAVServerException, Exception {
        FileFolderService fileFolderService = this.getFileFolderService();
        try {
            this.getDAVHelper().getNodeForPath(this.getRootNodeRef(), this.getPath());
            throw new WebDAVServerException(405);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String parentPath = this.getPath();
            int lastPos = parentPath.lastIndexOf("/");
            NodeRef parentNodeRef = null;
            if (lastPos == 0) {
                parentPath = "/";
                parentNodeRef = this.getRootNodeRef();
            } else if (lastPos != -1) {
                parentPath = parentPath.substring(0, lastPos + 1);
                try {
                    FileInfo parentFileInfo = this.getDAVHelper().getNodeForPath(this.getRootNodeRef(), parentPath);
                    parentNodeRef = parentFileInfo.getNodeRef();
                }
                catch (FileNotFoundException e) {
                    throw new WebDAVServerException(409);
                }
            } else {
                throw new WebDAVServerException(405);
            }
            String folderName = this.getPath().substring(lastPos + 1);
            FileInfo fileInfo = fileFolderService.create(parentNodeRef, folderName, ContentModel.TYPE_FOLDER);
            if (!fileInfo.isHidden()) {
                this.postActivity(fileInfo);
            }
            this.m_response.setStatus(201);
            return;
        }
    }

    private void postActivity(FileInfo fileInfo) throws WebDAVServerException {
        WebDavService davService = this.getDAVHelper().getServiceRegistry().getWebDavService();
        if (!davService.activitiesEnabled()) {
            return;
        }
        String siteId = this.getSiteId();
        String tenantDomain = this.getTenantDomain();
        if (!siteId.equals("")) {
            String path;
            block4: {
                SiteService siteService = this.getServiceRegistry().getSiteService();
                NodeRef documentLibrary = siteService.getContainer(siteId, "documentLibrary");
                path = "/";
                try {
                    path = this.getDAVHelper().getPathFromNode(documentLibrary, fileInfo.getNodeRef());
                }
                catch (FileNotFoundException error) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"No documentLibrary container found.");
                }
            }
            this.activityPoster.postFileFolderAdded(siteId, tenantDomain, path, fileInfo);
        }
    }

    @Override
    public void setActivityPoster(WebDAVActivityPoster activityPoster) {
        this.activityPoster = activityPoster;
    }
}

