/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.impl.directurl.RestApiDirectUrlConfig;
import org.alfresco.rest.api.model.DiscoveryDetails;
import org.alfresco.rest.api.model.ModulePackage;
import org.alfresco.rest.api.model.RepositoryInfo;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.PropertyCheck;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class DiscoveryApiWebscript
extends AbstractWebScript
implements RecognizedParamsExtractor,
ResponseWriter,
InitializingBean {
    private DescriptorService descriptorService;
    private RepoAdminService repoAdminService;
    private AuditService auditService;
    private QuickShareService quickShareService;
    private ModuleService moduleService;
    private ApiAssistant assistant;
    private ThumbnailService thumbnailService;
    private RestApiDirectUrlConfig restApiDirectUrlConfig;
    private ContentService contentService;
    private boolean enabled = true;
    private static final String DISABLED = "Not Implemented";

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setQuickShareService(QuickShareService quickShareService) {
        this.quickShareService = quickShareService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void setAssistant(ApiAssistant assistant) {
        this.assistant = assistant;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setRestApiDirectUrlConfig(RestApiDirectUrlConfig restApiDirectUrlConfig) {
        this.restApiDirectUrlConfig = restApiDirectUrlConfig;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
        PropertyCheck.mandatory((Object)this, (String)"repoAdminService", (Object)this.repoAdminService);
        PropertyCheck.mandatory((Object)this, (String)"auditService", (Object)this.auditService);
        PropertyCheck.mandatory((Object)this, (String)"quickShareService", (Object)this.quickShareService);
        PropertyCheck.mandatory((Object)this, (String)"moduleService", (Object)this.moduleService);
        PropertyCheck.mandatory((Object)this, (String)"assistant", (Object)this.assistant);
        PropertyCheck.mandatory((Object)this, (String)"thumbnailService", (Object)this.thumbnailService);
        PropertyCheck.mandatory((Object)this, (String)"restApiDirectUrlConfig", (Object)((Object)this.restApiDirectUrlConfig));
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
    }

    public void execute(WebScriptRequest webScriptRequest, WebScriptResponse webScriptResponse) throws IOException {
        try {
            this.checkEnabled();
            DiscoveryDetails discoveryDetails = new DiscoveryDetails(this.getRepositoryInfo());
            this.setResponse(webScriptResponse, DEFAULT_SUCCESS);
            this.renderJsonResponse(webScriptResponse, discoveryDetails, this.assistant.getJsonHelper());
        }
        catch (Exception exception) {
            this.renderException(exception, webScriptResponse, this.assistant);
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo.LicenseInfo licenseInfo = null;
        if (this.descriptorService.getLicenseDescriptor() != null) {
            licenseInfo = new RepositoryInfo.LicenseInfo(this.descriptorService.getLicenseDescriptor());
        }
        Descriptor serverDescriptor = this.descriptorService.getServerDescriptor();
        return new RepositoryInfo().setId(this.descriptorService.getCurrentRepositoryDescriptor().getId()).setEdition(serverDescriptor.getEdition()).setVersion(new RepositoryInfo.VersionInfo(serverDescriptor)).setLicense(licenseInfo).setModules(this.getModules()).setStatus(new RepositoryInfo.StatusInfo().setReadOnly(this.repoAdminService.getUsage().isReadOnly()).setAuditEnabled(this.auditService.isAuditEnabled()).setQuickShareEnabled(this.quickShareService.isQuickShareEnabled()).setThumbnailGenerationEnabled(this.thumbnailService.getThumbnailsEnabled()).setDirectAccessUrlEnabled(this.isContentDirectUrlEnabled()));
    }

    private List<ModulePackage> getModules() {
        List details = this.moduleService.getAllModules();
        if (details.isEmpty()) {
            return null;
        }
        ArrayList<ModulePackage> packages = new ArrayList<ModulePackage>(details.size());
        for (ModuleDetails detail : details) {
            packages.add(ModulePackage.fromModuleDetails(detail));
        }
        return packages;
    }

    @Override
    public void renderJsonResponse(WebScriptResponse res, Object toSerialize, JacksonHelper jsonHelper) throws IOException {
        jsonHelper.withWriter(res.getOutputStream(), (generator, objectMapper) -> {
            JSONObject obj = new JSONObject();
            obj.put((Object)"entry", toSerialize);
            objectMapper.writeValue(generator, (Object)obj);
        });
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void checkEnabled() {
        if (!this.enabled) {
            throw new DisabledServiceException(DISABLED);
        }
    }

    protected boolean isContentDirectUrlEnabled() {
        return this.restApiDirectUrlConfig.isEnabled() != false && this.contentService.isContentDirectUrlEnabled();
    }
}

