/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.custommodel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.CustomModels;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.XMLUtil;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CustomModelUploadPost
extends DeclarativeWebScript {
    private static final String SHARE_EXT_MODULE_ROOT_ELEMENT = "module";
    private static final String TEMP_FILE_PREFIX = "cmmExport";
    private static final String TEMP_FILE_SUFFIX = ".zip";
    private static final int BUFFER_SIZE = 10240;
    private CustomModels customModels;
    private CustomModelService customModelService;

    public void setCustomModels(CustomModels customModels) {
        this.customModels = customModels;
    }

    public void setCustomModelService(CustomModelService customModelService) {
        this.customModelService = customModelService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        if (!this.customModelService.isModelAdmin(AuthenticationUtil.getFullyAuthenticatedUser())) {
            throw new WebScriptException(403, PermissionDeniedException.DEFAULT_MESSAGE_ID);
        }
        FormData formData = (FormData)req.parseContent();
        if (formData == null || !formData.getIsMultiPart()) {
            throw new WebScriptException(400, "cmm.rest_api.model.import_not_multi_part_req");
        }
        ImportResult resultData = null;
        boolean processed = false;
        for (FormData.FormField field : formData.getFields()) {
            if (!field.getIsFile()) continue;
            String fileName = field.getFilename();
            File tempFile = this.createTempFile(field.getInputStream());
            try (ZipFile zipFile = new ZipFile(tempFile, StandardCharsets.UTF_8);){
                resultData = this.processUpload(zipFile, field.getFilename());
            }
            catch (ZipException ze) {
                throw new WebScriptException(400, "cmm.rest_api.model.import_not_zip_format", new Object[]{fileName});
            }
            catch (IOException io) {
                throw new WebScriptException(500, "cmm.rest_api.model.import_process_zip_file_failure", (Throwable)io);
            }
            finally {
                tempFile.delete();
            }
            processed = true;
            break;
        }
        if (!processed) {
            throw new WebScriptException(400, "cmm.rest_api.model.import_no_zip_file_uploaded");
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("importedModelName", resultData.getImportedModelName());
        model.put("shareExtXMLFragment", resultData.getShareExtXMLFragment());
        return model;
    }

    protected File createTempFile(InputStream inputStream) {
        try {
            File tempFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX);
            return tempFile;
        }
        catch (Exception ex) {
            throw new WebScriptException(500, "cmm.rest_api.model.import_process_zip_file_failure", (Throwable)ex);
        }
    }

    protected ImportResult processUpload(ZipFile zipFile, String filename) throws IOException {
        if (zipFile.size() > 2) {
            throw new WebScriptException(400, "cmm.rest_api.model.import_invalid_zip_package");
        }
        CustomModel customModel = null;
        String shareExtModule = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            try (BufferedInputStream input = new BufferedInputStream(zipFile.getInputStream(entry), 10240);){
                if (!entryName.endsWith("_module.xml") && customModel == null) {
                    try {
                        M2Model m2Model = M2Model.createModel((InputStream)input);
                        customModel = this.importModel(m2Model);
                        continue;
                    }
                    catch (DictionaryException ex) {
                        if (shareExtModule == null) {
                            try (BufferedInputStream moduleInputStream = new BufferedInputStream(zipFile.getInputStream(entry), 10240);){
                                shareExtModule = this.getExtensionModule(moduleInputStream, entryName);
                            }
                            if (shareExtModule != null) continue;
                            throw new WebScriptException(400, "cmm.rest_api.model.import_invalid_zip_entry_format", new Object[]{entryName});
                        }
                        throw new WebScriptException(400, "cmm.rest_api.model.import_invalid_model_entry", new Object[]{entryName});
                    }
                }
                shareExtModule = this.getExtensionModule(input, entryName);
                if (shareExtModule != null) continue;
                throw new WebScriptException(400, "cmm.rest_api.model.import_invalid_ext_module_entry", new Object[]{entryName});
            }
        }
        return new ImportResult(customModel, shareExtModule);
    }

    protected CustomModel importModel(M2Model m2Model) {
        CustomModel model = null;
        try {
            model = this.customModels.createCustomModel(m2Model);
        }
        catch (Exception ex) {
            int statusCode = ex instanceof ConstraintViolatedException ? 409 : (ex instanceof InvalidArgumentException ? 400 : 500);
            String msg = ex.getMessage();
            msg = msg != null ? msg.replaceAll("\\d{8,}", "").trim() : "cmm.rest_api.model.import_failure";
            throw new WebScriptException(statusCode, msg);
        }
        return model;
    }

    protected String getExtensionModule(InputStream inputStream, String fileName) {
        Element rootElement = null;
        try {
            DocumentBuilder db = XMLUtil.getDocumentBuilder();
            rootElement = db.parse(inputStream).getDocumentElement();
        }
        catch (IOException io) {
            throw new WebScriptException(500, "cmm.rest_api.model.import_process_ext_module_file_failure", (Throwable)io);
        }
        catch (SAXException ex) {
            throw new WebScriptException(400, "cmm.rest_api.model.import_invalid_ext_module_entry", new Object[]{new Object[]{fileName}, ex});
        }
        if (rootElement != null && SHARE_EXT_MODULE_ROOT_ELEMENT.equals(rootElement.getNodeName())) {
            StringWriter sw = new StringWriter();
            XMLUtil.print((Node)rootElement, (Writer)sw, (boolean)false);
            return sw.toString();
        }
        return null;
    }

    public static class ImportResult {
        private String importedModelName;
        private String shareExtXMLFragment;

        public ImportResult(CustomModel customModel, String shareExtXMLFragment) {
            this.shareExtXMLFragment = shareExtXMLFragment;
            if (customModel != null) {
                this.importedModelName = customModel.getName();
            }
        }

        public String getImportedModelName() {
            return this.importedModelName;
        }

        public String getShareExtXMLFragment() {
            return this.shareExtXMLFragment;
        }
    }
}

