/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.alfresco.repo.content.ContentLimitViolationException;
import org.alfresco.repo.web.scripts.TempOutputStream;
import org.alfresco.util.TempFileProvider;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.StreamUtils;

public class TempOutputStreamTest {
    private static final String TEMP_DIRECTORY_NAME = "TempOutputStreamTest";
    private static final String FILE_PREFIX = "tempStreamFile-";
    private static final int MEMORY_THRESHOLD = 0x400000;
    private static final long MAX_CONTENT_SIZE = 0x40000000L;
    private static final File bufferTempDirectory = TempFileProvider.getTempDir((String)"TempOutputStreamTest");

    @Test
    public void testInMemoryStream() throws IOException {
        Supplier streamFactory = TempOutputStream.factory((File)bufferTempDirectory, (int)0x400000, (long)0x40000000L, (boolean)false);
        File file = this.createTextFileWithRandomContent(4193280L);
        TempOutputStream outputStream = (TempOutputStream)streamFactory.get();
        long countBefore = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        StreamUtils.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), (OutputStream)outputStream);
        long countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)countBefore, (long)countAfter);
        outputStream.destroy();
        file.delete();
    }

    @Test
    public void testFileBackedStream() throws IOException {
        File file = this.createTextFileWithRandomContent(0x400400L);
        Supplier streamFactory = TempOutputStream.factory((File)bufferTempDirectory, (int)0x400000, (long)0x40000000L, (boolean)false);
        TempOutputStream outputStream = (TempOutputStream)streamFactory.get();
        long countBefore = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        StreamUtils.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), (OutputStream)outputStream);
        long countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)(countBefore + 1L), (long)countAfter);
        outputStream.close();
        countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)(countBefore + 1L), (long)countAfter);
        outputStream.destroy();
        countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)countBefore, (long)countAfter);
        file.delete();
    }

    @Test
    public void testMaxContentSize() throws IOException {
        long contentSize = 4193792L;
        long maxContentSize = 4193280L;
        File file = this.createTextFileWithRandomContent(contentSize);
        Supplier streamFactory = TempOutputStream.factory((File)bufferTempDirectory, (int)0x400000, (long)maxContentSize, (boolean)false);
        TempOutputStream outputStream = (TempOutputStream)streamFactory.get();
        long countBefore = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        try {
            StreamUtils.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), (OutputStream)outputStream);
            Assert.fail((String)"Content size limit violation exception was expected");
        }
        catch (ContentLimitViolationException contentLimitViolationException) {
            // empty catch block
        }
        long countAfter22 = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)countBefore, (long)countAfter22);
        file.delete();
        contentSize = 0x400400L;
        maxContentSize = 0x400200L;
        file = this.createTextFileWithRandomContent(contentSize);
        streamFactory = TempOutputStream.factory((File)bufferTempDirectory, (int)0x400000, (long)maxContentSize, (boolean)false);
        outputStream = (TempOutputStream)streamFactory.get();
        countBefore = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        try {
            StreamUtils.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), (OutputStream)outputStream);
            Assert.fail((String)"Content size limit violation exception was expected");
        }
        catch (ContentLimitViolationException countAfter22) {
            // empty catch block
        }
        long countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)countBefore, (long)countAfter);
        file.delete();
    }

    @Test
    public void testEncryptContent() throws IOException {
        File file = this.createTextFileWithRandomContent(0x400400L);
        Supplier streamFactory = TempOutputStream.factory((File)bufferTempDirectory, (int)0x400000, (long)0x40000000L, (boolean)true);
        TempOutputStream outputStream = (TempOutputStream)streamFactory.get();
        long countBefore = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        StreamUtils.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), (OutputStream)outputStream);
        long countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)(countBefore + 1L), (long)countAfter);
        outputStream.close();
        countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)(countBefore + 1L), (long)countAfter);
        String contentWriten = StreamUtils.copyToString((InputStream)new BufferedInputStream(new FileInputStream(file)), (Charset)Charset.defaultCharset());
        String contentRead = StreamUtils.copyToString((InputStream)outputStream.toNewInputStream(), (Charset)Charset.defaultCharset());
        Assert.assertEquals((Object)contentWriten, (Object)contentRead);
        outputStream.destroy();
        countAfter = this.countFilesInDirectoryWithPrefix(bufferTempDirectory);
        Assert.assertEquals((long)countBefore, (long)countAfter);
        file.delete();
    }

    private File createTextFileWithRandomContent(long contentSize) throws IOException {
        File txtFile = TempFileProvider.createTempFile((String)this.getClass().getSimpleName(), (String)".txt");
        txtFile.deleteOnExit();
        RandomAccessFile file = new RandomAccessFile(txtFile.getPath(), "rw");
        file.setLength(contentSize);
        file.close();
        return txtFile;
    }

    private long countFilesInDirectoryWithPrefix(File directory) throws IOException {
        Stream<File> fileStream = Arrays.stream(directory.listFiles());
        return fileStream.filter(f -> f.getName().startsWith(FILE_PREFIX)).count();
    }
}

