/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.model.CustomAspect;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.api.model.CustomModelConstraint;
import org.alfresco.rest.api.model.CustomModelNamedValue;
import org.alfresco.rest.api.model.CustomModelProperty;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.rest.api.tests.BaseCustomModelApiTest;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestCustomConstraint
extends BaseCustomModelApiTest {
    @Test
    public void testCreateConstraints() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        String modelName = "testModelConstraint" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String regExConstraintName = "testFileNameRegEx" + System.currentTimeMillis();
        CustomModelConstraint regExConstraint = new CustomModelConstraint();
        regExConstraint.setName(regExConstraintName);
        regExConstraint.setType("REGEX");
        regExConstraint.setTitle("test RegEx title");
        regExConstraint.setDescription("test RegEx desc");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(2);
        parameters.add(this.buildNamedValue("expression", "(.*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$)", new String[0]));
        parameters.add(this.buildNamedValue("requiresMatch", "false", new String[0]));
        regExConstraint.setParameters(parameters);
        this.setRequestContext(this.nonAdminUserName);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(regExConstraint), 403);
        this.setRequestContext(this.customModelAdmin);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(regExConstraint), 201);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/constraints", regExConstraintName, 200);
        CustomModelConstraint returnedConstraint = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelConstraint.class);
        this.compareCustomModelConstraints(regExConstraint, returnedConstraint, "prefixedName");
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(regExConstraint), 409);
        response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        List<CustomModelConstraint> constraints = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)1L, (long)constraints.size());
        this.setRequestContext(this.customModelAdmin);
        regExConstraintName = "testFileNameInvalidRegEx" + System.currentTimeMillis();
        regExConstraint = new CustomModelConstraint();
        regExConstraint.setName(regExConstraintName);
        regExConstraint.setType("REGEX");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("expression", "*******", new String[0]));
        parameters.add(this.buildNamedValue("requiresMatch", "false", new String[0]));
        regExConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(regExConstraint), 400);
        String minMaxConstraintName = "testMinMaxConstraint" + System.currentTimeMillis();
        CustomModelConstraint minMaxConstraint = new CustomModelConstraint();
        minMaxConstraint.setName(minMaxConstraintName);
        minMaxConstraint.setTitle("test MinMax title");
        minMaxConstraint.setDescription("test MinMax desc");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxValue", "100.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "0.0", new String[0]));
        minMaxConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(minMaxConstraint), 400);
        minMaxConstraint.setType("MINMAX");
        parameters.clear();
        parameters.add(this.buildNamedValue("maxValue", "abc", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "0.0", new String[0]));
        minMaxConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(minMaxConstraint), 400);
        parameters.clear();
        parameters.add(this.buildNamedValue("maxValue", "100", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "text", new String[0]));
        minMaxConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(minMaxConstraint), 400);
        parameters.clear();
        parameters.add(this.buildNamedValue("maxValue", "100.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "0.0", new String[0]));
        minMaxConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(minMaxConstraint), 201);
        response = this.getSingle("cmm/" + modelName + "/constraints", minMaxConstraintName, 200);
        returnedConstraint = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelConstraint.class);
        this.compareCustomModelConstraints(minMaxConstraint, returnedConstraint, "prefixedName");
        response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        constraints = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)2L, (long)constraints.size());
        String lengthConstraintName = "testLengthConstraint" + System.currentTimeMillis();
        CustomModelConstraint lengthConstraint = new CustomModelConstraint();
        lengthConstraint.setName(lengthConstraintName);
        lengthConstraint.setType("LENGTH");
        lengthConstraint.setTitle("test Length title");
        lengthConstraint.setDescription("test Length desc");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxLength", "text", new String[0]));
        parameters.add(this.buildNamedValue("minLength", "0", new String[0]));
        lengthConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(lengthConstraint), 400);
        parameters.clear();
        parameters.add(this.buildNamedValue("maxLength", "256", new String[0]));
        parameters.add(this.buildNamedValue("minLength", "1.0", new String[0]));
        lengthConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(lengthConstraint), 400);
        parameters.clear();
        parameters.add(this.buildNamedValue("maxLength", "256", new String[0]));
        parameters.add(this.buildNamedValue("minLength", "0", new String[0]));
        lengthConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(lengthConstraint), 201);
        response = this.getSingle("cmm/" + modelName + "/constraints", lengthConstraintName, 200);
        returnedConstraint = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelConstraint.class);
        this.compareCustomModelConstraints(lengthConstraint, returnedConstraint, "prefixedName");
        response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        constraints = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)3L, (long)constraints.size());
        String listConstraintName = "testListConstraint" + System.currentTimeMillis();
        CustomModelConstraint listConstraint = new CustomModelConstraint();
        listConstraint.setName(listConstraintName);
        listConstraint.setType("LIST");
        listConstraint.setTitle("test List title");
        listConstraint.setDescription("test List desc");
        parameters = new ArrayList(3);
        parameters.add(this.buildNamedValue("allowedValues", null, "High", "Normal", "Low"));
        parameters.add(this.buildNamedValue("sorted", "false", new String[0]));
        listConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(listConstraint), 201);
        response = this.getSingle("cmm/" + modelName + "/constraints", listConstraintName, 200);
        returnedConstraint = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelConstraint.class);
        this.compareCustomModelConstraints(listConstraint, returnedConstraint, "prefixedName", "parameters");
        String sorted = this.getParameterSimpleValue(returnedConstraint.getParameters(), "sorted");
        Assert.assertEquals((Object)"false", (Object)sorted);
        List<String> listValues = this.getParameterListValue(returnedConstraint.getParameters(), "allowedValues");
        Assert.assertNotNull(listValues);
        Assert.assertEquals((long)3L, (long)listValues.size());
        Assert.assertEquals((Object)"High", (Object)listValues.get(0));
        Assert.assertEquals((Object)"Normal", (Object)listValues.get(1));
        Assert.assertEquals((Object)"Low", (Object)listValues.get(2));
        response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        List<CustomModelConstraint> constraints2 = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)4L, (long)constraints2.size());
        String authorityNameConstraintName = "authorityNameConstraint" + System.currentTimeMillis();
        CustomModelConstraint authorityNameConstraint = new CustomModelConstraint();
        authorityNameConstraint.setName(authorityNameConstraintName);
        authorityNameConstraint.setType("org.alfresco.repo.dictionary.constraint.AuthorityNameConstraint");
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(authorityNameConstraint), 201);
        HttpResponse response2 = this.getSingle("cmm/" + modelName + "/constraints", authorityNameConstraintName, 200);
        CustomModelConstraint returnedConstraint2 = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomModelConstraint.class);
        this.compareCustomModelConstraints(authorityNameConstraint, returnedConstraint2, "prefixedName");
        response2 = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        List<CustomModelConstraint> constraints3 = RestApiUtil.parseRestApiEntries(response2.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)5L, (long)constraints3.size());
        String invalidConstraintName = "testInvalidConstraint" + System.currentTimeMillis();
        CustomModelConstraint invalidConstraint = new CustomModelConstraint();
        invalidConstraint.setName(invalidConstraintName);
        invalidConstraint.setType("InvalidConstraintType" + System.currentTimeMillis());
        invalidConstraint.setTitle("test Invalid title");
        invalidConstraint.setDescription("test Invalid desc");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxValue", "100.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "0.0", new String[0]));
        invalidConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(invalidConstraint), 400);
        response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        constraints3 = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)5L, (long)constraints3.size());
        CustomModel updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        HttpResponse response3 = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        List<CustomModelConstraint> constraints4 = RestApiUtil.parseRestApiEntries(response3.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)5L, (long)constraints4.size());
        updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        response3 = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        constraints4 = RestApiUtil.parseRestApiEntries(response3.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)5L, (long)constraints4.size());
    }

    @Test
    public void testCreateConstraintAndAddToProperty() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelConstraint" + System.currentTimeMillis();
        final Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String regExConstraintName = "testFileNameRegEx" + System.currentTimeMillis();
        CustomModelConstraint regExConstraint = new CustomModelConstraint();
        regExConstraint.setName(regExConstraintName);
        regExConstraint.setType("REGEX");
        regExConstraint.setTitle("test RegEx title");
        regExConstraint.setDescription("test RegEx desc");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(2);
        parameters.add(this.buildNamedValue("expression", "(.*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$)", new String[0]));
        parameters.add(this.buildNamedValue("requiresMatch", "false", new String[0]));
        regExConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(regExConstraint), 201);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/constraints", regExConstraintName, 200);
        CustomModelConstraint returnedConstraint = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelConstraint.class);
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        List<CustomModelConstraint> constraints = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)1L, (long)constraints.size());
        String aspectName = "testAspect1" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        CustomAspect payload = new CustomAspect();
        payload.setName(aspectName);
        final String aspectPropName = "testAspect1Prop1" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property title");
        aspectProp.setDataType("d:text");
        aspectProp.setConstraintRefs(Arrays.asList(returnedConstraint.getPrefixedName()));
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        payload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(payload), "?select=props", 200);
        CustomModel updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        constraints = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((long)1L, (long)constraints.size());
        final NodeService nodeService = this.repoService.getNodeService();
        final QName aspectQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + aspectName));
        RepoService.TestNetwork testNetwork = this.getTestFixture().getRandomNetwork();
        RepoService.TestPerson person = testNetwork.createUser();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCustomConstraint.this.repoService.createSite(null, siteInfo);
                NodeRef nodeRef = TestCustomConstraint.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc", "Test Content");
                nodeService.addAspect(nodeRef, aspectQName, null);
                Assert.assertTrue((boolean)nodeService.hasAspect(nodeRef, aspectQName));
                try {
                    QName propQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + aspectPropName));
                    nodeService.setProperty(nodeRef, propQName, (Serializable)((Object)"Invalid$Char."));
                    Assert.fail((String)"Invalid property value. Should have caused integrity violations.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                nodeService.deleteNode(nodeRef);
                return null;
            }
        }, (String)person.getId(), (String)testNetwork.getId());
        this.setRequestContext(this.customModelAdmin);
        updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        CustomModel updateModelPayload = new CustomModel();
        String modifiedPrefix = (String)namespacePair.getSecond() + "Modified";
        updateModelPayload.setNamespacePrefix(modifiedPrefix);
        updateModelPayload.setNamespaceUri((String)namespacePair.getFirst());
        response = this.put("cmm", modelName, RestApiUtil.toJsonAsString(updateModelPayload), null, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)modifiedPrefix, (Object)returnedModel.getNamespacePrefix());
        Assert.assertEquals((String)"The namespace URI shouldn't have changed.", (Object)namespacePair.getFirst(), (Object)returnedModel.getNamespaceUri());
        updateModelPayload = new CustomModel();
        updateModelPayload.setNamespacePrefix(modifiedPrefix);
        String modifiedURI = (String)namespacePair.getFirst() + "Modified";
        updateModelPayload.setNamespaceUri(modifiedURI);
        response = this.put("cmm", modelName, RestApiUtil.toJsonAsString(updateModelPayload), null, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)modifiedURI, (Object)returnedModel.getNamespaceUri());
        Assert.assertEquals((String)"The namespace prefix shouldn't have changed.", (Object)modifiedPrefix, (Object)returnedModel.getNamespacePrefix());
    }

    @Test
    public void testCreateInlineConstraint() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelInlineConstraint" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String regExConstraintName = "testInlineFileNameRegEx" + System.currentTimeMillis();
        CustomModelConstraint inlineRegExConstraint = new CustomModelConstraint();
        inlineRegExConstraint.setName(regExConstraintName);
        inlineRegExConstraint.setType("REGEX");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(2);
        parameters.add(this.buildNamedValue("expression", "(.*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$)", new String[0]));
        parameters.add(this.buildNamedValue("requiresMatch", "false", new String[0]));
        inlineRegExConstraint.setParameters(parameters);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropName = "testAspect1Prop1" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property title");
        aspectProp.setDataType("d:text");
        aspectProp.setConstraints(Arrays.asList(inlineRegExConstraint));
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 200);
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HttpResponse response = this.getAll("cmm/" + modelName + "/constraints", paging, 200);
        List<CustomModelConstraint> constraints = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModelConstraint.class);
        Assert.assertEquals((String)"Inline constraints should not be included with the model defined constraints.", (long)0L, (long)constraints.size());
        response = this.getSingle("cmm/" + modelName + "/aspects", aspectName, 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        Assert.assertEquals((long)1L, (long)returnedAspect.getProperties().size());
        CustomModelProperty customModelProperty = (CustomModelProperty)returnedAspect.getProperties().get(0);
        Assert.assertEquals((Object)aspectPropName, (Object)customModelProperty.getName());
        Assert.assertEquals((long)0L, (long)customModelProperty.getConstraintRefs().size());
        List inlineConstraints = customModelProperty.getConstraints();
        Assert.assertEquals((long)1L, (long)inlineConstraints.size());
        this.compareCustomModelConstraints(inlineRegExConstraint, (CustomModelConstraint)inlineConstraints.get(0), "prefixedName");
        CustomModelConstraint regExConstraint = new CustomModelConstraint();
        regExConstraint.setName(regExConstraintName);
        regExConstraint.setType("REGEX");
        regExConstraint.setTitle("test RegEx title");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("expression", "(.*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$)", new String[0]));
        parameters.add(this.buildNamedValue("requiresMatch", "false", new String[0]));
        regExConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(regExConstraint), 409);
        String newRegExConstraintName = "testFileNameRegEx" + System.currentTimeMillis();
        regExConstraint.setName(newRegExConstraintName);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(regExConstraint), 201);
        HttpResponse response2 = this.getSingle("cmm/" + modelName + "/constraints", newRegExConstraintName, 200);
        CustomModelConstraint returnedRegExConstraint = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomModelConstraint.class);
        CustomModelConstraint inlineAnonymousLengthConstraint = new CustomModelConstraint();
        inlineAnonymousLengthConstraint.setType("LENGTH");
        inlineAnonymousLengthConstraint.setTitle("test Length title");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxLength", "256", new String[0]));
        parameters.add(this.buildNamedValue("minLength", "0", new String[0]));
        inlineAnonymousLengthConstraint.setParameters(parameters);
        String typeName = "testType1" + System.currentTimeMillis();
        CustomType type = this.createTypeAspect(CustomType.class, modelName, typeName, "test type1 title", "test type1 Desc", "cm:content");
        CustomType typePayload = new CustomType();
        typePayload.setName(typeName);
        String typePropName = "testType1Prop1" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setTitle("property title");
        typeProp.setDataType("d:int");
        typeProp.setConstraintRefs(Arrays.asList(returnedRegExConstraint.getPrefixedName()));
        typeProp.setConstraints(Arrays.asList(inlineAnonymousLengthConstraint));
        ArrayList<CustomModelProperty> props2 = new ArrayList<CustomModelProperty>(1);
        props2.add(typeProp);
        typePayload.setProperties(props2);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 400);
        typeProp.setDataType("d:double");
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 400);
        typeProp.setDataType("d:text");
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 200);
        response2 = this.getSingle("cmm/" + modelName + "/types", type.getName(), 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)1L, (long)returnedType.getProperties().size());
        CustomModelProperty customModelProperty2 = (CustomModelProperty)returnedType.getProperties().get(0);
        Assert.assertEquals((Object)typePropName, (Object)customModelProperty2.getName());
        Assert.assertEquals((long)1L, (long)customModelProperty2.getConstraintRefs().size());
        Assert.assertEquals((Object)returnedRegExConstraint.getPrefixedName(), customModelProperty2.getConstraintRefs().get(0));
        Assert.assertEquals((long)1L, (long)customModelProperty2.getConstraints().size());
        Assert.assertNotNull((Object)((CustomModelConstraint)customModelProperty2.getConstraints().get(0)).getName());
        this.compareCustomModelConstraints(inlineAnonymousLengthConstraint, (CustomModelConstraint)customModelProperty2.getConstraints().get(0), "prefixedName", "name");
    }

    @Test
    public void testCreateListConstraintInvalid() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelConstraintInvalid" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropName = "testAspect1Prop" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property title");
        aspectProp.setDataType("d:int");
        String inlineListConstraintName = "testListConstraint" + System.currentTimeMillis();
        CustomModelConstraint inlineListConstraint = new CustomModelConstraint();
        inlineListConstraint.setName(inlineListConstraintName);
        inlineListConstraint.setType("LIST");
        inlineListConstraint.setTitle("test List title");
        inlineListConstraint.setDescription("test List desc");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(3);
        parameters.add(this.buildNamedValue("allowedValues", null, "a", "b", "c"));
        parameters.add(this.buildNamedValue("sorted", "false", new String[0]));
        inlineListConstraint.setParameters(parameters);
        aspectProp.setConstraints(Arrays.asList(inlineListConstraint));
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        parameters = new ArrayList(3);
        parameters.add(this.buildNamedValue("allowedValues", null, "1.0", "2.0", "3.0"));
        parameters.add(this.buildNamedValue("sorted", "false", new String[0]));
        inlineListConstraint.setParameters(parameters);
        aspectProp.setConstraints(Arrays.asList(inlineListConstraint));
        props = new ArrayList(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
    }

    @Test
    public void testCreateMinMaxConstraintInvalid() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelMinMaxInvalid" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropName = "testAspect1Prop" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property title");
        aspectProp.setDataType("d:text");
        String minMaxConstraintName = "testMinMaxConstraint" + System.currentTimeMillis();
        CustomModelConstraint minMaxConstraint = new CustomModelConstraint();
        minMaxConstraint.setType("MINMAX");
        minMaxConstraint.setName(minMaxConstraintName);
        minMaxConstraint.setTitle("test MinMax title");
        minMaxConstraint.setDescription("test MinMax desc");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(2);
        parameters.add(this.buildNamedValue("maxValue", "100.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "0.0", new String[0]));
        minMaxConstraint.setParameters(parameters);
        aspectProp.setConstraints(Arrays.asList(minMaxConstraint));
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDataType("d:datetime");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDataType("d:double");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxValue", "0.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "-5.0", new String[0]));
        minMaxConstraint.setParameters(parameters);
        aspectProp.setConstraints(Arrays.asList(minMaxConstraint));
        props = new ArrayList(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
    }

    @Test
    public void testPropDefaultValueWithInlineConstraint() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelInlineConstraint" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String regExConstraintName = "testInlineFileNameRegEx" + System.currentTimeMillis();
        CustomModelConstraint inlineRegExConstraint = new CustomModelConstraint();
        inlineRegExConstraint.setName(regExConstraintName);
        inlineRegExConstraint.setType("REGEX");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(2);
        parameters.add(this.buildNamedValue("expression", "(.*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$)", new String[0]));
        parameters.add(this.buildNamedValue("requiresMatch", "false", new String[0]));
        inlineRegExConstraint.setParameters(parameters);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropName = "testAspect1Prop1" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property with REGEX constraint");
        aspectProp.setDataType("d:text");
        aspectProp.setDefaultValue("invalid<defaultValue");
        aspectProp.setConstraints(Arrays.asList(inlineRegExConstraint));
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 409);
        CustomModelConstraint inlineAnonymousLengthConstraint = new CustomModelConstraint();
        inlineAnonymousLengthConstraint.setType("LENGTH");
        ArrayList<CustomModelNamedValue> parameters2 = new ArrayList<CustomModelNamedValue>(2);
        parameters2.add(this.buildNamedValue("maxLength", "4", new String[0]));
        parameters2.add(this.buildNamedValue("minLength", "0", new String[0]));
        inlineAnonymousLengthConstraint.setParameters(parameters2);
        String typeName = "testType1" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, typeName, "test type1 title", "test type1 Desc", "cm:content");
        CustomType typePayload = new CustomType();
        typePayload.setName(typeName);
        String typePropName = "testType1Prop1" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setTitle("property with LENGTH constraint");
        typeProp.setDataType("d:text");
        typeProp.setDefaultValue("abcdef");
        typeProp.setConstraints(Arrays.asList(inlineAnonymousLengthConstraint));
        ArrayList<CustomModelProperty> props2 = new ArrayList<CustomModelProperty>(1);
        props2.add(typeProp);
        typePayload.setProperties(props2);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 409);
        CustomModelConstraint inlineAnonymousMinMaxConstraint = new CustomModelConstraint();
        inlineAnonymousMinMaxConstraint.setType("MINMAX");
        parameters2 = new ArrayList(2);
        parameters2.add(this.buildNamedValue("maxValue", "10", new String[0]));
        parameters2.add(this.buildNamedValue("minValue", "0", new String[0]));
        inlineAnonymousMinMaxConstraint.setParameters(parameters2);
        typeName = "testType1" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, typeName, "test type1 title", "test type1 Desc", "cm:content");
        typePayload = new CustomType();
        typePayload.setName(typeName);
        typePropName = "testType1Prop1" + System.currentTimeMillis();
        typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setTitle("property with MINMAX constraint");
        typeProp.setDataType("d:int");
        typeProp.setDefaultValue("20");
        typeProp.setConstraints(Arrays.asList(inlineAnonymousMinMaxConstraint));
        props2 = new ArrayList(1);
        props2.add(typeProp);
        typePayload.setProperties(props2);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 409);
        String listConstraintName = "testListConstraint" + System.currentTimeMillis();
        CustomModelConstraint inlineListConstraint = new CustomModelConstraint();
        inlineListConstraint.setName(listConstraintName);
        inlineListConstraint.setType("LIST");
        parameters = new ArrayList(3);
        parameters.add(this.buildNamedValue("allowedValues", null, "one", "two", "three"));
        parameters.add(this.buildNamedValue("sorted", "false", new String[0]));
        inlineListConstraint.setParameters(parameters);
        aspectName = "testAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        aspectPropName = "testAspect1Prop" + System.currentTimeMillis();
        aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property with LIST constraint");
        aspectProp.setDataType("d:text");
        aspectProp.setDefaultValue("four");
        aspectProp.setConstraints(Arrays.asList(inlineListConstraint));
        props = new ArrayList(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 409);
        String inlineJavaClassConstraintName = "testJavaClassConstraint" + System.currentTimeMillis();
        inlineListConstraint = new CustomModelConstraint();
        inlineListConstraint.setName(inlineJavaClassConstraintName);
        inlineListConstraint.setType("org.alfresco.rest.api.tests.TestCustomConstraint$DummyJavaClassConstraint");
        String aspectName2 = "testAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName2, "title", "desc", null);
        CustomAspect aspectPayload2 = new CustomAspect();
        aspectPayload2.setName(aspectName2);
        String aspectPropName2 = "testAspect1Prop" + System.currentTimeMillis();
        CustomModelProperty aspectProp2 = new CustomModelProperty();
        aspectProp2.setName(aspectPropName2);
        aspectProp2.setTitle("property with Java Class constraint");
        aspectProp2.setDataType("d:text");
        aspectProp2.setDefaultValue("invalid#value");
        aspectProp2.setConstraints(Arrays.asList(inlineListConstraint));
        props2 = new ArrayList(1);
        props2.add(aspectProp2);
        aspectPayload2.setProperties(props2);
        this.put("cmm/" + modelName + "/aspects", aspectName2, RestApiUtil.toJsonAsString(aspectPayload2), "?select=props", 409);
    }

    @Test
    public void testPropDefaultValueWithConstraintRef() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelConstraintRef" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String listConstraintName = "testListConstraint" + System.currentTimeMillis();
        CustomModelConstraint listConstraint = new CustomModelConstraint();
        listConstraint.setName(listConstraintName);
        listConstraint.setType("LIST");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(3);
        parameters.add(this.buildNamedValue("allowedValues", null, "London", "Paris", "New York"));
        parameters.add(this.buildNamedValue("sorted", "false", new String[0]));
        listConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(listConstraint), 201);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/constraints", listConstraintName, 200);
        CustomModelConstraint returnedConstraint = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelConstraint.class);
        String aspectName = "testAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropName = "testAspect1Prop" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property with LIST constraint ref");
        aspectProp.setDataType("d:text");
        aspectProp.setDefaultValue("Berlin");
        aspectProp.setConstraintRefs(Arrays.asList(returnedConstraint.getPrefixedName()));
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 409);
        String minMaxConstraintName = "testMinMaxConstraint" + System.currentTimeMillis();
        CustomModelConstraint minMaxConstraint = new CustomModelConstraint();
        minMaxConstraint.setName(minMaxConstraintName);
        minMaxConstraint.setType("MINMAX");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxValue", "100", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "50", new String[0]));
        minMaxConstraint.setParameters(parameters);
        this.post("cmm/" + modelName + "/constraints", RestApiUtil.toJsonAsString(minMaxConstraint), 201);
        response = this.getSingle("cmm/" + modelName + "/constraints", minMaxConstraintName, 200);
        returnedConstraint = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelConstraint.class);
        String typeName = "testType1" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, typeName, "test type1 title", "test type1 Desc", "cm:content");
        CustomType typePayload = new CustomType();
        typePayload.setName(typeName);
        String typePropName = "testType1Prop1" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setTitle("property with MINMAX constraint ref");
        typeProp.setDataType("d:int");
        typeProp.setDefaultValue("35");
        typeProp.setConstraintRefs(Arrays.asList(returnedConstraint.getPrefixedName()));
        props = new ArrayList(1);
        props.add(typeProp);
        typePayload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 409);
    }

    public static class DummyJavaClassConstraint
    extends AbstractConstraint {
        protected void evaluateSingleValue(Object value) {
            String checkValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, value);
            if (checkValue.contains("#")) {
                throw new ConstraintException("The value must not contain '#'", new Object[0]);
            }
        }
    }
}

