/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.jacksonextensions;

import java.util.Set;

public class BeanPropertiesFilter {
    private final Set<String> filteredProperties;
    public static final BeanPropertiesFilter ALLOW_ALL = new AllProperties();

    public BeanPropertiesFilter(Set<String> properties) {
        this.filteredProperties = properties;
    }

    public boolean isAllowed(String propertyName) {
        return this.filteredProperties.contains(propertyName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BeanPropertiesFilter [filteredProperties=").append(this.filteredProperties).append("]");
        return builder.toString();
    }

    public static class AllProperties
    extends BeanPropertiesFilter {
        public AllProperties() {
            super(null);
        }

        @Override
        public boolean isAllowed(String propertyName) {
            return true;
        }
    }
}

