/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class PublicApiTestContext {
    private ApplicationContext applicationContext;
    private BaseWebScriptTest test;
    private List<String> usersToBeTidied = new ArrayList<String>();
    private List<String> invalidDomainsToBeTidied = new ArrayList<String>();
    private MutableAuthenticationService authenticationService;
    private RetryingTransactionHelper transactionHelper;

    public PublicApiTestContext() {
        this.init(ApplicationContextHelper.getApplicationContext());
    }

    public PublicApiTestContext(ApplicationContext context) {
        this.init(context);
    }

    public PublicApiTestContext(BaseWebScriptTest test) {
        this.test = test;
        this.test.setCustomContext("cloud-test-context.xml");
        this.init(test.getServer().getApplicationContext());
    }

    private void init(ApplicationContext context) {
        this.applicationContext = context;
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public TestWebScriptServer getTestServer() {
        return this.test.getServer();
    }

    public String createUserName(String alias, String tenant) {
        StringBuilder sb = new StringBuilder();
        sb.append(alias);
        if (tenant != null && !tenant.equals("") && !alias.contains("@")) {
            sb.append("@");
            sb.append(tenant);
        }
        return sb.toString();
    }

    public void addUser(String user) {
        this.usersToBeTidied.add(user);
    }

    public void addInvalidDomain(String domain) {
        this.invalidDomainsToBeTidied.add(domain);
    }

    public void removeInvalidDomain(String domain) {
        this.invalidDomainsToBeTidied.remove(domain);
    }

    public void cleanup() {
        AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                PublicApiTestContext.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        return null;
                    }
                });
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getSystemUserName());
        for (final String user : this.usersToBeTidied) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    if (PublicApiTestContext.this.authenticationService.authenticationExists(user)) {
                        PublicApiTestContext.this.authenticationService.deleteAuthentication(user);
                    }
                    return null;
                }
            });
        }
        this.usersToBeTidied.clear();
        AuthenticationUtil.clearCurrentSecurityContext();
    }
}

