/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.Authorization;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.auth.AuthenticationDriver;
import org.alfresco.repo.webdav.auth.WebDAVUser;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSOFallbackBasicAuthenticationDriver
implements AuthenticationDriver {
    private Log logger = LogFactory.getLog(SSOFallbackBasicAuthenticationDriver.class);
    private AuthenticationService authenticationService;
    private PersonService personService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private String userAttributeName = "_alfAuthTicket";

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setUserAttributeName(String userAttributeName) {
        this.userAttributeName = userAttributeName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean authenticateRequest(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        SessionUser user;
        String authHdr = request.getHeader("Authorization");
        HttpSession session = request.getSession(false);
        SessionUser sessionUser = user = session == null ? null : (SessionUser)session.getAttribute(this.userAttributeName);
        if (user == null) {
            if (authHdr == null || authHdr.length() <= 5 || !authHdr.substring(0, 5).equalsIgnoreCase("Basic")) return false;
            String basicAuth = new String(Base64.decodeBase64((byte[])authHdr.substring(5).getBytes()));
            String username = null;
            String password = null;
            int pos = basicAuth.indexOf(":");
            if (pos != -1) {
                username = basicAuth.substring(0, pos);
                password = basicAuth.substring(pos + 1);
            } else {
                username = basicAuth;
                password = "";
            }
            try {
                Authorization auth;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Authenticating user '" + AuthenticationUtil.maskUsername((String)username) + "'"));
                }
                if ((auth = new Authorization(username, password)).isTicket()) {
                    this.authenticationService.validate(auth.getTicket());
                } else {
                    this.authenticationService.authenticate(username, password.toCharArray());
                }
                RetryingTransactionHelper.RetryingTransactionCallback<SessionUser> callback = new RetryingTransactionHelper.RetryingTransactionCallback<SessionUser>(){

                    public SessionUser execute() throws Throwable {
                        NodeRef personNodeRef = SSOFallbackBasicAuthenticationDriver.this.personService.getPerson(SSOFallbackBasicAuthenticationDriver.this.authenticationService.getCurrentUserName());
                        String username = (String)((Object)SSOFallbackBasicAuthenticationDriver.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
                        NodeRef homeSpaceRef = (NodeRef)SSOFallbackBasicAuthenticationDriver.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
                        return new WebDAVUser(username, SSOFallbackBasicAuthenticationDriver.this.authenticationService.getCurrentTicket(), homeSpaceRef);
                    }
                };
                user = (SessionUser)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SessionUser>(){
                    final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$callback;
                    {
                        this.val$callback = retryingTransactionCallback;
                    }

                    public SessionUser doWork() throws Exception {
                        return (SessionUser)SSOFallbackBasicAuthenticationDriver.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.val$callback, true);
                    }
                }, (String)"System");
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Authenticated user '" + AuthenticationUtil.maskUsername((String)username) + "'"));
                }
                request.getSession().setAttribute(this.userAttributeName, (Object)user);
                return true;
            }
            catch (AuthenticationException ex) {
                if (!this.logger.isDebugEnabled()) return false;
                this.logger.debug((Object)ex.getMessage(), (Throwable)ex);
                return false;
            }
        } else {
            try {
                this.authenticationService.validate(user.getTicket());
                return true;
            }
            catch (AuthenticationException ex) {
                session.invalidate();
                if (!this.logger.isDebugEnabled()) return false;
                this.logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public void restartLoginChallenge(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Including Basic HTTP authentication into response headers...");
        }
        response.addHeader("WWW-Authenticate", "Basic realm=\"Alfresco Server\"");
        response.setStatus(401);
    }
}

