/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.workflow.api.impl.TypeDefinitionContext;
import org.alfresco.rest.workflow.api.model.TaskVariable;
import org.alfresco.rest.workflow.api.model.Variable;
import org.alfresco.rest.workflow.api.model.VariableScope;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class RestVariableHelper {
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private WorkflowQNameConverter qNameConverter;
    private DictionaryService dictionaryService;
    public static final Set<String> INTERNAL_PROPERTIES = new HashSet<String>(Arrays.asList("_tenant_domain"));

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected WorkflowQNameConverter getQNameConverter() {
        if (this.qNameConverter == null) {
            this.qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)this.namespaceService);
        }
        return this.qNameConverter;
    }

    public List<TaskVariable> getTaskVariables(Map<String, Object> localVariables, Map<String, Object> globalVariables, TypeDefinition startFormTypeDefinition, TypeDefinition taskTypeDefinition) {
        TypeDefinitionContext context;
        ArrayList<TaskVariable> result = new ArrayList<TaskVariable>();
        if (localVariables != null && localVariables.size() > 0) {
            context = new TypeDefinitionContext(taskTypeDefinition, this.getQNameConverter());
            this.addTaskVariables(result, localVariables, context, VariableScope.LOCAL);
        }
        if (globalVariables != null && globalVariables.size() > 0) {
            context = new TypeDefinitionContext(startFormTypeDefinition, this.getQNameConverter());
            this.addTaskVariables(result, globalVariables, context, VariableScope.GLOBAL);
        }
        return result;
    }

    public List<Variable> getVariables(Map<String, Object> variables, TypeDefinition typeDefinition) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        TypeDefinitionContext context = new TypeDefinitionContext(typeDefinition, this.getQNameConverter());
        Variable variable = null;
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            if (INTERNAL_PROPERTIES.contains(entry.getKey())) continue;
            variable = new Variable();
            variable.setName(entry.getKey());
            this.setVariableValueAndType(variable, entry.getValue(), context);
            result.add(variable);
        }
        return result;
    }

    public void addTaskVariables(List<TaskVariable> result, Map<String, Object> variables, TypeDefinitionContext context, VariableScope scope) {
        TaskVariable variable = null;
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            if (INTERNAL_PROPERTIES.contains(entry.getKey())) continue;
            variable = new TaskVariable();
            variable.setName(entry.getKey());
            variable.setVariableScope(scope);
            this.setVariableValueAndType(variable, entry.getValue(), context);
            result.add(variable);
        }
    }

    protected void setVariableValueAndType(Variable variable, Object value, TypeDefinitionContext context) {
        PropertyDefinition propDef = context.getPropertyDefinition(variable.getName());
        if (propDef != null) {
            variable.setValue(this.getSafePropertyValue(value));
            variable.setType(propDef.getDataType().getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        } else {
            String[] prefixLocalName;
            AssociationDefinition assocDef = context.getAssociationDefinition(variable.getName());
            if (assocDef == null && (prefixLocalName = variable.getName().split("_")).length == 2) {
                QName qName = QName.createQName((String)prefixLocalName[0], (String)prefixLocalName[1], (NamespacePrefixResolver)this.namespaceService);
                assocDef = this.dictionaryService.getAssociation(qName);
            }
            if (assocDef != null) {
                variable.setType(assocDef.getTargetClass().getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
                variable.setValue(this.getAssociationRepresentation(value, assocDef));
            } else {
                variable.setValue(this.getSafePropertyValue(value));
                variable.setType(this.extractTypeStringFromValue(value));
            }
        }
    }

    protected Object getAssociationRepresentation(Object value, AssociationDefinition assocDef) {
        Object result = null;
        if (value != null) {
            if (assocDef.isTargetMany()) {
                ArrayList<String> list = new ArrayList<String>();
                if (value instanceof Collection) {
                    for (Object entry : (Collection)value) {
                        list.add(this.getRepresentationForNodeRef(entry, assocDef.getTargetClass()));
                    }
                } else {
                    list.add(this.getRepresentationForNodeRef(value, assocDef.getTargetClass()));
                }
                result = list;
            } else {
                result = this.getRepresentationForNodeRef(value, assocDef.getTargetClass());
            }
        }
        return result;
    }

    protected Object getSafePropertyValue(Object value) {
        if (value instanceof NodeRef) {
            return ((Object)value).toString();
        }
        if (value instanceof ScriptNode) {
            NodeRef ref = ((ScriptNode)value).getNodeRef();
            try {
                QName nodeQName = this.nodeService.getType(ref);
                if (ContentModel.TYPE_PERSON.equals((Object)nodeQName)) {
                    return (String)((Object)this.nodeService.getProperty(ref, ContentModel.PROP_USERNAME));
                }
                if (ContentModel.TYPE_AUTHORITY_CONTAINER.equals((Object)nodeQName)) {
                    return (String)((Object)this.nodeService.getProperty(ref, ContentModel.PROP_AUTHORITY_NAME));
                }
                return ((ScriptNode)value).getNodeRef().toString();
            }
            catch (Exception e) {
                return ((ScriptNode)value).getNodeRef().toString();
            }
        }
        if (value instanceof QName) {
            return ((QName)value).toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        if (value instanceof Collection && value != null) {
            ArrayList<Object> resultValues = new ArrayList<Object>();
            for (Object itemValue : (Collection)value) {
                resultValues.add(this.getSafePropertyValue(itemValue));
            }
            value = resultValues;
        }
        return value;
    }

    protected String getRepresentationForNodeRef(Object value, ClassDefinition classDefinition) {
        NodeRef ref = null;
        if (value instanceof NodeRef) {
            ref = (NodeRef)value;
        } else if (value instanceof ScriptNode) {
            ref = ((ScriptNode)value).getNodeRef();
        } else if (value instanceof String) {
            return (String)value;
        }
        if (ref != null) {
            if (ContentModel.TYPE_PERSON.equals((Object)classDefinition.getName())) {
                return (String)((Object)this.nodeService.getProperty(ref, ContentModel.PROP_USERNAME));
            }
            return ref.toString();
        }
        throw new ApiException("Association value did not contian valid nodeRef: " + String.valueOf(value));
    }

    public QName extractTypeFromValue(Object value) {
        QName type = null;
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() > 0) {
                type = this.extractTypeFromValue(collection.iterator().next());
            }
        } else if (value instanceof String) {
            type = DataTypeDefinition.TEXT;
        } else if (value instanceof Integer) {
            type = DataTypeDefinition.INT;
        } else if (value instanceof Long) {
            type = DataTypeDefinition.LONG;
        } else if (value instanceof Double) {
            type = DataTypeDefinition.DOUBLE;
        } else if (value instanceof Float) {
            type = DataTypeDefinition.FLOAT;
        } else if (value instanceof Date) {
            type = DataTypeDefinition.DATETIME;
        } else if (value instanceof Boolean) {
            type = DataTypeDefinition.BOOLEAN;
        } else if (value instanceof QName) {
            type = DataTypeDefinition.QNAME;
        } else if (value instanceof NodeRef || value instanceof ScriptNode) {
            type = DataTypeDefinition.NODE_REF;
        }
        if (type == null) {
            type = DataTypeDefinition.ANY;
        }
        return type;
    }

    public String extractTypeStringFromValue(Object value) {
        QName type = this.extractTypeFromValue(value);
        return type.toPrefixString((NamespacePrefixResolver)this.namespaceService);
    }
}

