/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LoginTicketDelete
extends DeclarativeWebScript {
    private AuthenticationService authenticationService;
    private TicketComponent ticketComponent;

    public void setTicketComponent(TicketComponent ticketComponent) {
        this.ticketComponent = ticketComponent;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        String ticket = req.getExtensionPath();
        if (ticket == null || ticket.length() == 0) {
            throw new WebScriptException(400, "Ticket not specified");
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("ticket", ticket);
        try {
            String ticketUser = this.ticketComponent.validateTicket(ticket);
            if (!AuthenticationUtil.getFullyAuthenticatedUser().equals(ticketUser)) {
                status.setCode(404);
                status.setMessage("Ticket not found");
            } else {
                this.authenticationService.invalidateTicket(ticket);
                status.setMessage("Deleted Ticket " + ticket);
            }
        }
        catch (AuthenticationException e) {
            status.setCode(404);
            status.setMessage("Ticket not found");
        }
        status.setRedirect(true);
        return model;
    }
}

