/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.doclink;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.DocumentLinkService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.json.JSONWriter;

public abstract class AbstractDocLink
extends DeclarativeWebScript {
    private static String PARAM_STORE_TYPE = "store_type";
    private static String PARAM_STORE_ID = "store_id";
    private static String PARAM_ID = "id";
    private static String PARAM_SITE = "site";
    private static String PARAM_CONTAINER = "container";
    private static String PARAM_PATH = "path";
    private static final String ACTIVITY_TOOL = "documentLinkService";
    protected NodeService nodeService;
    protected SiteService siteService;
    protected DocumentLinkService documentLinkService;
    protected ActivityService activityService;
    protected ServiceRegistry serviceRegistry;
    private static Log logger = LogFactory.getLog(AbstractDocLink.class);

    protected NodeRef parseNodeRefFromTemplateArgs(Map<String, String> templateVars) {
        if (templateVars == null) {
            return null;
        }
        String storeTypeArg = templateVars.get(PARAM_STORE_TYPE);
        String storeIdArg = templateVars.get(PARAM_STORE_ID);
        String idArg = templateVars.get(PARAM_ID);
        if (storeTypeArg != null) {
            ParameterCheck.mandatoryString((String)"storeTypeArg", (String)storeTypeArg);
            ParameterCheck.mandatoryString((String)"storeIdArg", (String)storeIdArg);
            ParameterCheck.mandatoryString((String)"idArg", (String)idArg);
            return new NodeRef(storeTypeArg, storeIdArg, idArg);
        }
        String siteArg = templateVars.get(PARAM_SITE);
        String containerArg = templateVars.get(PARAM_CONTAINER);
        String pathArg = templateVars.get(PARAM_PATH);
        if (siteArg != null) {
            ParameterCheck.mandatoryString((String)"siteArg", (String)siteArg);
            ParameterCheck.mandatoryString((String)"containerArg", (String)containerArg);
            SiteInfo site = this.siteService.getSite(siteArg);
            PropertyCheck.mandatory((Object)((Object)this), (String)"site", (Object)site);
            NodeRef node = this.siteService.getContainer(site.getShortName(), containerArg);
            if (node == null) {
                throw new WebScriptException(400, "Invalid 'container' variable");
            }
            if (pathArg != null) {
                StringTokenizer st = new StringTokenizer(pathArg, "/");
                while (st.hasMoreTokens()) {
                    String childName = st.nextToken();
                    if ((node = this.nodeService.getChildByName(node, ContentModel.ASSOC_CONTAINS, childName)) != null) continue;
                    throw new WebScriptException(400, "Invalid 'path' variable");
                }
            }
            return node;
        }
        return null;
    }

    protected void addActivityEntry(String activityType, String title, String nodeRef, String site) {
        try {
            StringWriter activityJson = new StringWriter();
            JSONWriter activity = new JSONWriter((Writer)activityJson);
            activity.startObject();
            activity.writeValue("title", title);
            activity.writeValue("nodeRef", nodeRef);
            activity.writeValue("page", "document-details?nodeRef=" + nodeRef);
            activity.endObject();
            this.activityService.postActivity(activityType, site, ACTIVITY_TOOL, activityJson.toString());
        }
        catch (Exception e) {
            logger.warn((Object)"Error adding link event to activities feed", (Throwable)e);
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setDocumentLinkService(DocumentLinkService documentLinkService) {
        this.documentLinkService = documentLinkService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

