/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.web.scripts.RepositoryImageResolver;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.GUID;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class KeywordSearch
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(KeywordSearch.class);
    protected static final StoreRef SEARCH_STORE = new StoreRef("workspace", "SpacesStore");
    protected static final int DEFAULT_ITEMS_PER_PAGE = 10;
    protected static final String QUERY_FORMAT = "query_";
    protected ServiceRegistry serviceRegistry;
    protected RepositoryImageResolver imageResolver;
    protected SearchService searchService;
    protected NodeService nodeService;

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRepositoryImageResolver(RepositoryImageResolver imageResolver) {
        this.imageResolver = imageResolver;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        String searchTerms = req.getParameter("q");
        ParameterCheck.mandatoryString((String)"q", (String)searchTerms);
        String startPageArg = req.getParameter("p");
        int startPage = 1;
        try {
            startPage = Integer.valueOf(startPageArg);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String itemsPerPageArg = req.getParameter("c");
        int itemsPerPage = 10;
        try {
            itemsPerPage = Integer.valueOf(itemsPerPageArg);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Locale locale = I18NUtil.getLocale();
        String language = req.getParameter("l");
        if (language != null && language.length() > 0) {
            locale = new Locale(language.replace("-", "_"));
        }
        SearchResult results = this.search(searchTerms, startPage, itemsPerPage, locale, req);
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        model.put("search", results);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult search(String searchTerms, int startPage, int itemsPerPage, Locale locale, WebScriptRequest req) {
        SearchResult searchResult = null;
        try (ResultSet results = null;){
            String[] terms = searchTerms.split(" ");
            searchTerms = searchTerms.replaceAll("\"", "&quot;");
            for (int i = 0; i < terms.length; ++i) {
                terms[i] = SearchLanguageConversion.escapeLuceneQuery((String)terms[i]);
            }
            HashMap<String, Object> statementModel = new HashMap<String, Object>(7, 1.0f);
            statementModel.put("args", this.createArgs(req));
            statementModel.put("terms", terms);
            StringWriter queryWriter = new StringWriter(1024);
            this.renderFormatTemplate(QUERY_FORMAT, statementModel, queryWriter);
            String query = ((Object)queryWriter).toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Search parameters: searchTerms=" + searchTerms + ", startPage=" + startPage + ", itemsPerPage=" + itemsPerPage + ", search locale=" + locale.toString()));
                logger.debug((Object)("Issuing lucene search: " + query));
            }
            SearchParameters parameters = new SearchParameters();
            parameters.addStore(SEARCH_STORE);
            parameters.setLanguage("lucene");
            parameters.setQuery(query);
            if (locale != null) {
                parameters.addLocale(locale);
            }
            results = this.searchService.query(parameters);
            int totalResults = results.length();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Results: " + totalResults + " rows (limited: " + String.valueOf(results.getResultSetMetaData().getLimitedBy()) + ")"));
            }
            int totalPages = totalResults / itemsPerPage;
            if ((totalPages += totalResults % itemsPerPage != 0 ? 1 : 0) != 0 && (startPage < 1 || startPage > totalPages)) {
                throw new WebScriptException("Start page " + startPage + " is outside boundary of " + totalPages + " pages");
            }
            searchResult = new SearchResult();
            searchResult.setSearchTerms(searchTerms);
            searchResult.setLocale(locale);
            searchResult.setItemsPerPage(itemsPerPage);
            searchResult.setStartPage(startPage);
            searchResult.setTotalResults(totalResults);
            if (totalResults == 0) {
                searchResult.setTotalPages(0);
                searchResult.setStartIndex(0);
                searchResult.setTotalPageItems(0);
            } else {
                searchResult.setTotalPages(totalPages);
                searchResult.setStartIndex((startPage - 1) * itemsPerPage + 1);
                searchResult.setTotalPageItems(Math.min(itemsPerPage, totalResults - searchResult.getStartIndex() + 1));
            }
            SearchTemplateNode[] nodes = new SearchTemplateNode[searchResult.getTotalPageItems()];
            for (int i = 0; i < searchResult.getTotalPageItems(); ++i) {
                NodeRef node = results.getNodeRef(i + searchResult.getStartIndex() - 1);
                if (!this.nodeService.exists(node)) continue;
                float score = results.getScore(i + searchResult.getStartIndex() - 1);
                nodes[i] = new SearchTemplateNode(node, score);
            }
            searchResult.setResults(nodes);
            SearchResult searchResult2 = searchResult;
            return searchResult2;
        }
    }

    public static class SearchResult {
        private String id;
        private String searchTerms;
        private Locale locale;
        private int itemsPerPage;
        private int totalPages;
        private int totalResults;
        private int totalPageItems;
        private int startPage;
        private int startIndex;
        private SearchTemplateNode[] results;

        public int getItemsPerPage() {
            return this.itemsPerPage;
        }

        void setItemsPerPage(int itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
        }

        public TemplateNode[] getResults() {
            return this.results;
        }

        void setResults(SearchTemplateNode[] results) {
            this.results = results;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public int getStartPage() {
            return this.startPage;
        }

        void setStartPage(int startPage) {
            this.startPage = startPage;
        }

        public int getTotalPageItems() {
            return this.totalPageItems;
        }

        void setTotalPageItems(int totalPageItems) {
            this.totalPageItems = totalPageItems;
        }

        public int getTotalPages() {
            return this.totalPages;
        }

        void setTotalPages(int totalPages) {
            this.totalPages = totalPages;
        }

        public int getTotalResults() {
            return this.totalResults;
        }

        void setTotalResults(int totalResults) {
            this.totalResults = totalResults;
        }

        public String getSearchTerms() {
            return this.searchTerms;
        }

        void setSearchTerms(String searchTerms) {
            this.searchTerms = searchTerms;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getLocaleId() {
            return this.locale.toString().replace('_', '-');
        }

        void setLocale(Locale locale) {
            this.locale = locale;
        }

        public String getId() {
            if (this.id == null) {
                this.id = GUID.generate();
            }
            return this.id;
        }
    }

    public class SearchTemplateNode
    extends TemplateNode {
        protected static final String URL = "/api/node/content/{0}/{1}/{2}/{3}";
        private static final long serialVersionUID = -1791913270786140012L;
        private float score;

        public SearchTemplateNode(NodeRef nodeRef, float score) {
            super(nodeRef, KeywordSearch.this.serviceRegistry, KeywordSearch.this.imageResolver.getImageResolver());
            this.score = score;
        }

        public float getScore() {
            return this.score;
        }

        public String getUrl() {
            return MessageFormat.format(URL, this.getNodeRef().getStoreRef().getProtocol(), this.getNodeRef().getStoreRef().getIdentifier(), this.getNodeRef().getId(), URLEncoder.encode((String)this.getName()));
        }
    }
}

