/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.SpoofedTextContentReader;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RemoteFileFolderLoaderTest
extends BaseWebScriptTest {
    public static final String URL = "/api/model/filefolder/load";
    private Repository repositoryHelper;
    private NodeService nodeService;
    private TransactionService transactionService;
    private FileFolderService fileFolderService;
    private String sharedHomePath;
    private NodeRef loadHomeNodeRef;
    private String loadHomePath;

    protected void setUp() throws Exception {
        super.setUp();
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("nodeService");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("TransactionService");
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        final NodeRef companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
        final NodeRef sharedHomeNodeRef = this.repositoryHelper.getSharedHome();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createFolderWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                List sharedHomeFileInfos = RemoteFileFolderLoaderTest.this.fileFolderService.getNamePath(companyHomeNodeRef, sharedHomeNodeRef);
                RemoteFileFolderLoaderTest.this.sharedHomePath = "/" + ((FileInfo)sharedHomeFileInfos.get(0)).getName();
                String folderName = UUID.randomUUID().toString();
                FileInfo folderInfo = RemoteFileFolderLoaderTest.this.fileFolderService.create(sharedHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                RemoteFileFolderLoaderTest.this.loadHomePath = RemoteFileFolderLoaderTest.this.sharedHomePath + "/" + folderName;
                return folderInfo.getNodeRef();
            }
        };
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.loadHomeNodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFolderWork);
    }

    protected void tearDown() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteFolderWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                RemoteFileFolderLoaderTest.this.fileFolderService.delete(RemoteFileFolderLoaderTest.this.loadHomeNodeRef);
                return null;
            }
        };
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteFolderWork);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    public void testLoad_noFolderPath() throws Exception {
        JSONObject body = new JSONObject();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL, body.toString(), "application/json"), 400, "bmarley");
    }

    public void testLoad_default_default() throws Exception {
        JSONObject body = new JSONObject();
        body.put((Object)"folderPath", (Object)this.loadHomePath);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL, body.toString(), "application/json"), 200, "bmarley");
        RemoteFileFolderLoaderTest.assertEquals((String)"{\"count\":100}", (String)response.getContentAsString());
        RemoteFileFolderLoaderTest.assertEquals((int)100, (int)this.nodeService.countChildAssocs(this.loadHomeNodeRef, true));
    }

    public void testLoad_15_default() throws Exception {
        JSONObject body = new JSONObject();
        body.put((Object)"folderPath", (Object)this.loadHomePath);
        body.put((Object)"fileCount", (Object)15);
        body.put((Object)"filesPerTxn", (Object)10);
        TestWebScriptServer.Response response = null;
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)"hhoudini");
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL, body.toString(), "application/json"), 200, "hhoudini");
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        RemoteFileFolderLoaderTest.assertEquals((String)"{\"count\":15}", (String)response.getContentAsString());
        RemoteFileFolderLoaderTest.assertEquals((int)15, (int)this.nodeService.countChildAssocs(this.loadHomeNodeRef, true));
        List fileInfos = this.fileFolderService.list(this.loadHomeNodeRef);
        for (FileInfo fileInfo : fileInfos) {
            NodeRef fileNodeRef = fileInfo.getNodeRef();
            ContentReader reader = this.fileFolderService.getReader(fileNodeRef);
            RemoteFileFolderLoaderTest.assertTrue((boolean)reader.getContentUrl().startsWith("spoof"));
            RemoteFileFolderLoaderTest.assertTrue((String)("Default file size not correct: " + String.valueOf(reader)), (81920L < reader.getSize() && reader.getSize() < 122880L ? 1 : 0) != 0);
            RemoteFileFolderLoaderTest.assertEquals((Object)"hhoudini", (Object)this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_CREATOR));
            String description = (String)((Object)this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION));
            RemoteFileFolderLoaderTest.assertNotNull((String)"No description", (Object)description);
            RemoteFileFolderLoaderTest.assertEquals((String)("Description length incorrect: \"" + description + "\""), (long)128L, (long)description.getBytes("UTF-8").length);
        }
    }

    public void testLoad_15_16bytes() throws Exception {
        JSONObject body = new JSONObject();
        body.put((Object)"folderPath", (Object)this.loadHomePath);
        body.put((Object)"minFileSize", (Object)16L);
        body.put((Object)"maxFileSize", (Object)16L);
        body.put((Object)"maxUniqueDocuments", (Object)1L);
        body.put((Object)"forceBinaryStorage", (Object)Boolean.TRUE);
        TestWebScriptServer.Response response = null;
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)"maggi");
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL, body.toString(), "application/json"), 200, "maggi");
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        RemoteFileFolderLoaderTest.assertEquals((String)"{\"count\":100}", (String)response.getContentAsString());
        RemoteFileFolderLoaderTest.assertEquals((int)100, (int)this.nodeService.countChildAssocs(this.loadHomeNodeRef, true));
        String contentUrlCheck = SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)0L, (long)16L, (String[])new String[0]);
        SpoofedTextContentReader readerCheck = new SpoofedTextContentReader(contentUrlCheck);
        String textCheck = readerCheck.getContentString();
        List fileInfos = this.fileFolderService.list(this.loadHomeNodeRef);
        for (FileInfo fileInfo : fileInfos) {
            NodeRef fileNodeRef = fileInfo.getNodeRef();
            ContentReader reader = this.fileFolderService.getReader(fileNodeRef);
            RemoteFileFolderLoaderTest.assertTrue((boolean)reader.getContentUrl().startsWith("store"));
            String text = reader.getContentString();
            RemoteFileFolderLoaderTest.assertEquals((String)"Text not the same.", (String)textCheck, (String)text);
        }
    }
}

