/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.tests.BaseModelApiTest;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Type;
import org.junit.Assert;
import org.junit.Test;

public class TestTypes
extends BaseModelApiTest {
    @Test
    public void testAllTypes() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertTrue((this.types.getPaging().getTotalItems() > 135 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.types.getPaging().getHasMoreItems());
        this.paging.setSkipCount(130);
        this.paging.setMaxItems(50);
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertFalse((boolean)this.types.getPaging().getHasMoreItems());
    }

    @Test
    public void filterTypesByNamespace() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        ((Type)this.types.getList().get(0)).expected(this.docType);
        ((Type)this.types.getList().get(1)).expected(this.whitePaperType);
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)2);
        this.otherParams.put("where", "(not namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertTrue((this.types.getPaging().getTotalItems() > 130 ? 1 : 0) != 0);
    }

    @Test
    public void filterTypesByParentId() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(parentId in ('cm:content'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        int total = this.types.getPaging().getTotalItems();
        this.otherParams.put("where", "(parentId in ('cm:content') AND namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        ((Type)this.types.getList().get(0)).expected(this.docType);
        ((Type)this.types.getList().get(1)).expected(this.whitePaperType);
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)2);
        this.otherParams.put("where", "(parentId in ('cm:content') AND not namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)(total - 2));
        this.otherParams.put("where", "(parentId in ('cm:content') AND namespaceUri matches('.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)total);
        this.otherParams.put("where", "(parentId in ('cm:content') AND not namespaceUri matches('.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)0);
    }

    @Test
    public void filterTypesByModelId() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)4);
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        ((Type)this.types.getList().get(0)).expected(this.docType);
        ((Type)this.types.getList().get(1)).expected(this.whitePaperType);
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)2);
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND not namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)2);
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND namespaceUri matches('.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)4);
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND not namespaceUri matches('.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)0);
    }

    @Test
    public void testIncludeProperty() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)4);
        Assert.assertNull((Object)((Type)this.types.getList().get(0)).getProperties());
        Assert.assertNull((Object)((Type)this.types.getList().get(1)).getProperties());
        Assert.assertNull((Object)((Type)this.types.getList().get(2)).getProperties());
        this.otherParams.put("where", "(modelId in ('mycompany:model','test:scan') AND namespaceUri matches('http://www.mycompany.com/model.*'))");
        this.otherParams.put("include", "properties");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        ((Type)this.types.getList().get(0)).expected(this.docType);
        ((Type)this.types.getList().get(1)).expected(this.whitePaperType);
        Assert.assertNotNull((Object)((Type)this.types.getList().get(0)).getProperties());
        Assert.assertNotNull((Object)((Type)this.types.getList().get(1)).getProperties());
    }

    @Test
    public void testIncludeAssociation() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('api:apiModel'))");
        this.otherParams.put("include", "associations");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)10);
        for (int i = 0; i < this.types.getList().size(); ++i) {
            Type type = (Type)this.types.getList().get(i);
            Assert.assertNotNull((Object)type.getAssociations());
            Assert.assertNull((Object)type.getProperties());
            Assert.assertNull((Object)type.getMandatoryAspects());
            type.expected(this.allTypes.get(i));
            Assert.assertEquals((Object)type.getAssociations(), (Object)((Type)this.allTypes.get(i)).getAssociations());
        }
    }

    @Test
    public void testIncludeMandatoryAspect() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('api:apiModel'))");
        this.otherParams.put("include", "mandatoryAspects");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        for (int i = 0; i < this.types.getList().size(); ++i) {
            Type type = (Type)this.types.getList().get(i);
            Assert.assertNotNull((Object)type.getMandatoryAspects());
            Assert.assertNull((Object)type.getProperties());
            Assert.assertNull((Object)type.getAssociations());
            type.expected(this.allTypes.get(i));
            Assert.assertEquals((Object)type.getMandatoryAspects(), (Object)((Type)this.allTypes.get(i)).getMandatoryAspects());
        }
    }

    @Test
    public void testIncludes() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('api:apiModel'))");
        this.otherParams.put("include", "associations,mandatoryAspects");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)10);
        for (int i = 0; i < this.types.getList().size(); ++i) {
            Type type = (Type)this.types.getList().get(i);
            Assert.assertNotNull((Object)type.getAssociations());
            Assert.assertNull((Object)type.getProperties());
            Assert.assertNotNull((Object)type.getMandatoryAspects());
            type.expected(this.allTypes.get(i));
            Assert.assertEquals((Object)type.getMandatoryAspects(), (Object)((Type)this.allTypes.get(i)).getMandatoryAspects());
            Assert.assertEquals((Object)type.getAssociations(), (Object)((Type)this.allTypes.get(i)).getAssociations());
        }
    }

    @Test
    public void testSubTypes() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.otherParams.put("where", "(modelId in ('mycompany:model'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)2);
        ((Type)this.types.getList().get(0)).expected(this.docType);
        ((Type)this.types.getList().get(1)).expected(this.whitePaperType);
        this.otherParams.put("where", "(modelId in ('mycompany:model INCLUDESUBTYPES'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)3);
        ((Type)this.types.getList().get(0)).expected(this.docType);
        ((Type)this.types.getList().get(1)).expected(this.whitePaperType);
        ((Type)this.types.getList().get(2)).expected(this.publishableType);
        this.otherParams.put("where", "(modelId in ('mycompany:model INCLUDESUBTYPES') AND namespaceUri matches('http://www.test.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        Assert.assertEquals((Object)this.types.getPaging().getTotalItems(), (Object)1);
        ((Type)this.types.getList().get(0)).expected(this.publishableType);
        this.otherParams.put("where", "(modelId in ('mycompany:model INCLUDESUBTYPES') AND not namespaceUri matches('http://www.test.*'))");
        this.types = this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
        ((Type)this.types.getList().get(0)).expected(this.docType);
        ((Type)this.types.getList().get(1)).expected(this.whitePaperType);
    }

    @Test
    public void testTypesById() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.type = this.publicApiClient.types().getType("mycompany:whitepaper");
        this.type.expected(this.whitePaperType);
        this.type = this.publicApiClient.types().getType(this.apiBaseType.getId());
        this.type.expected(this.apiBaseType);
        Assert.assertNotNull((Object)this.type.getProperties());
        Assert.assertEquals((Object)this.type.getMandatoryAspects(), (Object)this.apiBaseType.getMandatoryAspects());
        Assert.assertEquals((Object)this.type.getAssociations(), (Object)this.apiBaseType.getAssociations());
    }

    @Test
    public void testListTypeByInvalidValue() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.testListTypeException("(modelId in ('mycompany:model','unknown:model'))");
        this.testListTypeException("(modelId in ('unknown:model','unknown1:another'))");
        this.testListTypeException("(modelId in (' ', '')");
        this.testListTypeException("(parentId in ('cm:content','unknown:type')");
        this.testListTypeException("(parentId in ('unknown:type','cm:content'))");
        this.testListTypeException("(parentId in ('unknown:type','unknown:types'))");
        this.testListTypeException("(parentId in (' ',' ',' '))");
        this.testListTypeException("");
        this.testListTypeException("(namespaceUri matches('*'))");
    }

    @Test
    public void testGetTypeByInvalidValue() throws PublicApiException {
        AuthenticationUtil.setRunAsUser((String)user1);
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), user1));
        this.testGetTypeExceptions("unknown:childType");
        this.testGetTypeExceptions("type:");
        this.testGetTypeExceptions("type");
    }

    private void testGetTypeExceptions(String typeId) {
        try {
            this.publicApiClient.types().getType(typeId);
            Assert.fail((String)"type not found expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    private void testListTypeException(String query) {
        try {
            this.otherParams.put("where", query);
            this.publicApiClient.types().getTypes(this.createParams(this.paging, this.otherParams));
            Assert.fail((String)"Bad request expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }
}

