/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.rest.api.search.model.Query;
import org.alfresco.rest.api.search.model.SearchQuery;

public class SearchRequestContext {
    private final Query query;
    private final boolean includeRequest;
    private final Map<String, String> pivotKeys;
    private final Set<String> stores;

    private SearchRequestContext(Query query, boolean includeRequest) {
        this.query = query;
        this.includeRequest = includeRequest;
        this.pivotKeys = new HashMap<String, String>();
        this.stores = new HashSet<String>();
    }

    public static final SearchRequestContext from(SearchQuery searchQuery) {
        return new SearchRequestContext(searchQuery.getQuery(), searchQuery.includeRequest());
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean includeRequest() {
        return this.includeRequest;
    }

    public Map<String, String> getPivotKeys() {
        return this.pivotKeys;
    }

    public Set<String> getStores() {
        return this.stores;
    }
}

