/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.mapper.rules.RestRuleActionModelMapper;
import org.alfresco.rest.api.impl.mapper.rules.RestRuleCompositeConditionModelMapper;
import org.alfresco.rest.api.impl.mapper.rules.RestRuleModelMapper;
import org.alfresco.rest.api.impl.rules.ActionParameterConverter;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.api.model.rules.CompositeCondition;
import org.alfresco.rest.api.model.rules.Rule;
import org.alfresco.rest.api.model.rules.RuleTrigger;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RestRuleModelMapperTest {
    private static final String RULE_ID = "fake-rule-id";
    private static final String RULE_NAME = "rule name";
    private static final String RULE_DESCRIPTION = "rule description";
    private static final boolean RULE_ENABLED = true;
    private static final boolean RULE_INHERITABLE = true;
    private static final boolean RULE_ASYNC = true;
    private static final String ACTION_DEFINITION_NAME = "action-def-name";
    private static final String ERROR_SCRIPT = "error-script-ref";
    @Mock
    private RestRuleActionModelMapper actionMapperMock;
    @Mock
    private RestRuleCompositeConditionModelMapper compositeConditionMapperMock;
    @Mock
    private Nodes nodesMock;
    @Mock
    private ActionParameterConverter actionParameterConverterMock;
    private RestRuleModelMapper objectUnderTest;

    @Before
    public void setUp() {
        this.objectUnderTest = new RestRuleModelMapper((RestModelMapper)this.compositeConditionMapperMock, (RestModelMapper)this.actionMapperMock, this.nodesMock, this.actionParameterConverterMock);
    }

    @Test
    public void testToRestModel() {
        org.alfresco.service.cmr.rule.Rule ruleModel = RestRuleModelMapperTest.createRuleModel();
        BDDMockito.given((Object)this.actionParameterConverterMock.convertParamFromServiceModel((Serializable)ArgumentMatchers.any())).willAnswer(a -> a.getArgument(0));
        BDDMockito.given((Object)this.actionMapperMock.toRestModel((org.alfresco.service.cmr.action.Action)RestRuleModelMapperTest.createActionModel())).willReturn((Object)this.createAction());
        BDDMockito.given((Object)this.compositeConditionMapperMock.toRestModel(List.of(RestRuleModelMapperTest.createConditionModel()))).willReturn((Object)this.createCondition());
        Rule actualRule = this.objectUnderTest.toRestModel(ruleModel);
        ((RestRuleCompositeConditionModelMapper)BDDMockito.then((Object)this.compositeConditionMapperMock).should()).toRestModel((Collection)ruleModel.getAction().getActionConditions());
        BDDMockito.then((Object)this.compositeConditionMapperMock).shouldHaveNoMoreInteractions();
        ((ActionParameterConverter)BDDMockito.then((Object)this.actionParameterConverterMock).should()).convertParamFromServiceModel((Serializable)((Object)ERROR_SCRIPT));
        BDDMockito.then((Object)this.actionParameterConverterMock).shouldHaveNoMoreInteractions();
        ((CompositeAction)ruleModel.getAction()).getActions().forEach(a -> ((RestRuleActionModelMapper)BDDMockito.then((Object)this.actionMapperMock).should()).toRestModel(a));
        Rule expectedRule = this.createRuleWithDefaultValues();
        ((ObjectAssert)Assertions.assertThat((Object)actualRule).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedRule);
    }

    @Test
    public void testToRestModelWithNullValues() {
        org.alfresco.service.cmr.rule.Rule ruleModel = new org.alfresco.service.cmr.rule.Rule();
        Rule expectedRule = Rule.builder().isEnabled(true).create();
        Rule actualRule = this.objectUnderTest.toRestModel(ruleModel);
        ((ObjectAssert)Assertions.assertThat((Object)actualRule).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedRule);
    }

    @Test
    public void testToServiceModel() {
        Rule rule = this.createRuleWithDefaultValues();
        Action action = Action.builder().actionDefinitionId(ACTION_DEFINITION_NAME).create();
        rule.setActions(List.of(action));
        CompositeCondition compositeCondition = CompositeCondition.builder().create();
        org.alfresco.service.cmr.rule.Rule expectedRuleModel = RestRuleModelMapperTest.createRuleModel();
        rule.setConditions(compositeCondition);
        org.alfresco.service.cmr.action.Action actionModel = RestRuleModelMapperTest.createCompositeActionModel();
        BDDMockito.given((Object)this.actionMapperMock.toServiceModel(List.of(action))).willReturn((Object)actionModel);
        BDDMockito.given((Object)this.compositeConditionMapperMock.toServiceModels(compositeCondition)).willCallRealMethod();
        BDDMockito.given((Object)this.actionParameterConverterMock.getConvertedParams((Map)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).willAnswer(a -> a.getArgument(0));
        org.alfresco.service.cmr.rule.Rule actualRuleModel = this.objectUnderTest.toServiceModel(rule);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(RULE_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((RestRuleActionModelMapper)BDDMockito.then((Object)this.actionMapperMock).should()).toServiceModel(List.of(action));
        BDDMockito.then((Object)this.actionMapperMock).shouldHaveNoMoreInteractions();
        ((RestRuleCompositeConditionModelMapper)BDDMockito.then((Object)this.compositeConditionMapperMock).should()).toServiceModels(compositeCondition);
        BDDMockito.then((Object)this.compositeConditionMapperMock).shouldHaveNoMoreInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)actualRuleModel).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"nodeRef", "action"}).isEqualTo((Object)expectedRuleModel);
        Assertions.assertThat((Object)actualRuleModel.getAction()).isNotNull();
        org.alfresco.service.cmr.action.Action expectedCompensatingActionModel = RestRuleModelMapperTest.createCompensatingActionModel();
        ((ObjectAssert)Assertions.assertThat((Object)actualRuleModel.getAction().getCompensatingAction()).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"id"}).isEqualTo((Object)expectedCompensatingActionModel);
    }

    @Test
    public void testToServiceModel_withNullValues() {
        Rule rule = new Rule();
        org.alfresco.service.cmr.rule.Rule expectedRuleModel = new org.alfresco.service.cmr.rule.Rule();
        expectedRuleModel.setRuleDisabled(true);
        org.alfresco.service.cmr.rule.Rule actualRuleModel = this.objectUnderTest.toServiceModel(rule);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)actualRuleModel).isNotNull()).usingRecursiveComparison().ignoringFields(new String[]{"ruleTypes"}).isEqualTo((Object)expectedRuleModel);
    }

    private Rule createRuleWithDefaultValues() {
        return Rule.builder().id(RULE_ID).name(RULE_NAME).description(RULE_DESCRIPTION).isEnabled(true).isInheritable(true).isAsynchronous(true).triggers(List.of(RuleTrigger.INBOUND, RuleTrigger.UPDATE)).errorScript(ERROR_SCRIPT).actions(List.of(this.createAction())).conditions(this.createCondition()).create();
    }

    private CompositeCondition createCondition() {
        return CompositeCondition.builder().create();
    }

    private Action createAction() {
        return Action.builder().actionDefinitionId(ACTION_DEFINITION_NAME).create();
    }

    private static org.alfresco.service.cmr.rule.Rule createRuleModel() {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, RULE_ID);
        org.alfresco.service.cmr.rule.Rule ruleModel = new org.alfresco.service.cmr.rule.Rule(nodeRef);
        ruleModel.setTitle(RULE_NAME);
        ruleModel.setDescription(RULE_DESCRIPTION);
        ruleModel.setRuleDisabled(false);
        ruleModel.applyToChildren(true);
        ruleModel.setExecuteAsynchronously(true);
        ruleModel.setRuleTypes(List.of("inbound", "update"));
        ruleModel.setAction(RestRuleModelMapperTest.createCompositeActionModel());
        return ruleModel;
    }

    private static org.alfresco.service.cmr.action.Action createCompositeActionModel() {
        ActionConditionImpl actionCondition = RestRuleModelMapperTest.createConditionModel();
        CompositeActionImpl compositeActionModel = new CompositeActionImpl(null, "composite-action");
        compositeActionModel.addAction((org.alfresco.service.cmr.action.Action)RestRuleModelMapperTest.createActionModel());
        compositeActionModel.setCompensatingAction(RestRuleModelMapperTest.createCompensatingActionModel());
        compositeActionModel.addActionCondition((ActionCondition)actionCondition);
        return compositeActionModel;
    }

    private static ActionConditionImpl createConditionModel() {
        return new ActionConditionImpl("action-condition-id", "action-condition-def-name");
    }

    private static ActionImpl createActionModel() {
        return new ActionImpl(null, "action-id", ACTION_DEFINITION_NAME);
    }

    private static org.alfresco.service.cmr.action.Action createCompensatingActionModel() {
        ActionImpl compensatingActionModel = new ActionImpl(null, "compensating-action-id", "script");
        compensatingActionModel.setParameterValue("script-ref", (Serializable)((Object)ERROR_SCRIPT));
        return compensatingActionModel;
    }
}

