/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.doclink;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.doclink.AbstractDocLink;
import org.alfresco.service.cmr.repository.DeleteLinksStatusReport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DocLinksDelete
extends AbstractDocLink {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        DeleteLinksStatusReport report;
        NodeRef destinationNodeRef = null;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        destinationNodeRef = this.parseNodeRefFromTemplateArgs(templateVars);
        try {
            report = this.documentLinkService.deleteLinksToDocument(destinationNodeRef);
        }
        catch (IllegalArgumentException ex) {
            throw new WebScriptException(400, "Invalid Arguments: " + ex.getMessage());
        }
        catch (AccessDeniedException e) {
            throw new WebScriptException(403, "You don't have permission to perform this operation");
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("total_count", report.getTotalLinksFoundCount());
        model.put("deleted_count", report.getDeletedLinksCount());
        HashMap<String, String> errorDetails = new HashMap<String, String>();
        for (Map.Entry pair : report.getErrorDetails().entrySet()) {
            Throwable th = (Throwable)pair.getValue();
            errorDetails.put(((NodeRef)pair.getKey()).toString(), th.getMessage());
        }
        model.put("error_details", errorDetails);
        return model;
    }
}

