/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.groups;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.Groups;
import org.alfresco.rest.api.groups.GroupsEntityResource;
import org.alfresco.rest.api.model.GroupMember;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="members", entityResource=GroupsEntityResource.class, title="Group Members")
public class GroupMembersRelation
implements RelationshipResourceAction.Read<GroupMember>,
RelationshipResourceAction.Create<GroupMember>,
RelationshipResourceAction.Delete,
InitializingBean {
    private Groups groups;

    public void setGroups(Groups groups) {
        this.groups = groups;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"groups", (Object)this.groups);
    }

    @Override
    @WebApiDescription(title="A paged list of all the members of the group 'groupId'.")
    public CollectionWithPagingInfo<GroupMember> readAll(String groupId, Parameters params) {
        return this.groups.getGroupMembers(groupId, params);
    }

    @Override
    @WebApiDescription(title="Create group membership.")
    @WebApiParam(name="entity", title="A single group member", description="A single group member, multiple groups members are not supported.", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, allowMultiple=false, required=true)
    public List<GroupMember> create(String groupId, List<GroupMember> entity, Parameters params) {
        ArrayList<GroupMember> result = new ArrayList<GroupMember>(1);
        result.add(this.groups.createGroupMember(groupId, entity.get(0)));
        return result;
    }

    @Override
    @WebApiDescription(title="Delete group membership")
    public void delete(String entityResourceId, String id, Parameters parameters) {
        this.groups.deleteGroupMembership(entityResourceId, id);
    }
}

