/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.List;
import org.alfresco.rest.api.model.AssocTarget;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.nodes.AbstractNodeRelation;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

@RelationshipResource(name="targets", entityResource=NodesEntityResource.class, title="Node Targets")
public class NodeTargetsRelation
extends AbstractNodeRelation
implements RelationshipResourceAction.Read<Node>,
RelationshipResourceAction.Create<AssocTarget>,
RelationshipResourceAction.Delete {
    @Override
    @WebApiDescription(title="Return a paged list of target nodes based on (peer) assocs")
    public CollectionWithPagingInfo<Node> readAll(String sourceNodeId, Parameters parameters) {
        NodeRef sourceNodeRef = this.nodes.validateOrLookupNode(sourceNodeId);
        QNamePattern assocTypeQNameParam = this.getAssocTypeFromWhereElseAll(parameters);
        List assocRefs = this.nodeService.getTargetAssocs(sourceNodeRef, assocTypeQNameParam);
        return this.listNodePeerAssocs(assocRefs, parameters, true);
    }

    @Override
    @WebApiDescription(title="Add node assoc")
    public List<AssocTarget> create(String sourceNodeId, List<AssocTarget> entities, Parameters parameters) {
        return this.nodes.addTargets(sourceNodeId, entities);
    }

    @Override
    @WebApiDescription(title="Remove node assoc(s)")
    public void delete(String sourceNodeId, String targetNodeId, Parameters parameters) {
        NodeRef srcNodeRef = this.nodes.validateNode(sourceNodeId);
        NodeRef tgtNodeRef = this.nodes.validateNode(targetNodeId);
        String assocTypeStr = parameters.getParameter("assocType");
        QName assocTypeQName = this.nodes.getAssocType(assocTypeStr, false);
        if (assocTypeQName == null) {
            assocTypeQName = RegexQNamePattern.MATCH_ALL;
        }
        boolean found = false;
        List assocRefs = this.nodeService.getTargetAssocs(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, sourceNodeId), (QNamePattern)assocTypeQName);
        for (AssociationRef assocRef : assocRefs) {
            if (!assocRef.getTargetRef().equals((Object)tgtNodeRef)) continue;
            this.nodeService.removeAssociation(srcNodeRef, tgtNodeRef, assocRef.getTypeQName());
            found = true;
        }
        if (!found) {
            throw new EntityNotFoundException(sourceNodeId + "," + assocTypeStr + "," + targetNodeId);
        }
    }
}

