/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bulkimport;

import com.google.common.primitives.Ints;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import org.alfresco.repo.bulkimport.BulkFilesystemImporter;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.MultiThreadedBulkFilesystemImporter;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AbstractBulkFileSystemImportWebScript
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(BulkFilesystemImporter.class);
    protected static final String WEB_SCRIPT_URI_BULK_FILESYSTEM_IMPORT_STATUS = "/bulkfsimport/status";
    protected static final String PARAMETER_TARGET_NODEREF = "targetNodeRef";
    protected static final String PARAMETER_TARGET_PATH = "targetPath";
    protected static final String COMPANY_HOME_NAME = "Company Home";
    protected static final String COMPANY_HOME_PATH = "/Company Home";
    protected static final String PARAMETER_REPLACE_EXISTING = "replaceExisting";
    protected static final String PARAMETER_EXISTING_FILE_MODE = "existingFileMode";
    protected static final String PARAMETER_VALUE_REPLACE_EXISTING = "true";
    protected static final String PARAMETER_SOURCE_DIRECTORY = "sourceDirectory";
    protected static final String PARAMETER_DISABLE_RULES = "disableRules";
    protected static final String PARAMETER_VALUE_DISABLE_RULES = "true";
    protected static final String IMPORT_ALREADY_IN_PROGRESS_MODEL_KEY = "importInProgress";
    protected static final String IMPORT_ALREADY_IN_PROGRESS_ERROR_KEY = "bfsit.error.importAlreadyInProgress";
    protected static final String PARAMETER_BATCH_SIZE = "batchSize";
    protected static final String PARAMETER_NUM_THREADS = "numThreads";
    protected FileFolderService fileFolderService;
    protected Repository repository;
    protected volatile boolean importInProgress;

    protected NodeRef getTargetNodeRef(String targetNodeRefStr, String targetPath) throws FileNotFoundException {
        NodeRef targetNodeRef;
        if (targetNodeRefStr == null || targetNodeRefStr.trim().length() == 0) {
            if (targetPath == null || targetPath.trim().length() == 0) {
                throw new WebScriptException("Error: neither parameter 'targetNodeRef' nor parameter 'targetPath' was provided, but at least one is required !");
            }
            targetNodeRef = this.convertPathToNodeRef(targetPath.trim());
        } else {
            targetNodeRef = new NodeRef(targetNodeRefStr.trim());
        }
        return targetNodeRef;
    }

    protected NodeRef convertPathToNodeRef(String targetPath) throws FileNotFoundException {
        NodeRef result = null;
        NodeRef companyHome = this.repository.getCompanyHome();
        String cleanTargetPath = targetPath.replaceAll("/+", "/");
        if (cleanTargetPath.startsWith(COMPANY_HOME_PATH)) {
            cleanTargetPath = cleanTargetPath.substring(COMPANY_HOME_PATH.length());
        }
        if (cleanTargetPath.startsWith("/")) {
            cleanTargetPath = cleanTargetPath.substring(1);
        }
        if (cleanTargetPath.endsWith("/")) {
            cleanTargetPath = cleanTargetPath.substring(0, cleanTargetPath.length() - 1);
        }
        if (cleanTargetPath.length() == 0) {
            result = companyHome;
        } else {
            FileInfo info = this.fileFolderService.resolveNamePath(companyHome, Arrays.asList(cleanTargetPath.split("/")));
            if (info == null) {
                throw new WebScriptException("could not determine NodeRef for path :'" + cleanTargetPath + "'");
            }
            result = info.getNodeRef();
        }
        return result;
    }

    protected String buildTextMessage(Throwable t) {
        StringBuffer result = new StringBuffer();
        String timeOfFailure = new Date().toString();
        String hostName = null;
        String ipAddress = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            hostName = "unknown";
            ipAddress = "unknown";
        }
        result.append("\nTime of failure:             " + timeOfFailure);
        result.append("\nHost where failure occurred: " + hostName + " (" + ipAddress + ")");
        if (t != null) {
            result.append("\nRoot exception:");
            result.append(this.renderExceptionStackAsText(t));
        } else {
            result.append("\nNo exception was provided.");
        }
        return result.toString();
    }

    private String renderExceptionStackAsText(Throwable t) {
        StringBuffer result = new StringBuffer();
        if (t != null) {
            String message = t.getMessage();
            Throwable cause = t.getCause();
            if (cause != null) {
                result.append(this.renderExceptionStackAsText(cause));
                result.append("\nWrapped by:");
            }
            if (message == null) {
                message = "";
            }
            result.append("\n");
            result.append(t.getClass().getName());
            result.append(": ");
            result.append(message);
            result.append("\n");
            result.append(this.renderStackTraceElements(t.getStackTrace()));
        }
        return result.toString();
    }

    private String renderStackTraceElements(StackTraceElement[] elements) {
        StringBuffer result = new StringBuffer();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                result.append("\tat " + elements[i].toString() + "\n");
            }
        }
        return result.toString();
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    protected static class BulkImportParametersExtractor {
        private final Function<String, String> paramsProvider;
        private final NodeRefCreator nodeRefCreator;
        private final int defaultBatchSize;
        private final int defaultNumThreads;

        public BulkImportParametersExtractor(Function<String, String> paramsProvider, NodeRefCreator nodeRefCreator, int defaultBatchSize, int defaultNumThreads) {
            this.paramsProvider = Objects.requireNonNull(paramsProvider);
            this.nodeRefCreator = Objects.requireNonNull(nodeRefCreator);
            this.defaultBatchSize = defaultBatchSize;
            this.defaultNumThreads = defaultNumThreads;
        }

        public BulkImportParameters extract() throws FileNotFoundException {
            BulkImportParameters result = new BulkImportParameters();
            result.setTarget(this.getTargetNodeRef());
            this.setExistingFileMode(result);
            result.setNumThreads(Integer.valueOf(this.getOptionalPositiveInteger(AbstractBulkFileSystemImportWebScript.PARAMETER_NUM_THREADS).orElse(this.defaultNumThreads)));
            result.setBatchSize(Integer.valueOf(this.getOptionalPositiveInteger(AbstractBulkFileSystemImportWebScript.PARAMETER_BATCH_SIZE).orElse(this.defaultBatchSize)));
            this.setDisableRules(result);
            return result;
        }

        private void setExistingFileMode(BulkImportParameters params) {
            String replaceExistingStr = this.getParamStringValue(AbstractBulkFileSystemImportWebScript.PARAMETER_REPLACE_EXISTING);
            String existingFileModeStr = this.getParamStringValue(AbstractBulkFileSystemImportWebScript.PARAMETER_EXISTING_FILE_MODE);
            if (!this.isNullOrEmpty(replaceExistingStr) && !this.isNullOrEmpty(existingFileModeStr)) {
                throw new IllegalStateException(String.format("Only one of these parameters may be used, not both: %s, %s", AbstractBulkFileSystemImportWebScript.PARAMETER_REPLACE_EXISTING, AbstractBulkFileSystemImportWebScript.PARAMETER_EXISTING_FILE_MODE));
            }
            if (!this.isNullOrEmpty(existingFileModeStr)) {
                params.setExistingFileMode(BulkImportParameters.ExistingFileMode.valueOf((String)existingFileModeStr));
            } else {
                params.setReplaceExisting("true".equals(replaceExistingStr));
            }
        }

        private void setDisableRules(BulkImportParameters params) {
            String disableRulesStr = this.getParamStringValue(AbstractBulkFileSystemImportWebScript.PARAMETER_DISABLE_RULES);
            params.setDisableRulesService(!this.isNullOrEmpty(disableRulesStr) && "true".equals(disableRulesStr));
        }

        private NodeRef getTargetNodeRef() throws FileNotFoundException {
            String targetNodeRefStr = this.getParamStringValue(AbstractBulkFileSystemImportWebScript.PARAMETER_TARGET_NODEREF);
            String targetPath = this.getParamStringValue(AbstractBulkFileSystemImportWebScript.PARAMETER_TARGET_PATH);
            return this.nodeRefCreator.fromNodeRefAndPath(targetNodeRefStr, targetPath);
        }

        private OptionalInt getOptionalPositiveInteger(String paramName) {
            String strValue = this.getParamStringValue(paramName);
            if (this.isNullOrEmpty(strValue)) {
                return OptionalInt.empty();
            }
            Integer asInt = Ints.tryParse((String)strValue);
            if (asInt == null || asInt < 1) {
                throw new WebScriptException("Error: parameter '" + paramName + "' must be an integer > 0.");
            }
            return OptionalInt.of(asInt);
        }

        private String getParamStringValue(String paramName) {
            Objects.requireNonNull(paramName);
            return this.paramsProvider.apply(paramName);
        }

        private boolean isNullOrEmpty(String str) {
            return str == null || str.trim().length() == 0;
        }

        @FunctionalInterface
        protected static interface NodeRefCreator {
            public NodeRef fromNodeRefAndPath(String var1, String var2) throws FileNotFoundException;
        }
    }

    protected class MultithreadedImportWebScriptLogic {
        private final MultiThreadedBulkFilesystemImporter bulkImporter;
        private final Supplier<NodeImporter> nodeImporterFactory;
        private final WebScriptRequest request;
        private final Status status;
        private final Cache cache;

        public MultithreadedImportWebScriptLogic(MultiThreadedBulkFilesystemImporter bulkImporter, Supplier<NodeImporter> nodeImporterFactory, WebScriptRequest request, Status status, Cache cache) {
            this.bulkImporter = Objects.requireNonNull(bulkImporter);
            this.nodeImporterFactory = Objects.requireNonNull(nodeImporterFactory);
            this.request = Objects.requireNonNull(request);
            this.status = Objects.requireNonNull(status);
            this.cache = Objects.requireNonNull(cache);
        }

        public Map<String, Object> executeImport() {
            HashMap<String, Object> model = new HashMap<String, Object>();
            this.cache.setNeverCache(true);
            String targetPath = null;
            try {
                targetPath = this.request.getParameter(AbstractBulkFileSystemImportWebScript.PARAMETER_TARGET_PATH);
                if (this.isRunning()) {
                    model.put(AbstractBulkFileSystemImportWebScript.IMPORT_ALREADY_IN_PROGRESS_MODEL_KEY, I18NUtil.getMessage((String)AbstractBulkFileSystemImportWebScript.IMPORT_ALREADY_IN_PROGRESS_ERROR_KEY));
                    return model;
                }
                BulkImportParameters bulkImportParameters = this.getBulkImportParameters();
                NodeImporter nodeImporter = this.nodeImporterFactory.get();
                this.bulkImporter.asyncBulkImport(bulkImportParameters, nodeImporter);
                this.waitForImportToBegin();
                this.status.setCode(302);
                this.status.setRedirect(true);
                this.status.setLocation(this.request.getServiceContextPath() + AbstractBulkFileSystemImportWebScript.WEB_SCRIPT_URI_BULK_FILESYSTEM_IMPORT_STATUS);
            }
            catch (IllegalArgumentException | WebScriptException e) {
                this.status.setCode(400, e.getMessage());
                this.status.setRedirect(true);
            }
            catch (FileNotFoundException fnfe) {
                this.status.setCode(400, "The repository path '" + targetPath + "' does not exist !");
                this.status.setRedirect(true);
            }
            catch (Throwable t) {
                throw new WebScriptException(500, AbstractBulkFileSystemImportWebScript.this.buildTextMessage(t), t);
            }
            return model;
        }

        private void waitForImportToBegin() throws InterruptedException {
            for (int i = 0; !this.bulkImporter.getStatus().inProgress() && i < 10; ++i) {
                Thread.sleep(100L);
            }
        }

        private BulkImportParameters getBulkImportParameters() throws FileNotFoundException {
            BulkImportParametersExtractor extractor = new BulkImportParametersExtractor(arg_0 -> ((WebScriptRequest)this.request).getParameter(arg_0), AbstractBulkFileSystemImportWebScript.this::getTargetNodeRef, this.bulkImporter.getDefaultBatchSize(), this.bulkImporter.getDefaultNumThreads());
            return extractor.extract();
        }

        private boolean isRunning() {
            return this.bulkImporter.getStatus().inProgress();
        }
    }
}

