/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class TaskInstancePut
extends AbstractWorkflowWebscript {
    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        Map params = req.getServiceMatch().getTemplateVars();
        String taskId = (String)params.get("task_instance_id");
        JSONObject json = null;
        try {
            WorkflowTask workflowTask = this.workflowService.getTaskById(taskId);
            String currentUser = this.authenticationService.getCurrentUserName();
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            workflowTask = this.workflowService.updateTask(taskId, this.parseTaskProperties(json, workflowTask), null, null);
            if (workflowTask == null) {
                throw new WebScriptException(404, "Failed to find workflow task with id: " + taskId);
            }
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("workflowTask", modelBuilder.buildDetailed(workflowTask));
            return model;
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from request.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from request.", (Throwable)je);
        }
        catch (AccessDeniedException ade) {
            throw new WebScriptException(401, "Failed to update workflow task with id: " + taskId, (Throwable)ade);
        }
        catch (WorkflowException we) {
            throw new WebScriptException(401, "Failed to update workflow task with id: " + taskId, (Throwable)we);
        }
    }

    private Map<QName, Serializable> parseTaskProperties(JSONObject json, WorkflowTask workflowTask) throws JSONException {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        String[] names = JSONObject.getNames((JSONObject)json);
        if (names != null) {
            for (String name : names) {
                QName key = QName.createQName((String)name.replaceFirst("_", ":"), (NamespacePrefixResolver)this.namespaceService);
                Object jsonValue = json.get(name);
                Object value = null;
                if (jsonValue.equals(JSONObject.NULL)) {
                    props.put(key, null);
                } else {
                    PropertyDefinition prop = this.dictionaryService.getProperty(key);
                    if (prop != null) {
                        if (prop.isMultiValued() && jsonValue instanceof JSONArray) {
                            value = new ArrayList();
                            for (int i = 0; i < ((JSONArray)jsonValue).length(); ++i) {
                                ((List)value).add((Serializable)DefaultTypeConverter.INSTANCE.convert(prop.getDataType(), ((JSONArray)jsonValue).get(i)));
                            }
                        } else {
                            value = (Serializable)DefaultTypeConverter.INSTANCE.convert(prop.getDataType(), jsonValue);
                        }
                    } else if (jsonValue instanceof JSONArray) {
                        value = new ArrayList();
                        for (int i = 0; i < ((JSONArray)jsonValue).length(); ++i) {
                            ((List)value).add(((JSONArray)jsonValue).getString(i));
                        }
                    } else if (jsonValue instanceof String) {
                        Serializable existingValue = (Serializable)workflowTask.getProperties().get(key);
                        if (existingValue != null) {
                            try {
                                value = (Serializable)DefaultTypeConverter.INSTANCE.convert(existingValue.getClass(), jsonValue);
                            }
                            catch (TypeConversionException typeConversionException) {}
                        } else {
                            value = (String)jsonValue;
                        }
                    } else {
                        value = (Serializable)jsonValue;
                    }
                }
                props.put(key, (Serializable)value);
            }
        }
        return props;
    }
}

