/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util.paging;

import java.util.Map;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.repo.web.util.paging.Page;
import org.alfresco.repo.web.util.paging.PagedCursor;
import org.alfresco.repo.web.util.paging.PagedResults;
import org.alfresco.repo.web.util.paging.WindowedCursor;

public class Paging {
    boolean zeroBasedPage = false;
    boolean zeroBasedRow = true;

    public void setZeroBasedPage(boolean zeroBasedPage) {
        this.zeroBasedPage = zeroBasedPage;
    }

    public boolean isZeroBasedPage() {
        return this.zeroBasedPage;
    }

    public void setZeroBasedRow(boolean zeroBasedRow) {
        this.zeroBasedRow = zeroBasedRow;
    }

    public boolean isZeroBasedRow() {
        return this.zeroBasedRow;
    }

    public Page createPageOrWindow(Map<String, String> args) {
        Integer pageNo = null;
        String strPageNo = args.get("pageNo");
        if (strPageNo != null) {
            try {
                pageNo = Integer.valueOf(strPageNo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Integer pageSize = null;
        String strPageSize = args.get("pageSize");
        if (strPageSize != null) {
            try {
                pageSize = Integer.valueOf(strPageSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Integer skipCount = null;
        String strSkipCount = args.get("skipCount");
        if (strSkipCount != null) {
            try {
                skipCount = Integer.valueOf(strSkipCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Integer maxItems = null;
        String strMaxItems = args.get("maxItems");
        if (strMaxItems != null) {
            try {
                maxItems = Integer.valueOf(strMaxItems);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.createPageOrWindow(pageNo, pageSize, skipCount, maxItems);
    }

    public Page createPageOrWindow(Integer pageNumber, Integer pageSize, Integer skipCount, Integer maxItems) {
        if (pageNumber != null || pageSize != null) {
            return this.createPage(pageNumber == null ? (this.isZeroBasedPage() ? 0 : 1) : pageNumber, pageSize == null ? -1 : pageSize);
        }
        if (skipCount != null || maxItems != null) {
            return this.createWindow(skipCount == null ? (this.isZeroBasedRow() ? 0 : 1) : skipCount, maxItems == null ? -1 : maxItems);
        }
        return this.createUnlimitedPage();
    }

    public Page createPage(int pageNumber, int pageSize) {
        return new Page(PageType.PAGE, this.zeroBasedPage, pageNumber, pageSize);
    }

    public Page createUnlimitedPage() {
        return new Page(PageType.PAGE, this.zeroBasedPage, this.zeroBasedPage ? 0 : 1, -1);
    }

    public Page createWindow(int skipRows, int maxRows) {
        return new Page(PageType.WINDOW, this.zeroBasedRow, skipRows, maxRows);
    }

    public Cursor createCursor(int totalRows, Page page) {
        if (page.getType() == PageType.PAGE) {
            return new PagedCursor(this.zeroBasedRow, totalRows, page.zeroBasedIdx, page.startIdx, page.pageSize);
        }
        if (page.getType() == PageType.WINDOW) {
            return new WindowedCursor(this.zeroBasedRow, totalRows, page.startIdx, page.pageSize);
        }
        return null;
    }

    public PagedResults createPagedResults(Object[] results, Cursor cursor) {
        return new PagedResults(results, cursor);
    }

    public PagedResults createPagedResult(Object result, Cursor cursor) {
        return new PagedResults(result, cursor);
    }

    public static enum PageType {
        PAGE,
        WINDOW;

    }
}

