/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.List;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.Rule;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;

@Experimental
public class RuleLoader {
    public static final String IS_SHARED = "isShared";
    private RuleService ruleService;
    private NodeValidator nodeValidator;
    private RestModelMapper<Rule, org.alfresco.service.cmr.rule.Rule> ruleMapper;

    public Rule loadRule(org.alfresco.service.cmr.rule.Rule ruleModel, List<String> includes) {
        Rule rule = this.ruleMapper.toRestModel(ruleModel);
        if (includes != null && includes.contains(IS_SHARED)) {
            NodeRef ruleSet = this.ruleService.getRuleSetNode(ruleModel.getNodeRef());
            boolean isShared = this.nodeValidator.isRuleSetNotNullAndShared(ruleSet);
            rule.setIsShared(isShared);
        }
        return rule;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setNodeValidator(NodeValidator nodeValidator) {
        this.nodeValidator = nodeValidator;
    }

    public void setRuleMapper(RestModelMapper<Rule, org.alfresco.service.cmr.rule.Rule> ruleMapper) {
        this.ruleMapper = ruleMapper;
    }
}

