/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.api.mocks;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.tests.api.mocks.Goat;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Description;

@EntityResource(name="cow", title="Cow")
public class CowEntityResource
implements EntityResourceAction.ReadByIdWithResponse<Goat>,
EntityResourceAction.ReadWithResponse<Goat>,
EntityResourceAction.CreateWithResponse<Goat>,
EntityResourceAction.UpdateWithResponse<Goat>,
EntityResourceAction.DeleteWithResponse,
BinaryResourceAction.ReadWithResponse,
BinaryResourceAction.DeleteWithResponse,
BinaryResourceAction.UpdateWithResponse<Goat> {
    public static final Cache CACHE_COW = new Cache(new Description.RequiredCache(){

        public boolean getNeverCache() {
            return false;
        }

        public boolean getIsPublic() {
            return true;
        }

        public boolean getMustRevalidate() {
            return false;
        }
    });

    public Goat readById(String id, Parameters parameters, WithResponse withResponse) {
        withResponse.setCache(CACHE_COW);
        return new Goat("Goat" + id);
    }

    public CollectionWithPagingInfo<Goat> readAll(Parameters params, WithResponse withResponse) {
        return CollectionWithPagingInfo.asPaged((Paging)params.getPaging(), Arrays.asList(new Goat("Cow1")));
    }

    public List<Goat> create(List<Goat> entities, Parameters parameters, WithResponse withResponse) {
        withResponse.setStatus(202);
        return entities;
    }

    public void delete(String id, Parameters parameters, WithResponse withResponse) {
    }

    public Goat update(String id, Goat entity, Parameters parameters, WithResponse withResponse) {
        return entity;
    }

    @BinaryProperties(value={"photo"})
    public void deleteProperty(String entityId, Parameters parameters, WithResponse withResponse) {
    }

    @BinaryProperties(value={"photo"})
    public BinaryResource readProperty(String entityId, Parameters parameters, WithResponse withResponse) throws EntityNotFoundException {
        return null;
    }

    @BinaryProperties(value={"photo"})
    public Goat updateProperty(String entityId, BasicContentInfo contentInfo, InputStream stream, Parameters params, WithResponse withResponse) {
        return null;
    }
}

