/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import jakarta.servlet.http.HttpServletResponseWrapper;
import java.util.Collections;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;

public class CMISHttpServletResponse
extends HttpServletResponseWrapper {
    protected Set<String> nonAttachContentTypes = Collections.emptySet();
    private static final String HDR_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String ATTACHMENT = "attachment";
    private static final String INLINE = "inline";

    public CMISHttpServletResponse(WebScriptResponse res, Set<String> nonAttachContentTypes) {
        super(WebScriptServletRuntime.getHttpServletResponse((WebScriptResponse)res));
        this.nonAttachContentTypes = nonAttachContentTypes;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, this.getStringHeaderValue(name, value, super.getContentType()));
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, this.getStringHeaderValue(name, value, super.getContentType()));
    }

    private String getStringHeaderValue(String name, String value, String contentType) {
        if (HDR_CONTENT_DISPOSITION.equals(name) && !this.nonAttachContentTypes.contains(contentType)) {
            if (((String)value).startsWith(INLINE)) {
                value = ATTACHMENT + ((String)value).substring(INLINE.length());
            } else if (!((String)value).startsWith(ATTACHMENT)) {
                throw new AlfrescoRuntimeException("Unexpected - header could not be set: " + name + " = " + (String)value);
            }
        }
        return value;
    }
}

