/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rating;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.rating.AbstractRatingWebScript;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RatingDelete
extends AbstractRatingWebScript {
    private static final String AVERAGE_RATING = "averageRating";
    private static final String RATINGS_TOTAL = "ratingsTotal";
    private static final String RATINGS_COUNT = "ratingsCount";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String ratingSchemeName;
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        Rating deletedRating = this.ratingService.removeRatingByCurrentUser(nodeRef, ratingSchemeName = this.parseRequestForScheme(req));
        if (deletedRating == null) {
            throw new WebScriptException(400, "Unable to delete non-existent rating: " + ratingSchemeName + " from " + nodeRef.toString());
        }
        model.put("nodeRef", nodeRef.toString());
        model.put(AVERAGE_RATING, Float.valueOf(this.ratingService.getAverageRating(nodeRef, ratingSchemeName)));
        model.put(RATINGS_TOTAL, Float.valueOf(this.ratingService.getTotalRating(nodeRef, ratingSchemeName)));
        model.put(RATINGS_COUNT, this.ratingService.getRatingsCount(nodeRef, ratingSchemeName));
        return model;
    }

    private String parseRequestForScheme(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String scheme = (String)templateVars.get("scheme");
        return scheme;
    }
}

