/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.Date;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleInstallState;

public class ModulePackage {
    private String id;
    private String title;
    private String description;
    private String version;
    private Date installDate;
    private ModuleInstallState installState;
    private String versionMin;
    private String versionMax;

    public ModulePackage() {
    }

    private ModulePackage(ModuleDetails moduleDetails) {
        this.id = moduleDetails.getId();
        this.title = moduleDetails.getTitle();
        this.description = moduleDetails.getDescription();
        this.version = moduleDetails.getModuleVersionNumber().toString();
        this.installDate = moduleDetails.getInstallDate();
        this.installState = moduleDetails.getInstallState();
        this.versionMin = moduleDetails.getRepoVersionMin().toString();
        this.versionMax = moduleDetails.getRepoVersionMax().toString();
    }

    public static ModulePackage fromModuleDetails(ModuleDetails moduleDetails) {
        try {
            return new ModulePackage(moduleDetails);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getInstallDate() {
        return this.installDate;
    }

    public ModuleInstallState getInstallState() {
        return this.installState;
    }

    public String getVersionMin() {
        return this.versionMin;
    }

    public String getVersionMax() {
        return this.versionMax;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ModulePackage{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", version=").append(this.version);
        sb.append(", installDate=").append(this.installDate);
        sb.append(", installState=").append(this.installState);
        sb.append(", versionMin='").append(this.versionMin).append('\'');
        sb.append(", versionMax='").append(this.versionMax).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

