/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import org.alfresco.cmis.client.AlfrescoDocument;
import org.alfresco.cmis.client.AlfrescoFolder;
import org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl;
import org.alfresco.cmis.client.type.AlfrescoType;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.alfresco.opencmis.PublicApiAlfrescoCmisServiceFactory;
import org.alfresco.opencmis.PublicApiBrowserCMISDispatcher;
import org.alfresco.opencmis.dictionary.CMISStrictDictionaryService;
import org.alfresco.opencmis.dictionary.QNameFilter;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.CMISNode;
import org.alfresco.rest.api.tests.client.data.Comment;
import org.alfresco.rest.api.tests.client.data.FolderNode;
import org.alfresco.rest.api.tests.client.data.NodeRating;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.client.data.Tag;
import org.alfresco.rest.framework.core.exceptions.JsonpCallbackNotAllowedException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.URLEncoder;

public class TestCMIS
extends EnterpriseTestApi {
    private static final String CMIS_VERSION_10 = "1.0";
    private static final String CMIS_VERSION_11 = "1.1";
    private static final String TYPE_CMIS_DOCUMENT = "cmis:document";
    private static final String DOCUMENT_LIBRARY_CONTAINER_NAME = "documentLibrary";
    private static final String TEST_SITE_NAME_PATTERN = "testSite-%d";
    private static final String TEST_USER_NAME_PATTERN = "testUser-%d";
    private static final String TEST_DOCUMENT_NAME_PATTERN = "testDocument-%s.txt";
    private static final String DOCUMENT_LIBRARY_PATH_PATTERN = "/Sites/%s/documentLibrary";
    private static final String TEST_PASSWORD = "password";
    private ApplicationContext ctx;
    private DictionaryDAO dictionaryDAO;
    private LockService lockService;
    private TenantService tenantService;
    private CMISStrictDictionaryService cmisDictionary;
    private QNameFilter cmisTypeExclusions;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    protected ContentService contentService;
    private PermissionService permissionService;
    private Properties globalProperties;
    private RepoService.TestNetwork testNetwork;
    private RepoService.TestSite testSite;
    private String testPersonId;
    private String testFileIdWithTwoRenditions;

    @Before
    public void before() throws Exception {
        this.ctx = this.getTestFixture().getApplicationContext();
        this.dictionaryDAO = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        this.lockService = (LockService)this.ctx.getBean("lockService");
        this.tenantService = (TenantService)this.ctx.getBean("tenantService");
        this.cmisDictionary = (CMISStrictDictionaryService)this.ctx.getBean("OpenCMISDictionaryService");
        this.cmisTypeExclusions = (QNameFilter)this.ctx.getBean("cmisTypeExclusions");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.fileFolderService = (FileFolderService)this.ctx.getBean("FileFolderService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.permissionService = (PermissionService)this.ctx.getBean("permissionService");
        this.globalProperties = (Properties)this.ctx.getBean("global-properties");
        this.globalProperties.setProperty("version.store.enableAutoVersionOnUpdateProps", "true");
    }

    @After
    public void after() {
        this.globalProperties.setProperty("version.store.enableAutoVersionOnUpdateProps", "false");
    }

    private RepoService.TestNetwork getTestNetwork() throws Exception {
        if (this.testNetwork == null) {
            this.testNetwork = this.getTestFixture().getRandomNetwork();
        }
        return this.testNetwork;
    }

    private String getTestPersonId() throws Exception {
        if (this.testPersonId == null) {
            this.getTestNetwork();
            String username = "user" + System.currentTimeMillis();
            PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
            RepoService.TestPerson person = this.testNetwork.createUser(personInfo);
            this.testPersonId = person.getId();
        }
        return this.testPersonId;
    }

    private RepoService.TestSite getTestSite() throws Exception {
        if (this.testSite == null) {
            this.getTestNetwork();
            this.getTestPersonId();
            final String siteName = "site" + System.currentTimeMillis();
            this.testSite = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                public RepoService.TestSite doWork() throws Exception {
                    RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                    return TestCMIS.this.testNetwork.createSite(siteInfo);
                }
            }, (String)this.testPersonId, (String)this.testNetwork.getId());
        }
        return this.testSite;
    }

    private NodeRef makeRenditionNode(NodeRef parent, String title, String name, String mimetype) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(ContentModel.PROP_TITLE, title);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)name);
        ChildAssociationRef assoc = this.nodeService.createNode(parent, RenditionModel.ASSOC_RENDITION, assocQName, ContentModel.TYPE_THUMBNAIL, props);
        NodeRef childRef = assoc.getChildRef();
        if (!this.nodeService.hasAspect(parent, RenditionModel.ASPECT_RENDITIONED)) {
            this.nodeService.addAspect(parent, RenditionModel.ASPECT_RENDITIONED, null);
        }
        ContentWriter writer = this.contentService.getWriter(childRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimetype);
        writer.setEncoding("UTF-8");
        writer.putContent("Dummy " + name + " content");
        return childRef;
    }

    private String getTestFileIdWithTwoRenditionsOneSourceAndTwoTargetAssociations() throws Exception {
        if (this.testFileIdWithTwoRenditions == null) {
            this.getTestNetwork();
            this.getTestPersonId();
            this.getTestSite();
            NodeRef fileNode = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef documentLibrary = TestCMIS.this.testSite.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME);
                    NodeRef folder = TestCMIS.this.repoService.createFolder(documentLibrary, "myFoder");
                    NodeRef testFile1 = TestCMIS.this.repoService.createDocument(folder, "testdoc1.txt", "Test title 1", "Test description 1", "Test content 2");
                    TestCMIS.this.makeRenditionNode(testFile1, "pdf", "pdf", "application/pdf");
                    TestCMIS.this.makeRenditionNode(testFile1, "doclib", "thumbnail", "image/png");
                    NodeRef testFile0 = TestCMIS.this.repoService.createDocument(folder, "testdoc0.txt", "Test title 0", "Test description 0", "Test content 0");
                    NodeRef testFile2 = TestCMIS.this.repoService.createDocument(folder, "testdoc2.txt", "Test title 2", "Test description 2", "Test content 2");
                    NodeRef testFile3 = TestCMIS.this.repoService.createDocument(folder, "testdoc3.txt", "Test title 3", "Test description 3", "Test content 3");
                    TestCMIS.this.nodeService.addAspect(testFile1, ContentModel.ASPECT_COPIEDFROM, null);
                    TestCMIS.this.nodeService.addAspect(testFile2, ContentModel.ASPECT_COPIEDFROM, null);
                    TestCMIS.this.nodeService.addAspect(testFile3, ContentModel.ASPECT_COPIEDFROM, null);
                    TestCMIS.this.nodeService.createAssociation(testFile1, testFile0, ContentModel.ASSOC_ORIGINAL);
                    TestCMIS.this.nodeService.createAssociation(testFile2, testFile1, ContentModel.ASSOC_ORIGINAL);
                    TestCMIS.this.nodeService.createAssociation(testFile3, testFile1, ContentModel.ASSOC_ORIGINAL);
                    return testFile1;
                }
            }, (String)this.testPersonId, (String)this.testNetwork.getId());
            this.testFileIdWithTwoRenditions = fileNode.getId();
        }
        return this.testFileIdWithTwoRenditions;
    }

    private void assertGetIdFilterParams(int expectedProperties, int expectedRenditions, int expecteRelationships, int expectedAllowableActions, int expectedPolicyIds, int expectedAcls, String ... params) throws Exception {
        String fragment;
        String cmisId = this.getTestFileIdWithTwoRenditionsOneSourceAndTwoTargetAssociations();
        HashMap<String, String> reqParams = new HashMap<String, String>();
        reqParams.put("id", cmisId);
        StringJoiner sj = new StringJoiner(", ");
        for (int i = 0; i < params.length; i += 2) {
            String param = params[i];
            String value = params[i + 1];
            reqParams.put(param, value);
            sj.add(param + "=" + value);
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.testNetwork.getId(), this.testPersonId));
        HttpResponse resp = this.publicApiClient.get(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11, "id", reqParams);
        String xml = resp.getResponse();
        String urlParams = sj.toString();
        System.out.println(xml + "\n\n Expected props=" + expectedProperties + " allowed=" + expectedAllowableActions + " relationships=" + expecteRelationships + " renditions=" + expectedRenditions + " policies=" + expectedPolicyIds + " acls=" + expectedAcls + " URL params: " + urlParams);
        if (expectedProperties >= 0) {
            fragment = this.assertSubstring("Properties", xml, expectedProperties, "cmisra:object");
            fragment = this.assertSubstring("Properties", fragment, expectedProperties, "cmis:properties");
            this.assertCount("Properties", fragment, expectedProperties, "propertyDefinitionId=");
        }
        if (expectedRenditions >= 0) {
            this.assertCount("Renditions", xml, expectedRenditions, "<cmis:rendition>");
            this.assertCount("Renditions", xml, expectedRenditions, "<atom:link rel=\"alternate\"");
        }
        if (expecteRelationships >= 0) {
            this.assertCount("Relationships", xml, expecteRelationships, "<cmis:relationship>");
        }
        if (expectedRenditions >= 0 && expecteRelationships >= 0) {
            this.assertCount("Links", xml, 12 + expectedRenditions + expecteRelationships, "<atom:link rel=\"");
        }
        if (expectedAllowableActions >= 0) {
            fragment = this.assertSubstring("Actions", xml, expectedAllowableActions, "cmis:allowableActions");
            this.assertCount("Actions", fragment, expectedAllowableActions, "<cmis:can");
        }
        if (expectedPolicyIds == 0 && urlParams != null && urlParams.indexOf("includePolicyIds=true") != -1) {
            this.assertCount("Policies", xml, 1, "<cmis:policyIds/>");
        } else if (expectedPolicyIds >= 0) {
            fragment = this.assertSubstring("Policies", xml, expectedPolicyIds, "cmis:policyIds");
        }
        if (expectedAcls >= 0) {
            fragment = this.assertSubstring("ACL", xml, expectedAcls, "cmis:acl");
            this.assertCount("ACL", fragment, expectedAcls, "<cmis:permission>");
        }
    }

    private void assertCount(String message, String xml, int expected, String substring) {
        if (expected >= 0) {
            int count = 0;
            int i = 0;
            while ((i = xml.indexOf(substring, i)) >= 0) {
                ++count;
                ++i;
            }
            if (count != expected) {
                Assert.fail((String)(message + ": Expected to find " + substring + " " + expected + " times, but there were " + count));
            }
        }
    }

    private String assertSubstring(String message, String string, int expected, String tag) {
        String substring = string;
        if (expected >= 0) {
            String start = "<" + tag + ">";
            String end = "</" + tag + ">";
            int i = string.indexOf(start);
            if (expected == 0) {
                if (i != -1) {
                    Assert.fail((String)(message + ": Did not expect to find " + start));
                }
                substring = "";
            } else if (i == -1) {
                Assert.fail((String)(message + ": Expected to find " + start));
            } else {
                int j = string.indexOf(end, i += start.length());
                if (j == -1) {
                    Assert.fail((String)(message + ": Expected to find " + end));
                }
                substring = string.substring(i, j);
            }
        }
        return substring;
    }

    private void checkSecondaryTypes(Document doc, Set<String> expectedSecondaryTypes, Set<String> expectedMissingSecondaryTypes) {
        final List secondaryTypesList = doc.getSecondaryTypes();
        Assert.assertNotNull((Object)secondaryTypesList);
        AbstractList<String> secondaryTypes = new AbstractList<String>(){

            @Override
            public String get(int index) {
                SecondaryType type = (SecondaryType)secondaryTypesList.get(index);
                return type.getId();
            }

            @Override
            public int size() {
                return secondaryTypesList.size();
            }
        };
        if (expectedSecondaryTypes != null) {
            Assert.assertTrue((String)("Missing secondary types: " + String.valueOf(secondaryTypes)), (boolean)secondaryTypes.containsAll(expectedSecondaryTypes));
        }
        if (expectedMissingSecondaryTypes != null) {
            Assert.assertTrue((String)("Expected missing secondary types but at least one is still present: " + String.valueOf(secondaryTypes)), (!secondaryTypes.containsAll(expectedMissingSecondaryTypes) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBrowserBindingRoot() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String personId = personIt.next();
        Assert.assertNotNull((Object)personId);
        RepoService.TestPerson person = this.repoService.getPerson(personId);
        Assert.assertNotNull((Object)person);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), personId));
        HttpResponse response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void testBrowserDisabledJSONPCallback() throws Exception {
        PublicApiBrowserCMISDispatcher dispatcher = (PublicApiBrowserCMISDispatcher)this.ctx.getBean(PublicApiBrowserCMISDispatcher.class);
        dispatcher.setAllowUnsecureCallbackJSONP(false);
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String personId = personIt.next();
        Assert.assertNotNull((Object)personId);
        RepoService.TestPerson person = this.repoService.getPerson(personId);
        Assert.assertNotNull((Object)person);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), personId));
        Map<String, String> params = Map.of("callback", "");
        HttpResponse response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root", params);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        String exceptionMessage = I18NUtil.getMessage((String)JsonpCallbackNotAllowedException.DEFAULT_MESSAGE_ID, (Object[])new Object[]{params});
        Assert.assertTrue((boolean)response.getResponse().endsWith(exceptionMessage));
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void testBrowserEnabledJSONPCallback() throws Exception {
        PublicApiBrowserCMISDispatcher dispatcher = (PublicApiBrowserCMISDispatcher)this.ctx.getBean(PublicApiBrowserCMISDispatcher.class);
        dispatcher.setAllowUnsecureCallbackJSONP(true);
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String personId = personIt.next();
        Assert.assertNotNull((Object)personId);
        RepoService.TestPerson person = this.repoService.getPerson(personId);
        Assert.assertNotNull((Object)person);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), personId));
        Map<String, String> params = Map.of("callback", "someFunction");
        HttpResponse response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root", params);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void testSetMaxContentSize() throws Exception {
        final RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String personId = personIt.next();
        Assert.assertNotNull((Object)personId);
        RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = network1.createSite(siteInfo);
                return site;
            }
        }, (String)personId, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), personId));
        PublicApiClient.CmisSession cmisSessionAtom = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11, AlfrescoObjectFactoryImpl.class.getName());
        PublicApiClient.CmisSession cmisSessionBrowser = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.browser, CMIS_VERSION_11, AlfrescoObjectFactoryImpl.class.getName());
        Folder documentLibrary = (Folder)cmisSessionAtom.getObjectByPath("/Sites/" + site.getSiteId() + "/documentLibrary");
        String fileName = "test+" + GUID.generate();
        long fileLength = 0x600000L;
        RandomAccessFile f = new RandomAccessFile(fileName, "rw");
        f.setLength(fileLength);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("cmis:objectTypeId", (Serializable)((Object)TYPE_CMIS_DOCUMENT));
        properties.put("cmis:name", (Serializable)((Object)fileName));
        double maxContentSize = 5.8;
        PublicApiAlfrescoCmisServiceFactory publicApiAlfrescoCmisServiceFactory = (PublicApiAlfrescoCmisServiceFactory)this.ctx.getBean("publicApiCMISServiceFactory");
        publicApiAlfrescoCmisServiceFactory.setMaxContentSize(maxContentSize);
        FileChannel fc = f.getChannel();
        InputStream is = Channels.newInputStream(fc);
        ContentStreamImpl contentStream = new ContentStreamImpl(fileName, BigInteger.valueOf(fileLength), "text/plain", is);
        try {
            cmisSessionAtom.createDocument(documentLibrary.getId(), fileName, properties, (ContentStream)contentStream, VersioningState.MAJOR);
            Assert.fail((String)"The file should be to big to upload via atom binding");
        }
        catch (CmisConstraintException cmisConstraintException) {
            // empty catch block
        }
        fc.position(0L);
        try {
            cmisSessionBrowser.createDocument(documentLibrary.getId(), fileName, properties, (ContentStream)contentStream, VersioningState.MAJOR);
            Assert.fail((String)"The file should be to big to upload via browser binding");
        }
        catch (CmisConstraintException cmisConstraintException) {
            // empty catch block
        }
        maxContentSize = 10.6;
        publicApiAlfrescoCmisServiceFactory.setMaxContentSize(maxContentSize);
        fc.position(0L);
        Document result = cmisSessionAtom.createDocument(documentLibrary.getId(), fileName, properties, (ContentStream)contentStream, VersioningState.MAJOR);
        Assert.assertNotNull((Object)result);
        fc.position(0L);
        result = cmisSessionBrowser.createDocument(documentLibrary.getId(), fileName + "2", properties, (ContentStream)contentStream, VersioningState.MAJOR);
        Assert.assertNotNull((Object)result);
        maxContentSize = -1.0;
        publicApiAlfrescoCmisServiceFactory.setMaxContentSize(maxContentSize);
        fc.position(0L);
        result = cmisSessionAtom.createDocument(documentLibrary.getId(), fileName + "3", properties, (ContentStream)contentStream, VersioningState.MAJOR);
        Assert.assertNotNull((Object)result);
        fc.position(0L);
        result = cmisSessionBrowser.createDocument(documentLibrary.getId(), fileName + "4", properties, (ContentStream)contentStream, VersioningState.MAJOR);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testCMIS() throws Exception {
        ContentReader reader;
        FileContentWriter writer;
        ContentStreamImpl fileContent;
        HashMap<String, Object> properties;
        int i;
        final RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String personId = personIt.next();
        Assert.assertNotNull((Object)personId);
        RepoService.TestPerson person = this.repoService.getPerson(personId);
        Assert.assertNotNull((Object)person);
        RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = network1.createSite(siteInfo);
                return site;
            }
        }, (String)personId, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), personId));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        PublicApiClient.Nodes nodesProxy = this.publicApiClient.nodes();
        PublicApiClient.Comments commentsProxy = this.publicApiClient.comments();
        String expectedContent = "Ipsum and so on";
        Document doc = null;
        Folder documentLibrary = (Folder)cmisSession.getObjectByPath("/Sites/" + site.getSiteId() + "/documentLibrary");
        FolderNode expectedDocumentLibrary = (FolderNode)CMISNode.createNode((CmisObject)documentLibrary);
        Document testDoc = null;
        Folder testFolder = null;
        FolderNode testFolderNode = null;
        for (i = 0; i < 3; ++i) {
            properties = new HashMap<String, Object>();
            properties.put("cmis:objectTypeId", "cmis:folder");
            properties.put("cmis:name", "folder-" + i);
            Folder f = documentLibrary.createFolder(properties);
            FolderNode fn = (FolderNode)CMISNode.createNode((CmisObject)f);
            if (testFolder == null) {
                testFolder = f;
                testFolderNode = fn;
            }
            expectedDocumentLibrary.addFolder(fn);
            for (int k = 0; k < 3; ++k) {
                properties = new HashMap();
                properties.put("cmis:objectTypeId", "cmis:folder");
                properties.put("cmis:name", "folder-" + k);
                Folder f1 = f.createFolder(properties);
                FolderNode childFolder = (FolderNode)CMISNode.createNode((CmisObject)f1);
                fn.addFolder(childFolder);
            }
            for (int j = 0; j < 3; ++j) {
                properties = new HashMap();
                properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
                properties.put("cmis:name", "doc-" + j);
                fileContent = new ContentStreamImpl();
                writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
                writer.putContent(expectedContent);
                reader = writer.getReader();
                fileContent.setMimeType("text/plain");
                fileContent.setStream(reader.getContentInputStream());
                Document d = f.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
                if (testDoc == null) {
                    testDoc = d;
                }
                CMISNode childDocument = CMISNode.createNode((CmisObject)d);
                fn.addNode(childDocument);
            }
        }
        for (i = 0; i < 10; ++i) {
            properties = new HashMap();
            properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
            properties.put("cmis:name", "doc-" + i);
            ContentStreamImpl fileContent2 = new ContentStreamImpl();
            FileContentWriter writer2 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
            writer2.putContent(expectedContent);
            ContentReader reader2 = writer2.getReader();
            fileContent2.setMimeType("text/plain");
            fileContent2.setStream(reader2.getContentInputStream());
            documentLibrary.createDocument(properties, (ContentStream)fileContent2, VersioningState.MAJOR);
        }
        NodeRating.Aggregate aggregate = new NodeRating.Aggregate(1, null);
        NodeRating expectedNodeRating = new NodeRating("likes", true, aggregate);
        Comment expectedComment = new Comment("commenty", "commenty", false, null, person, person);
        Tag expectedTag = new Tag("taggy");
        NodeRating rating = nodesProxy.createNodeRating(testFolder.getId(), expectedNodeRating);
        expectedNodeRating.expected(rating);
        Assert.assertNotNull((Object)rating.getId());
        Comment comment = commentsProxy.createNodeComment(testFolder.getId(), expectedComment);
        expectedComment.expected(comment);
        Assert.assertNotNull((Object)comment.getId());
        aggregate = new NodeRating.Aggregate(1, null);
        expectedNodeRating = new NodeRating("likes", true, aggregate);
        expectedComment = new Comment("commenty", "commenty", false, null, person, person);
        expectedTag = new Tag("taggy");
        rating = nodesProxy.createNodeRating(testDoc.getId(), expectedNodeRating);
        expectedNodeRating.expected(rating);
        Assert.assertNotNull((Object)rating.getId());
        comment = commentsProxy.createNodeComment(testDoc.getId(), expectedComment);
        expectedComment.expected(comment);
        Assert.assertNotNull((Object)comment.getId());
        List descendants = documentLibrary.getDescendants(4);
        expectedDocumentLibrary.checkDescendants(descendants);
        HashMap<String, Object> fileProps = new HashMap<String, Object>();
        fileProps.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        fileProps.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        ContentStreamImpl fileContent3 = new ContentStreamImpl();
        FileContentWriter writer3 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer3.putContent(expectedContent);
        ContentReader reader3 = writer3.getReader();
        fileContent3.setMimeType("text/plain");
        fileContent3.setStream(reader3.getContentInputStream());
        doc = documentLibrary.createDocument(fileProps, (ContentStream)fileContent3, VersioningState.MAJOR);
        String nodeId = this.stripCMISSuffix(doc.getId());
        final NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        ContentReader reader4 = (ContentReader)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<ContentReader>(){

            public ContentReader doWork() throws Exception {
                ContentReader reader = TestCMIS.this.repoService.getContent(nodeRef, ContentModel.PROP_CONTENT);
                return reader;
            }
        }, (String)personId, (String)network1.getId());
        String actualContent = reader4.getContentString();
        Assert.assertEquals((Object)expectedContent, (Object)actualContent);
        ContentStream stream = doc.getContentStream();
        StringWriter writer4 = new StringWriter();
        IOUtils.copy((InputStream)stream.getStream(), (Writer)writer4, (String)"UTF-8");
        String actualContent2 = writer4.toString();
        Assert.assertEquals((Object)expectedContent, (Object)actualContent2);
        Folder folder = (Folder)cmisSession.getObjectByPath("/Sites/" + site.getSiteId() + "/documentLibrary/" + testFolder.getName());
        ItemIterable children = folder.getChildren();
        testFolderNode.checkChildren((ItemIterable<CmisObject>)children);
        String nodeId2 = this.stripCMISSuffix(doc.getId());
        final NodeRef nodeRef2 = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId2);
        ObjectId pwcId = doc.checkOut();
        Document pwc = (Document)cmisSession.getObject(pwcId.getId());
        Boolean isCheckedOut = (Boolean)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                Boolean isCheckedOut = TestCMIS.this.repoService.isCheckedOut(nodeRef2);
                return isCheckedOut;
            }
        }, (String)personId, (String)network1.getId());
        Assert.assertTrue((boolean)isCheckedOut);
        expectedContent = "Big bad wolf";
        fileContent = new ContentStreamImpl();
        writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent(expectedContent);
        reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        ObjectId checkinId = pwc.checkIn(true, Collections.EMPTY_MAP, (ContentStream)fileContent, "checkin 1");
        doc = (Document)cmisSession.getObject(checkinId.getId());
        isCheckedOut = (Boolean)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                Boolean isCheckedOut = TestCMIS.this.repoService.isCheckedOut(nodeRef2);
                return isCheckedOut;
            }
        }, (String)personId, (String)network1.getId());
        Assert.assertFalse((boolean)isCheckedOut);
        ContentStream stream2 = doc.getContentStream();
        StringWriter writer5 = new StringWriter();
        IOUtils.copy((InputStream)stream2.getStream(), (Writer)writer5, (String)"UTF-8");
        String actualContent3 = writer5.toString();
        Assert.assertEquals((Object)expectedContent, (Object)actualContent3);
        List allVersions = doc.getAllVersions();
        Assert.assertEquals((long)2L, (long)allVersions.size());
        Assert.assertEquals((Object)"2.0", (Object)((Document)allVersions.get(0)).getVersionLabel());
        Assert.assertEquals((Object)CMIS_VERSION_10, (Object)((Document)allVersions.get(1)).getVersionLabel());
        fileProps = new HashMap();
        fileProps.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        fileProps.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        fileContent3 = new ContentStreamImpl();
        writer3 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer3.putContent("Ipsum and so on");
        reader3 = writer3.getReader();
        fileContent3.setMimeType("text/plain");
        fileContent3.setStream(reader3.getContentInputStream());
        Document autoVersionedDoc = documentLibrary.createDocument(fileProps, (ContentStream)fileContent3, VersioningState.MAJOR);
        String objectId = autoVersionedDoc.getId();
        String bareObjectId = this.stripCMISSuffix(objectId);
        final NodeRef nodeRef3 = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, bareObjectId);
        Boolean autoVersion = (Boolean)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                Boolean autoVersion = (Boolean)TestCMIS.this.repoService.getProperty(nodeRef3, ContentModel.PROP_AUTO_VERSION);
                return autoVersion;
            }
        }, (String)personId, (String)network1.getId());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)autoVersion);
        fileProps = new HashMap();
        fileProps.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        fileProps.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        autoVersionedDoc = documentLibrary.createDocument(fileProps, (ContentStream)fileContent3, VersioningState.MAJOR);
        objectId = autoVersionedDoc.getId();
        bareObjectId = this.stripCMISSuffix(objectId);
        for (int i2 = 0; i2 < 3; ++i2) {
            Document doc1 = (Document)cmisSession.getObject(bareObjectId);
            ObjectId pwcId2 = doc1.checkOut();
            Document pwc2 = (Document)cmisSession.getObject(pwcId2.getId());
            ContentStreamImpl contentStream = new ContentStreamImpl();
            FileContentWriter writer6 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
            expectedContent = GUID.generate();
            writer6.putContent(expectedContent);
            ContentReader reader5 = writer6.getReader();
            contentStream.setMimeType("text/plain");
            contentStream.setStream(reader5.getContentInputStream());
            pwc2.checkIn(true, Collections.EMPTY_MAP, (ContentStream)contentStream, "checkin " + i2);
        }
        Document doc1 = (Document)cmisSession.getObject(bareObjectId);
        String versionLabel = doc1.getVersionLabel();
        ContentStream cs = doc1.getContentStream();
        String content = IOUtils.toString((InputStream)cs.getStream());
        Assert.assertEquals((Object)"4.0", (Object)versionLabel);
        Assert.assertEquals((Object)expectedContent, (Object)content);
    }

    public void testInvalidMethods() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String person = personIt.next();
        Assert.assertNotNull((Object)person);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person));
            this.publicApiClient.post(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, null, null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person));
            this.publicApiClient.head(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, null, null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person));
            this.publicApiClient.options(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, null, null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person));
            this.publicApiClient.trace(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, null, null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person));
            this.publicApiClient.patch(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, null, null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testPublicApi110() throws Exception {
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().networksIterator();
        final RepoService.TestNetwork network1 = networksIt.next();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String person1Id = personIt.next();
        final String person2Id = personIt.next();
        final ArrayList nodes = new ArrayList(5);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName1 = "site" + GUID.generate();
                RepoService.SiteInformation siteInfo1 = new RepoService.SiteInformation(siteName1, siteName1, siteName1, SiteVisibility.PUBLIC);
                RepoService.TestSite site1 = network1.createSite(siteInfo1);
                String siteName2 = "site" + GUID.generate();
                RepoService.SiteInformation siteInfo2 = new RepoService.SiteInformation(siteName2, siteName2, siteName2, SiteVisibility.PRIVATE);
                RepoService.TestSite site2 = network1.createSite(siteInfo2);
                NodeRef nodeRef1 = TestCMIS.this.repoService.createDocument(site1.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), "Test Doc1", "Test Doc1 Title", "Test Doc1 Description", "Test Content");
                nodes.add(nodeRef1);
                NodeRef nodeRef2 = TestCMIS.this.repoService.createDocument(site1.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), "Test Doc2", "Test Doc2 Title", "Test Doc2 Description", "Test Content");
                nodes.add(nodeRef2);
                NodeRef nodeRef3 = TestCMIS.this.repoService.createDocument(site2.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), "Test Doc2", "Test Doc2 Title", "Test Doc2 Description", "Test Content");
                nodes.add(nodeRef3);
                TestCMIS.this.repoService.createAssociation(nodeRef2, nodeRef1, ContentModel.ASSOC_ORIGINAL);
                TestCMIS.this.repoService.createAssociation(nodeRef3, nodeRef1, ContentModel.ASSOC_ORIGINAL);
                site1.inviteToSite(person2Id, SiteRole.SiteCollaborator);
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        OperationContextImpl cmisOperationCtxOverride = new OperationContextImpl();
        cmisOperationCtxOverride.setIncludeRelationships(IncludeRelationships.BOTH);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2Id, (OperationContext)cmisOperationCtxOverride));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        CmisObject o1 = cmisSession.getObject(((NodeRef)nodes.get(0)).getId());
        List relationships = o1.getRelationships();
        Assert.assertEquals((long)1L, (long)relationships.size());
        Relationship r = (Relationship)relationships.get(0);
        CmisObject source = r.getSource();
        CmisObject target = r.getTarget();
        String sourceVersionSeriesId = (String)source.getProperty("cmis:versionSeriesId").getFirstValue();
        String targetVersionSeriesId = (String)target.getProperty("cmis:versionSeriesId").getFirstValue();
        Assert.assertEquals((Object)((NodeRef)nodes.get(1)).getId(), (Object)sourceVersionSeriesId);
        Assert.assertEquals((Object)((NodeRef)nodes.get(0)).getId(), (Object)targetVersionSeriesId);
    }

    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testObjectIds() throws Exception {
        String objectId;
        String objectId2;
        String username = "enterpriseuser" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person = this.repoService.createUser(personInfo, username, null);
        String personId = person.getId();
        final ArrayList folders = new ArrayList();
        final ArrayList documents = new ArrayList();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                folders.add(folderNodeRef);
                name = GUID.generate();
                NodeRef docNodeRef = TestCMIS.this.repoService.createDocument(folderNodeRef, name, "test content");
                documents.add(docNodeRef);
                return null;
            }
        }, (String)personId);
        NodeRef folderNodeRef = (NodeRef)folders.get(0);
        NodeRef docNodeRef = (NodeRef)documents.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(personId));
        List<Repository> repositories = this.publicApiClient.getCMISRepositories();
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.getCMISSession(repositories.get(0));
        String nodeRefStr = docNodeRef.toString();
        CmisObject o = cmisSession.getObject(nodeRefStr);
        Assert.assertEquals((Object)docNodeRef.toString(), (Object)this.stripCMISSuffix(o.getId()));
        nodeRefStr = folderNodeRef.toString();
        o = cmisSession.getObject(nodeRefStr);
        Assert.assertEquals((Object)folderNodeRef.toString(), (Object)this.stripCMISSuffix(o.getId()));
        String objectId3 = docNodeRef.getId();
        o = cmisSession.getObject(objectId3);
        Assert.assertEquals((Object)objectId3, (Object)this.stripCMISSuffix(o.getId()));
        objectId3 = folderNodeRef.getId();
        o = cmisSession.getObject(objectId3);
        Assert.assertEquals((Object)objectId3, (Object)this.stripCMISSuffix(o.getId()));
        HashSet<String> expectedObjectIds = new HashSet<String>();
        expectedObjectIds.add(docNodeRef.toString());
        int numMatchingDocs = 0;
        List<CMISNode> results = cmisSession.query("SELECT * FROM cmis:document WHERE IN_TREE('" + folderNodeRef.toString() + "')", false, 0L, Integer.MAX_VALUE);
        Assert.assertEquals((long)expectedObjectIds.size(), (long)results.size());
        for (CMISNode node : results) {
            objectId2 = this.stripCMISSuffix((String)((Object)node.getProperties().get("cmis:objectId")));
            if (!expectedObjectIds.contains(objectId2)) continue;
            ++numMatchingDocs;
        }
        Assert.assertEquals((long)expectedObjectIds.size(), (long)numMatchingDocs);
        numMatchingDocs = 0;
        results = cmisSession.query("SELECT * FROM cmis:document WHERE IN_TREE('" + folderNodeRef.getId() + "')", false, 0L, Integer.MAX_VALUE);
        Assert.assertEquals((long)expectedObjectIds.size(), (long)results.size());
        for (CMISNode node : results) {
            objectId2 = this.stripCMISSuffix((String)((Object)node.getProperties().get("cmis:objectId")));
            System.out.println("objectId = " + objectId2);
            if (!expectedObjectIds.contains(objectId2)) continue;
            ++numMatchingDocs;
        }
        Assert.assertEquals((long)expectedObjectIds.size(), (long)numMatchingDocs);
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().networksIterator();
        RepoService.TestNetwork network1 = networksIt.next();
        Iterator<String> personIt = network1.getPersonIds().iterator();
        String person1Id = personIt.next();
        final ArrayList folders1 = new ArrayList();
        final ArrayList documents1 = new ArrayList();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                folders1.add(folderNodeRef);
                name = GUID.generate();
                NodeRef docNodeRef = TestCMIS.this.repoService.createDocument(folderNodeRef, name, "test content");
                documents1.add(docNodeRef);
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        folderNodeRef = (NodeRef)folders1.get(0);
        docNodeRef = (NodeRef)documents1.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        String nodeRefStr2 = docNodeRef.toString();
        CmisObject o2 = cmisSession.getObject(nodeRefStr2);
        String objectId4 = docNodeRef.getId();
        Assert.assertEquals((Object)objectId4, (Object)this.stripCMISSuffix(o2.getId()));
        nodeRefStr2 = folderNodeRef.toString();
        o2 = cmisSession.getObject(nodeRefStr2);
        objectId4 = folderNodeRef.getId();
        Assert.assertEquals((Object)objectId4, (Object)this.stripCMISSuffix(o2.getId()));
        o2 = cmisSession.getObject(objectId4);
        Assert.assertEquals((Object)objectId4, (Object)this.stripCMISSuffix(o2.getId()));
        objectId4 = folderNodeRef.getId();
        o2 = cmisSession.getObject(objectId4);
        Assert.assertEquals((Object)objectId4, (Object)this.stripCMISSuffix(o2.getId()));
        HashSet<String> expectedObjectIds2 = new HashSet<String>();
        expectedObjectIds2.add(docNodeRef.getId());
        int numMatchingDocs2 = 0;
        List<CMISNode> results2 = cmisSession.query("SELECT * FROM cmis:document WHERE IN_TREE('" + folderNodeRef.toString() + "')", false, 0L, Integer.MAX_VALUE);
        Assert.assertEquals((long)expectedObjectIds2.size(), (long)results2.size());
        for (CMISNode node : results2) {
            objectId = this.stripCMISSuffix((String)((Object)node.getProperties().get("cmis:objectId")));
            if (!expectedObjectIds2.contains(objectId)) continue;
            ++numMatchingDocs2;
        }
        Assert.assertEquals((long)expectedObjectIds2.size(), (long)numMatchingDocs2);
        numMatchingDocs2 = 0;
        results2 = cmisSession.query("SELECT * FROM cmis:document WHERE IN_TREE('" + folderNodeRef.getId() + "')", false, 0L, Integer.MAX_VALUE);
        Assert.assertEquals((long)expectedObjectIds2.size(), (long)results2.size());
        for (CMISNode node : results2) {
            objectId = this.stripCMISSuffix((String)((Object)node.getProperties().get("cmis:objectId")));
            System.out.println("objectId = " + objectId);
            if (!expectedObjectIds2.contains(objectId)) continue;
            ++numMatchingDocs2;
        }
        Assert.assertEquals((long)expectedObjectIds2.size(), (long)numMatchingDocs2);
    }

    @Test
    @Ignore(value="Quarantined since 24 Sep 2018. TestCMIS.testAspects:1546->checkSecondaryTypes:492 Missing secondary types: [P:cm:titled, P:sys:localized]")
    public void testAspects() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final ArrayList folders = new ArrayList();
        final ArrayList documents = new ArrayList();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                folders.add(folderNodeRef);
                for (int i = 0; i < 3; ++i) {
                    name = GUID.generate();
                    NodeRef docNodeRef = TestCMIS.this.repoService.createDocument(folderNodeRef, name, "test content");
                    Assert.assertFalse((boolean)TestCMIS.this.repoService.getAspects(docNodeRef).contains(ContentModel.ASPECT_TITLED));
                    documents.add(docNodeRef);
                }
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        final NodeRef doc1NodeRef = (NodeRef)documents.get(0);
        final NodeRef doc2NodeRef = (NodeRef)documents.get(1);
        final NodeRef doc3NodeRef = (NodeRef)documents.get(2);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession atomCmisSession10 = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        PublicApiClient.CmisSession atomCmisSession11 = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        PublicApiClient.CmisSession browserCmisSession11 = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.browser, CMIS_VERSION_11);
        AlfrescoDocument doc = (AlfrescoDocument)atomCmisSession10.getObject(doc1NodeRef.getId());
        doc = (AlfrescoDocument)doc.addAspect(new String[]{"P:cm:titled"});
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc1NodeRef);
                Assert.assertTrue((String)("Missing aspect in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        doc.removeAspect(new String[]{"P:cm:titled"});
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc1NodeRef);
                Assert.assertFalse((String)("Unexpected aspect in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        doc = (Document)atomCmisSession11.getObject(doc2NodeRef.getId());
        List secondaryTypesList = doc.getSecondaryTypes();
        ArrayList<String> secondaryTypes = new ArrayList<String>();
        if (secondaryTypesList != null) {
            for (SecondaryType secondaryType : secondaryTypesList) {
                secondaryTypes.add(secondaryType.getId());
            }
        }
        secondaryTypes.add("P:sys:temporary");
        secondaryTypes.add("P:cm:titled");
        HashMap<String, ArrayList<String>> properties = new HashMap<String, ArrayList<String>>();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
        Document doc1 = (Document)doc.updateProperties(properties);
        this.checkSecondaryTypes(doc1, new HashSet<String>(Arrays.asList("P:sys:temporary", "P:cm:titled")), null);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc2NodeRef);
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TEMPORARY));
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        secondaryTypes.add("P:cm:author");
        properties = new HashMap();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
        Document doc2 = (Document)doc1.updateProperties(properties);
        this.checkSecondaryTypes(doc2, new HashSet<String>(Arrays.asList("P:sys:temporary", "P:cm:titled", "P:cm:author")), null);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc2NodeRef);
                String title = (String)((Object)TestCMIS.this.repoService.getProperty(doc2NodeRef, ContentModel.PROP_TITLE));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_AUTHOR));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TEMPORARY));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                Assert.assertEquals(null, (Object)title);
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        secondaryTypes.remove("P:cm:titled");
        properties = new HashMap();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
        Document doc3 = (Document)doc2.updateProperties(properties);
        this.checkSecondaryTypes(doc3, new HashSet<String>(Arrays.asList("P:sys:temporary", "P:cm:author")), new HashSet<String>(Arrays.asList("P:cm:titled")));
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc2NodeRef);
                String title = (String)((Object)TestCMIS.this.repoService.getProperty(doc2NodeRef, ContentModel.PROP_TITLE));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_AUTHOR));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TEMPORARY));
                Assert.assertFalse((String)("Unexpected aspect in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                Assert.assertEquals(null, (Object)title);
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        doc = (Document)browserCmisSession11.getObject(doc3NodeRef.getId());
        secondaryTypesList = doc.getSecondaryTypes();
        secondaryTypes = new ArrayList();
        if (secondaryTypesList != null) {
            for (SecondaryType secondaryType : secondaryTypesList) {
                secondaryTypes.add(secondaryType.getId());
            }
        }
        secondaryTypes.add("P:sys:temporary");
        secondaryTypes.add("P:cm:titled");
        properties = new HashMap<String, ArrayList<String>>();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
        doc1 = (Document)doc.updateProperties(properties);
        this.checkSecondaryTypes(doc1, new HashSet<String>(Arrays.asList("P:sys:temporary", "P:cm:titled")), null);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc3NodeRef);
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TEMPORARY));
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        secondaryTypes.add("P:cm:author");
        properties = new HashMap();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
        doc2 = (Document)doc1.updateProperties(properties);
        this.checkSecondaryTypes(doc2, new HashSet<String>(Arrays.asList("P:sys:temporary", "P:cm:titled", "P:cm:author")), null);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc3NodeRef);
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TEMPORARY));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_AUTHOR));
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        secondaryTypes.remove("P:cm:titled");
        properties = new HashMap();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
        doc3 = (Document)doc2.updateProperties(properties);
        this.checkSecondaryTypes(doc3, new HashSet<String>(Arrays.asList("P:sys:temporary", "P:cm:author")), new HashSet<String>(Arrays.asList("P:cm:titled")));
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Set<QName> aspects = TestCMIS.this.repoService.getAspects(doc3NodeRef);
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_AUTHOR));
                Assert.assertTrue((String)("Missing aspects in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TEMPORARY));
                Assert.assertFalse((String)("Unexpected aspect in current set " + String.valueOf(aspects)), (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
    }

    @Test
    public void testTypeFiltering() throws Exception {
        this.cmisTypeExclusions.setExcluded(ActionModel.TYPE_ACTION_BASE, true);
        Assert.assertTrue((boolean)this.cmisTypeExclusions.isExcluded(ActionModel.TYPE_ACTION_BASE));
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("publicapi/test-model.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.setTenantService(this.tenantService);
        bootstrap.bootstrap();
        this.cmisDictionary.afterDictionaryInit();
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        QName type = QName.createQName((String)"{http://www.alfresco.org/test/testCMIS}type1");
        Assert.assertTrue((boolean)this.cmisTypeExclusions.isExcluded(type));
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        try {
            cmisSession.getTypeDefinition("D:testCMIS:type1");
            Assert.fail((String)"Type should not be available");
        }
        catch (CmisObjectNotFoundException cmisObjectNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCreationDate() throws Exception {
        GregorianCalendar cDateSecond;
        final RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = network1.createSite(siteInfo);
                NodeRef resNode = TestCMIS.this.repoService.createDocument(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), "testdoc.txt", "Test Doc1 Title", "Test Doc1 Description", "Test Content");
                return resNode;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        AlfrescoFolder docLibrary = (AlfrescoFolder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("some content");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        Document autoVersionedDoc = docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        Thread.sleep(5000L);
        String objectId = autoVersionedDoc.getId();
        String bareObjectId = this.stripCMISSuffix(objectId);
        for (int i = 0; i < 3; ++i) {
            Document doc1 = (Document)cmisSession.getObject(bareObjectId);
            ObjectId pwcId = doc1.checkOut();
            Document pwc = (Document)cmisSession.getObject(pwcId.getId());
            ContentStreamImpl contentStream = new ContentStreamImpl();
            FileContentWriter writer2 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
            writer2.putContent(GUID.generate());
            ContentReader reader2 = writer2.getReader();
            contentStream.setMimeType("text/plain");
            contentStream.setStream(reader2.getContentInputStream());
            Thread.sleep(5000L);
            pwc.checkIn(true, Collections.EMPTY_MAP, (ContentStream)contentStream, "checkin " + i);
        }
        GregorianCalendar cDateFirst = cmisSession.getAllVersions(bareObjectId).get(0).getCreationDate();
        if (cDateFirst.before(cDateSecond = cmisSession.getAllVersions(bareObjectId).get(2).getCreationDate()) || cDateFirst.after(cDateSecond)) {
            Assert.fail((String)"The creation date of version should be the same as creation date of the original node");
        }
    }

    @Test
    public void testVersioning() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        AlfrescoFolder docLibrary = (AlfrescoFolder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        AlfrescoDocument doc = (AlfrescoDocument)docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        String versionLabel = doc.getVersionLabel();
        properties = new HashMap();
        properties.put("cmis:description", GUID.generate());
        AlfrescoDocument doc1 = (AlfrescoDocument)doc.updateProperties(properties);
        doc1 = (AlfrescoDocument)doc1.getObjectOfLatestVersion(false);
        String versionLabel1 = doc1.getVersionLabel();
        Assert.assertTrue((Float.parseFloat(versionLabel) < Float.parseFloat(versionLabel1) ? 1 : 0) != 0);
        fileContent = new ContentStreamImpl();
        FileContentWriter writer2 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer2.putContent("Ipsum and so on and so on");
        ContentReader reader2 = writer2.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader2.getContentInputStream());
        doc1.setContentStream((ContentStream)fileContent, true);
        AlfrescoDocument doc2 = (AlfrescoDocument)doc1.getObjectOfLatestVersion(false);
        String versionLabel2 = doc2.getVersionLabel();
        Assert.assertTrue((String)"Set content stream should create a new version automatically", (Float.parseFloat(versionLabel1) < Float.parseFloat(versionLabel2) ? 1 : 0) != 0);
    }

    @Test
    public void testVersioningUsingUpdateProperties() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        AlfrescoFolder docLibrary = (AlfrescoFolder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        AlfrescoDocument doc = (AlfrescoDocument)docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        String versionLabel = doc.getVersionLabel();
        String nodeRefStr = doc.getPropertyValue("alfcmis:nodeRef").toString();
        final NodeRef nodeRef = new NodeRef(nodeRefStr);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                Assert.assertTrue((boolean)TestCMIS.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE));
                HashMap<QName, Boolean> versionProperties = new HashMap<QName, Boolean>();
                versionProperties.put(ContentModel.PROP_AUTO_VERSION, true);
                versionProperties.put(ContentModel.PROP_INITIAL_VERSION, true);
                versionProperties.put(ContentModel.PROP_AUTO_VERSION_PROPS, true);
                TestCMIS.this.nodeService.addProperties(nodeRef, versionProperties);
                return null;
            }
        }, (String)person1Id, (String)network1.getId());
        properties = new HashMap();
        properties.put("cmis:description", GUID.generate());
        AlfrescoDocument doc1 = (AlfrescoDocument)doc.getObjectOfLatestVersion(false).updateProperties(properties);
        doc1 = (AlfrescoDocument)doc.getObjectOfLatestVersion(false);
        String versionLabel1 = doc1.getVersionLabel();
        Assert.assertTrue((Double.parseDouble(versionLabel) < Double.parseDouble(versionLabel1) ? 1 : 0) != 0);
        fileContent = new ContentStreamImpl();
        FileContentWriter writer2 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer2.putContent("Ipsum and so on and so on");
        ContentReader reader2 = writer2.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader2.getContentInputStream());
        doc1.setContentStream((ContentStream)fileContent, true);
        AlfrescoDocument doc2 = (AlfrescoDocument)doc1.getObjectOfLatestVersion(false);
        String versionLabel2 = doc2.getVersionLabel();
        Assert.assertTrue((String)"Set content stream should create a new version automatically", (Double.parseDouble(versionLabel1) < Double.parseDouble(versionLabel2) ? 1 : 0) != 0);
        Assert.assertTrue((String)("It should be latest version : " + versionLabel2), (boolean)doc2.isLatestVersion());
        doc2.deleteContentStream();
        AlfrescoDocument doc3 = (AlfrescoDocument)doc2.getObjectOfLatestVersion(false);
        String versionLabel3 = doc3.getVersionLabel();
        Assert.assertTrue((String)"Delete content stream should create a new version automatically", (Double.parseDouble(versionLabel1) < Double.parseDouble(versionLabel3) ? 1 : 0) != 0);
        Assert.assertTrue((String)("It should be latest version : " + versionLabel3), (boolean)doc3.isLatestVersion());
    }

    @Test
    public void testGetXmlWithIncorrectDescription() throws Exception {
        final RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        NodeRef fileNode = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = network1.createSite(siteInfo);
                NodeRef resNode = TestCMIS.this.repoService.createDocument(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), "testdoc \u0010.txt", "Test Doc1 Title \u0010", "d\u0010", "Test Content");
                return resNode;
            }
        }, (String)person1Id, (String)network1.getId());
        String cmisId = fileNode.getId();
        HashMap<String, String> reqParams = new HashMap<String, String>();
        reqParams.put("id", cmisId + ";1.0");
        reqParams.put("filter", "*");
        reqParams.put("includeAllowableActions", "true");
        reqParams.put("includeACL", "true");
        reqParams.put("includePolicyIds", "true");
        reqParams.put("includeRelationships", "both");
        reqParams.put("renditionFilter", "*");
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        HttpResponse resp = this.publicApiClient.get(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11, "id", reqParams);
        String xml = resp.getResponse();
        Assert.assertTrue((String)"No end tag was found", (boolean)xml.endsWith("</atom:entry>"));
    }

    @Test
    public void testGetXmlWithCorrectCurrencySymbols() throws Exception {
        final RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        NodeRef fileNode = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = network1.createSite(siteInfo);
                NodeRef resNode = TestCMIS.this.repoService.createDocument(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), "Euro \u20ac Pound \u00a3 Franc \u20a3.txt", "Euro \u20ac Pound \u00a3 Franc \u20a3 File", "\u20a3 \u00a3 \u20a3", "\u20a3 \u00a3 \u20a3");
                return resNode;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession atomCmisSession10 = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        String objectId = fileNode.getId();
        Document doc = (Document)atomCmisSession10.getObject(objectId);
        String name = (String)doc.getProperty("cmis:name").getFirstValue();
        String title = (String)doc.getProperty("cm:title").getFirstValue();
        String description = (String)doc.getProperty("cm:description").getFirstValue();
        Assert.assertEquals((Object)"Euro \u20ac Pound \u00a3 Franc \u20a3.txt", (Object)name);
        Assert.assertEquals((Object)"Euro \u20ac Pound \u00a3 Franc \u20a3 File", (Object)title);
        Assert.assertEquals((Object)"\u20a3 \u00a3 \u20a3", (Object)description);
    }

    @Test
    public void testALF19320() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        AlfrescoFolder docLibrary = (AlfrescoFolder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", "cmis:document,P:cm:titled,P:cm:author");
        properties.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        AlfrescoDocument doc = (AlfrescoDocument)docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        String versionLabel = doc.getVersionLabel();
        Assert.assertEquals((Object)CMIS_VERSION_10, (Object)versionLabel);
        AlfrescoDocument doc1 = (AlfrescoDocument)doc.getObjectOfLatestVersion(false);
        String versionLabel1 = doc1.getVersionLabel();
        Assert.assertEquals((Object)CMIS_VERSION_10, (Object)versionLabel1);
    }

    @Test
    public void testAppendContentVersioning() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Folder docLibrary = (Folder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        String name = GUID.generate() + ".txt";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        Document doc = docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        String versionLabel1 = doc.getObjectOfLatestVersion(false).getVersionLabel();
        for (int i = 0; i < 5; ++i) {
            doc.appendContentStream((ContentStream)fileContent, false);
        }
        String versionLabel2 = doc.getObjectOfLatestVersion(false).getVersionLabel();
        Assert.assertEquals((Object)versionLabel1, (Object)versionLabel2);
        doc.appendContentStream((ContentStream)fileContent, true);
        String versionLabel3 = doc.getObjectOfLatestVersion(false).getVersionLabel();
        Integer majorVer1 = Integer.valueOf(versionLabel2.substring(0, 1));
        Integer majorVer2 = Integer.valueOf(versionLabel3.substring(0, 1));
        Integer minorVer1 = Integer.valueOf(versionLabel2.substring(2, 3));
        Integer minorVer2 = Integer.valueOf(versionLabel3.substring(2, 3));
        Assert.assertEquals((Object)majorVer1, (Object)majorVer2);
        Assert.assertEquals((Object)(minorVer1 + 1), (Object)minorVer2);
    }

    @Test
    public void testAppendContentStream() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Folder docLibrary = (Folder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        String name = "mydoc-" + GUID.generate() + ".txt";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        Document doc = docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        for (int i = 0; i < 5; ++i) {
            fileContent = new ContentStreamImpl();
            FileContentWriter writer2 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
            writer2.putContent("Ipsum and so on");
            ContentReader reader2 = writer2.getReader();
            fileContent.setMimeType("text/plain");
            fileContent.setStream(reader2.getContentInputStream());
            doc.appendContentStream((ContentStream)fileContent, false);
        }
        fileContent = new ContentStreamImpl();
        FileContentWriter writer3 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer3.putContent("Ipsum and so on");
        ContentReader reader3 = writer3.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader3.getContentInputStream());
        doc.appendContentStream((ContentStream)fileContent, true);
        String path = "/Sites/" + siteName + "/documentLibrary/" + name;
        Document doc1 = (Document)cmisSession.getObjectByPath(path);
        ContentStream contentStream = doc1.getContentStream();
        InputStream in = contentStream.getStream();
        StringWriter writer4 = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer4, (String)"UTF-8");
        String content = writer4.toString();
        Assert.assertEquals((Object)"Ipsum and so onIpsum and so onIpsum and so onIpsum and so onIpsum and so onIpsum and so onIpsum and so on", (Object)content);
    }

    @Test
    public void testSecondaryTypes() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Folder docLibrary = (Folder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        String name = "mydoc-" + GUID.generate() + ".txt";
        ArrayList<String> secondaryTypes = new ArrayList<String>();
        secondaryTypes.add("P:cm:summarizable");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
        properties.put("cm:summary", "My summary");
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        Document doc = docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        this.checkSecondaryTypes(doc, Collections.singleton("P:cm:summarizable"), null);
        String summary = (String)doc.getProperty("cm:summary").getFirstValue();
        Assert.assertEquals((Object)"My summary", (Object)summary);
        doc = (Document)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary/" + name);
        this.checkSecondaryTypes(doc, Collections.singleton("P:cm:summarizable"), null);
        summary = (String)doc.getProperty("cm:summary").getFirstValue();
        Assert.assertEquals((Object)"My summary", (Object)summary);
        properties = new HashMap();
        properties.put("cm:summary", "My updated summary");
        doc.updateProperties(properties);
        doc = (Document)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary/" + name);
        this.checkSecondaryTypes(doc, Collections.singleton("P:cm:summarizable"), null);
        summary = (String)doc.getProperty("cm:summary").getFirstValue();
        Assert.assertEquals((Object)"My updated summary", (Object)summary);
        this.checkSecondaryTypes(doc, Collections.singleton("P:cm:summarizable"), null);
        summary = (String)doc.getProperty("cm:summary").getFirstValue();
        Assert.assertEquals((Object)"My updated summary", (Object)summary);
    }

    @Test
    public void testMNT_10161() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        String nodeDescription = "Test description";
        final String nodeName = GUID.generate();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), nodeName);
                return TestCMIS.this.repoService.createDocument(folderNodeRef, nodeName, "title", "Test description", "content");
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Document doc = (Document)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary/" + nodeName + "/" + nodeName);
        Assert.assertNotNull((Object)doc);
        Property descrProperty = doc.getProperty("cmis:description");
        Assert.assertTrue((boolean)"Test description".equals(descrProperty.getValue()));
    }

    @Test
    public void testMNT_10687() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Folder docLibrary = (Folder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        String name = "mydoc-" + GUID.generate() + ".txt";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        Document doc = docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        Thread.sleep(3000L);
        ObjectId pwcId = doc.checkOut();
        Document pwc = (Document)cmisSession.getObject(pwcId.getId());
        fileContent = new ContentStreamImpl();
        FileContentWriter writer2 = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer2.putContent(" and so on");
        ContentReader reader2 = writer2.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader2.getContentInputStream());
        pwc.appendContentStream((ContentStream)fileContent, true);
        pwc.checkIn(false, null, null, "Check In");
        ContentStream contentStream = doc.getObjectOfLatestVersion(false).getContentStream();
        InputStream in = contentStream.getStream();
        StringWriter writer3 = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer3, (String)"UTF-8");
        String content = writer3.toString();
        Assert.assertEquals((Object)"Ipsum and so on", (Object)content);
    }

    @Test
    public void testMNT_13057() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        String guid = GUID.generate();
        String name = guid + "_KRUIS_LOGO_100%_PMS.txt";
        String urlFileName = guid + "_KRUIS_LOGO_100%25_PMS.txt";
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Folder docLibrary = (Folder)cmisSession.getObjectByPath("/Sites/" + siteName + "/documentLibrary");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
        writer.putContent("Ipsum");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        Document doc = docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        String id = doc.getId();
        Assert.assertNotNull((Object)id);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", URLEncoder.encode((String)id));
        urlFileName = urlFileName + "?id=" + URLEncoder.encode((String)id);
        HttpResponse response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/atom/content/" + urlFileName, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void testMNT10430() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.browser, CMIS_VERSION_11, AlfrescoObjectFactoryImpl.class.getName());
        ObjectType objectType = cmisSession.getTypeDefinition("D:testcmis:maDoc");
        List mandatoryAspects = ((AlfrescoType)objectType).getMandatoryAspects();
        System.out.println("Mandatory Aspects");
        for (String mandatoryAspect : mandatoryAspects) {
            System.out.println(mandatoryAspect);
        }
        Assert.assertTrue((String)"The aspects should have P:cm:generalclassifiable", (boolean)mandatoryAspects.contains("P:cm:generalclassifiable"));
    }

    @Test
    public void testContentDisposition_MNT_17477() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.browser, CMIS_VERSION_11, AlfrescoObjectFactoryImpl.class.getName());
        Folder folder = (Folder)cmisSession.getObjectByPath("/Shared");
        String name = GUID.generate() + ".jpg";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        fileContent.setMimeType("image/jpeg");
        fileContent.setStream(this.getClass().getResourceAsStream("/test.jpg"));
        Document doc = folder.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        String docId = doc.getId();
        HttpResponse response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root/Shared/" + name, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getHeaders().get("Content-Disposition").startsWith("inline"));
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root/Shared/" + name + "?download=inline", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getHeaders().get("Content-Disposition").startsWith("inline"));
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root/Shared/" + name + "?download=attachment", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getHeaders().get("Content-Disposition").startsWith("attachment"));
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/atom/content?id=" + docId, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getHeaders().get("Content-Disposition").startsWith("attachment"));
        name = GUID.generate() + ".html";
        properties = new HashMap();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".html"));
        writer.putContent("<html><script>alert(123);</script><body>Hello <b>world</b></body</html>");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/html");
        fileContent.setStream(reader.getContentInputStream());
        doc = folder.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        docId = doc.getId();
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root/Shared/" + name, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getHeaders().get("Content-Disposition").startsWith("attachment;"));
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/browser/root/Shared/" + name + "?download=inline", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getHeaders().get("Content-Disposition").startsWith("attachment;"));
        response = this.publicApiClient.get(network1.getId() + "/public/cmis/versions/1.1/atom/content?id=" + docId, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getHeaders().get("Content-Disposition").startsWith("attachment;"));
    }

    @Test
    public void testDeleteNonCurrentVersion() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person = network1.createUser(personInfo);
        String personId = person.getId();
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), personId));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.browser, CMIS_VERSION_11, AlfrescoObjectFactoryImpl.class.getName());
        Folder homeFolder = (Folder)cmisSession.getObjectByPath("/User Homes/" + personId);
        Assert.assertNotNull((Object)homeFolder.getId());
        String name = String.format(TEST_DOCUMENT_NAME_PATTERN, GUID.generate());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        ByteArrayInputStream stream = new ByteArrayInputStream(GUID.generate().getBytes());
        fileContent.setMimeType("text/plain");
        fileContent.setStream((InputStream)stream);
        final Document doc = homeFolder.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        String versionLabel = doc.getVersionLabel();
        Assert.assertEquals((Object)CMIS_VERSION_10, (Object)versionLabel);
        Document docVersionToDelete = null;
        Document latestDoc = doc;
        int cnt = 4;
        for (int i = 1; i <= cnt; ++i) {
            fileContent = new ContentStreamImpl();
            FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)GUID.generate(), (String)".txt"));
            writer.putContent("Ipsum and so on and so on " + i);
            ContentReader reader = writer.getReader();
            fileContent.setMimeType("text/plain");
            fileContent.setStream(reader.getContentInputStream());
            latestDoc.setContentStream((ContentStream)fileContent, true);
            latestDoc = latestDoc.getObjectOfLatestVersion(false);
            versionLabel = latestDoc.getVersionLabel();
            Assert.assertEquals((Object)("1." + i), (Object)versionLabel);
            Assert.assertEquals((long)(1 + i), (long)cmisSession.getAllVersions(latestDoc.getId()).size());
            if (i != 2) continue;
            docVersionToDelete = latestDoc;
        }
        String username2 = "user" + System.currentTimeMillis();
        PersonInfo person2Info = new PersonInfo(username2, username2, username2, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person2 = network1.createUser(person2Info);
        final String person2Id = person2.getId();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String nodeId = TestCMIS.this.stripCMISSuffix(doc.getId());
                NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
                TestCMIS.this.permissionService.setPermission(nodeRef, person2Id, "Read", true);
                return null;
            }
        }, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2Id));
        PublicApiClient.CmisSession cmisSession2 = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.browser, CMIS_VERSION_11, AlfrescoObjectFactoryImpl.class.getName());
        CmisObject docVersionToDeleteBy2 = cmisSession2.getObject(docVersionToDelete.getId());
        try {
            docVersionToDeleteBy2.delete(false);
            Assert.fail((String)"Node version was deleted without permissions.");
        }
        catch (CmisPermissionDeniedException cmisPermissionDeniedException) {
            // empty catch block
        }
        docVersionToDelete.delete(false);
        Assert.assertEquals((long)cnt, (long)cmisSession.getAllVersions(doc.getId()).size());
    }

    @Test
    public void testMnt11631() throws Exception {
        RepoService.TestNetwork network = this.getTestFixture().getRandomNetwork();
        String username = String.format(TEST_USER_NAME_PATTERN, System.currentTimeMillis());
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person = network.createUser(personInfo);
        String personId = person.getId();
        final String siteName = String.format(TEST_SITE_NAME_PATTERN, System.currentTimeMillis());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)personId, (String)network.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network.getId(), personId));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Folder docLibrary = (Folder)cmisSession.getObjectByPath(String.format(DOCUMENT_LIBRARY_PATH_PATTERN, siteName));
        String name = String.format(TEST_DOCUMENT_NAME_PATTERN, GUID.generate());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        properties.put("cmis:name", name);
        ContentStreamImpl fileContent = new ContentStreamImpl();
        ByteArrayInputStream stream = new ByteArrayInputStream(GUID.generate().getBytes());
        fileContent.setMimeType("text/plain");
        fileContent.setStream((InputStream)stream);
        Document doc = docLibrary.createDocument(properties, (ContentStream)fileContent, VersioningState.MAJOR);
        Thread.sleep(5000L);
        ObjectId pwcId = doc.checkOut();
        Document pwc = (Document)cmisSession.getObject(pwcId.getId());
        this.assertIsPwcProperty((CmisObject)pwc, false);
        cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10);
        CmisObject pwc10 = cmisSession.getObject(pwc.getId());
        this.assertIsPwcProperty(pwc10, true);
    }

    private void assertIsPwcProperty(CmisObject pwc, boolean nullExpected) {
        boolean isPwcFound = false;
        Boolean isPwcValueTrue = null;
        for (Property property : pwc.getProperties()) {
            if (null == property || !"cmis:isPrivateWorkingCopy".equals(property.getId())) continue;
            isPwcFound = true;
            isPwcValueTrue = (Boolean)property.getValue();
            break;
        }
        if (nullExpected) {
            Assert.assertTrue((String)"'cmis:isPrivateWorkingCopy' property is not null!", (!isPwcFound || null == isPwcValueTrue ? 1 : 0) != 0);
            return;
        }
        Assert.assertTrue((String)"'cmis:isPrivateWorkingCopy' property has not been found!", (boolean)isPwcFound);
        Assert.assertNotNull((String)"'cmis:isPrivateWorkingCopy' property value must not be null!", isPwcValueTrue);
        Assert.assertTrue((String)"'cmis:isPrivateWorkingCopy' property value must be equal to 'true'!", (boolean)isPwcValueTrue);
    }

    @Test
    public void testCanConnectCMISUsingDefaultTenant() throws Exception {
        this.testCanConnectCMISUsingDefaultTenantImpl(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        this.testCanConnectCMISUsingDefaultTenantImpl(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10);
        this.testCanConnectCMISUsingDefaultTenantImpl(CMISDispatcherRegistry.Binding.browser, CMIS_VERSION_11);
    }

    private void testCanConnectCMISUsingDefaultTenantImpl(CMISDispatcherRegistry.Binding binding, String cmisVersion) {
        String url = this.httpClient.getPublicApiCmisUrl("-default-", binding, cmisVersion, null);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", "admin");
        parameters.put("org.apache.chemistry.opencmis.password", "admin");
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        parameters.put("org.apache.chemistry.opencmis.binding.browser.url", url);
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", binding.getOpenCmisBinding().value());
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        List repositories = factory.getRepositories(parameters);
        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", "-default-");
        Session session = factory.createSession(parameters);
        ObjectType objectType = session.getTypeDefinition(TYPE_CMIS_DOCUMENT);
        Assert.assertNotNull((Object)objectType);
    }

    @Test
    public void testACE3433() throws Exception {
        RepoService.TestNetwork network = this.getTestFixture().getRandomNetwork();
        NodeRef rootNodeRef = (NodeRef)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef rootNodeRef = TestCMIS.this.repoService.getNodeService().getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                List childAssocs = TestCMIS.this.repoService.getNodeService().getChildAssocsByPropertyValue(rootNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Company Home"));
                Assert.assertEquals((long)1L, (long)childAssocs.size());
                NodeRef companyHomeNodeRef = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
                return companyHomeNodeRef;
            }
        }, (String)network.getId());
        Assert.assertNotNull((Object)rootNodeRef);
        CMISDispatcherRegistry.Binding binding = CMISDispatcherRegistry.Binding.atom;
        String url = this.httpClient.getPublicApiCmisUrl("-default-", binding, CMIS_VERSION_11, null);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("org.apache.chemistry.opencmis.user", "admin@" + network.getId());
        parameters.put("org.apache.chemistry.opencmis.password", "admin");
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", binding.getOpenCmisBinding().value());
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        Repository repository = (Repository)factory.getRepositories(parameters).get(0);
        String rootFolderId = repository.getRootFolderId();
        Assert.assertEquals((Object)rootNodeRef.getId(), (Object)rootFolderId);
        binding = CMISDispatcherRegistry.Binding.browser;
        url = this.httpClient.getPublicApiCmisUrl("-default-", binding, CMIS_VERSION_11, null);
        parameters = new HashMap();
        parameters.put("org.apache.chemistry.opencmis.user", "admin@" + network.getId());
        parameters.put("org.apache.chemistry.opencmis.password", "admin");
        parameters.put("org.apache.chemistry.opencmis.binding.browser.url", url);
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", binding.getOpenCmisBinding().value());
        factory = SessionFactoryImpl.newInstance();
        repository = (Repository)factory.getRepositories(parameters).get(0);
        rootFolderId = repository.getRootFolderId();
        Assert.assertEquals((Object)rootNodeRef.getId(), (Object)rootFolderId);
    }

    @Test
    public void testMNT12956QueryingCMIS11UsesDictionary11() throws Exception {
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person = network1.createUser(personInfo);
        String personId = person.getId();
        final ArrayList documents = new ArrayList();
        final String filename = GUID.generate();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                NodeRef docNodeRef = TestCMIS.this.repoService.createDocument(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), filename, "test content");
                documents.add(docNodeRef);
                return null;
            }
        }, (String)personId, (String)network1.getId());
        NodeRef docNodeRef = (NodeRef)documents.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), personId));
        PublicApiClient.CmisSession atomCmisSession10 = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_10, AlfrescoObjectFactoryImpl.class.getName());
        PublicApiClient.CmisSession atomCmisSession11 = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        HashSet<String> expectedObjectIds = new HashSet<String>();
        expectedObjectIds.add(docNodeRef.getId());
        int numMatchingDocs = 0;
        List<CMISNode> results = atomCmisSession11.query("SELECT cmis:objectId,cmis:name,cmis:secondaryObjectTypeIds FROM cmis:document WHERE cmis:name LIKE '" + filename + "'", false, 0L, Integer.MAX_VALUE);
        Assert.assertEquals((long)expectedObjectIds.size(), (long)results.size());
        for (CMISNode node : results) {
            String objectId = this.stripCMISSuffix((String)((Object)node.getProperties().get("cmis:objectId")));
            if (!expectedObjectIds.contains(objectId)) continue;
            ++numMatchingDocs;
        }
        Assert.assertEquals((long)expectedObjectIds.size(), (long)numMatchingDocs);
        try {
            results = atomCmisSession10.query("SELECT cmis:objectId,cmis:name,cmis:secondaryObjectTypeIds FROM cmis:document WHERE cmis:name LIKE '" + filename + "'", false, 0L, Integer.MAX_VALUE);
            Assert.fail((String)"OpenCMIS 1.0 knows nothing about cmis:secondaryObjectTypeIds");
        }
        catch (CmisInvalidArgumentException cmisInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetIdParamsMaximum() throws Exception {
        this.assertGetIdFilterParams(45, 2, 3, 18, 0, 11, "renditionFilter", "*", "includeRelationships", "both", "includeAllowableActions", "true", "includePolicyIds", "true", "includeACL", "true");
    }

    @Test
    public void testGetIdParamsDefault() throws Exception {
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, new String[0]);
    }

    @Test
    public void testGetIdParamsMinimum() throws Exception {
        this.assertGetIdFilterParams(6, 0, 0, 0, 0, 0, "filter", "none");
    }

    @Test
    public void testGetIdParamsProperties() throws Exception {
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, new String[0]);
        this.assertGetIdFilterParams(6, 0, 0, 0, 0, 0, "filter", "none");
        this.assertGetIdFilterParams(8, 0, 0, 0, 0, 0, "filter", "cmis:isMajorVersion,cmis:isPrivateWorkingCopy");
        this.assertGetIdFilterParams(6, 0, 0, 0, 0, 0, "filter", "doesNotExist");
    }

    @Test
    public void testGetIdParamsRenditions() throws Exception {
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, new String[0]);
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, "renditionFilter", "cmis:none");
        this.assertGetIdFilterParams(45, 2, 0, 0, 0, 0, "renditionFilter", "*");
        this.assertGetIdFilterParams(45, 1, 0, 0, 0, 0, "renditionFilter", "application/pdf");
        this.assertGetIdFilterParams(45, 1, 0, 0, 0, 0, "renditionFilter", "image/p*");
    }

    @Test
    public void testGetIdParamsRelationships() throws Exception {
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, new String[0]);
        this.assertGetIdFilterParams(45, 0, 3, 0, 0, 0, "includeRelationships", "both");
        this.assertGetIdFilterParams(45, 0, 1, 0, 0, 0, "includeRelationships", "source");
        this.assertGetIdFilterParams(45, 0, 2, 0, 0, 0, "includeRelationships", "target");
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, "includeRelationships", "none");
    }

    @Test
    public void testGetIdParamsActions() throws Exception {
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, new String[0]);
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, "includeAllowableActions", "false");
        this.assertGetIdFilterParams(45, 0, 0, 18, 0, 0, "includeAllowableActions", "true");
    }

    @Test
    public void testGetIdParamsPolicies() throws Exception {
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, new String[0]);
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, "includePolicyIds", "false");
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, "includePolicyIds", "true");
    }

    @Test
    public void testGetIdParamsACLs() throws Exception {
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, new String[0]);
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 0, "includeACL", "false");
        this.assertGetIdFilterParams(45, 0, 0, 0, 0, 11, "includeACL", "true");
    }

    @Ignore
    @Test
    public void testGetIdParamsPropertiesAreUnique() throws Exception {
        String cmisId = this.getTestFileIdWithTwoRenditionsOneSourceAndTwoTargetAssociations();
        HashMap<String, String> reqParams = new HashMap<String, String>();
        reqParams.put("id", cmisId);
        this.publicApiClient.setRequestContext(new RequestContext(this.testNetwork.getId(), this.testPersonId));
        HttpResponse resp = this.publicApiClient.get(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11, "id", reqParams);
        String xml = resp.getResponse();
        System.out.println(xml);
        String tmp1 = xml.split("cmis:properties")[1];
        String tmp2 = tmp1.substring(0, tmp1.indexOf("<e1:aspects"));
        String[] tmp3 = tmp2.split("queryName=\"");
        ArrayList<Object> names = new ArrayList<Object>();
        for (int j = 1; j < tmp3.length; j += 2) {
            String tmp4 = tmp3[j];
            String name = tmp4.substring(0, tmp4.indexOf(34));
            names.add(name);
        }
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (String string : names) {
            if (uniqueNames.add(string)) continue;
            duplicates.add(string);
        }
        if (!duplicates.isEmpty()) {
            StringJoiner sj = new StringJoiner(", ");
            for (String duplicate : duplicates) {
                sj.add(duplicate);
            }
            Assert.fail((String)("The following property names were repeated: " + String.valueOf(sj)));
        }
    }

    @Test
    public void aPrivateCopyShouldAllowTheAdditionOfAspects_CMIS_1_1_Version() throws Exception {
        String aspectName = "P:cm:summarizable";
        String propertyName = "cm:summary";
        String propertyValue = "My summary";
        RepoService.TestNetwork network1 = this.getTestFixture().getRandomNetwork();
        String username = "user" + System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo(username, username, username, TEST_PASSWORD, null, null, null, null, null, null, null);
        RepoService.TestPerson person1 = network1.createUser(personInfo);
        String person1Id = person1.getId();
        final String siteName = "site" + System.currentTimeMillis();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestCMIS.this.repoService.createSite(null, siteInfo);
                String name = GUID.generate();
                NodeRef folderNodeRef = TestCMIS.this.repoService.createFolder(site.getContainerNodeRef(TestCMIS.DOCUMENT_LIBRARY_CONTAINER_NAME), name);
                return folderNodeRef;
            }
        }, (String)person1Id, (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        PublicApiClient.CmisSession cmisSession = this.publicApiClient.createPublicApiCMISSession(CMISDispatcherRegistry.Binding.atom, CMIS_VERSION_11);
        Folder folder = (Folder)cmisSession.getObjectByPath(String.format(DOCUMENT_LIBRARY_PATH_PATTERN, siteName));
        String fileName = String.format(TEST_DOCUMENT_NAME_PATTERN, GUID.generate());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1Id));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cmis:objectTypeId", TYPE_CMIS_DOCUMENT);
        props.put("cmis:name", fileName);
        ContentStreamImpl cs = new ContentStreamImpl(fileName, "text/plain", "This is just a test");
        Document document = folder.createDocument(props, (ContentStream)cs, VersioningState.MAJOR);
        Thread.sleep(3000L);
        ObjectId pwcObjectId = document.checkOut();
        CmisObject cmisObject = cmisSession.getObject(pwcObjectId.getId());
        Document pwc = (Document)cmisObject;
        List aspects = pwc.getProperty("cmis:secondaryObjectTypeIds").getValues();
        Assert.assertTrue((boolean)aspects.contains("P:cm:workingcopy"));
        aspects.add("P:cm:summarizable");
        props = new HashMap();
        props.put("cmis:secondaryObjectTypeIds", aspects);
        props.put("cm:summary", "My summary");
        pwc.updateProperties(props);
        ObjectId id = pwc.checkIn(true, null, null, "CheckIn comment");
        Document checkedInDocument = (Document)cmisSession.getObject(id.getId());
        List secondaryTypeIds = (List)checkedInDocument.getPropertyValue("cmis:secondaryObjectTypeIds");
        Assert.assertTrue((boolean)secondaryTypeIds.contains("P:cm:summarizable"));
        Assert.assertEquals((Object)checkedInDocument.getPropertyValue("cm:summary"), (Object)"My summary");
    }
}

