/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client;

import org.alfresco.rest.api.tests.client.AuthenticationDetailsProvider;
import org.alfresco.rest.api.tests.client.UserData;
import org.alfresco.rest.api.tests.client.UserDataService;

public class UserAuthenticationDetailsProviderImpl
implements AuthenticationDetailsProvider {
    private String adminUserName;
    private String adminPassword;
    private UserDataService userDataService;

    public UserAuthenticationDetailsProviderImpl(UserDataService userDataService, String adminUserName, String adminPassword) {
        this.userDataService = userDataService;
        this.adminUserName = adminUserName;
        this.adminPassword = adminPassword;
    }

    @Override
    public String getPasswordForUser(String userName) {
        UserData user;
        if (userName != null && (user = this.userDataService.findUserByUserName(userName)) != null) {
            return user.getPassword();
        }
        return null;
    }

    @Override
    public String getTicketForUser(String userName) {
        UserData user;
        if (userName != null && (user = this.userDataService.findUserByUserName(userName)) != null) {
            return user.getTicket();
        }
        return null;
    }

    @Override
    public String getAdminUserName() {
        return this.adminUserName;
    }

    @Override
    public String getAdminPassword() {
        return this.adminPassword;
    }

    @Override
    public void updateTicketForUser(String userName, String ticket) throws IllegalArgumentException {
        UserData user = this.userDataService.findUserByUserName(userName);
        if (user != null) {
            user.setTicket(ticket);
        }
    }
}

