/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model.rules;

import java.util.List;
import java.util.Objects;
import org.alfresco.rest.api.model.rules.ConditionOperator;
import org.alfresco.rest.api.model.rules.SimpleCondition;
import org.alfresco.service.Experimental;

@Experimental
public class CompositeCondition {
    private boolean inverted;
    private ConditionOperator booleanMode = ConditionOperator.AND;
    private List<CompositeCondition> compositeConditions;
    private List<SimpleCondition> simpleConditions;

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public String getBooleanMode() {
        if (this.booleanMode == null) {
            return null;
        }
        return this.booleanMode.name().toLowerCase();
    }

    public void setBooleanMode(String booleanMode) {
        if (booleanMode != null) {
            this.booleanMode = ConditionOperator.valueOf(booleanMode.toUpperCase());
        }
    }

    public void setBooleanMode(ConditionOperator booleanMode) {
        this.booleanMode = booleanMode;
    }

    public List<CompositeCondition> getCompositeConditions() {
        return this.compositeConditions;
    }

    public void setCompositeConditions(List<CompositeCondition> compositeConditions) {
        this.compositeConditions = compositeConditions;
    }

    public List<SimpleCondition> getSimpleConditions() {
        return this.simpleConditions;
    }

    public void setSimpleConditions(List<SimpleCondition> simpleConditions) {
        this.simpleConditions = simpleConditions;
    }

    public String toString() {
        return "CompositeCondition{inverted=" + this.inverted + ", booleanMode=" + String.valueOf((Object)this.booleanMode) + ", compositeConditions=" + String.valueOf(this.compositeConditions) + ", simpleConditions=" + String.valueOf(this.simpleConditions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeCondition that = (CompositeCondition)o;
        return this.inverted == that.inverted && this.booleanMode == that.booleanMode && Objects.equals(this.compositeConditions, that.compositeConditions) && Objects.equals(this.simpleConditions, that.simpleConditions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inverted, this.booleanMode, this.compositeConditions, this.simpleConditions});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean inverted;
        private ConditionOperator booleanMode = ConditionOperator.AND;
        private List<CompositeCondition> compositeConditions;
        private List<SimpleCondition> simpleConditions;

        public Builder inverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public Builder booleanMode(ConditionOperator booleanMode) {
            this.booleanMode = booleanMode;
            return this;
        }

        public Builder compositeConditions(List<CompositeCondition> compositeConditions) {
            this.compositeConditions = compositeConditions;
            return this;
        }

        public Builder simpleConditions(List<SimpleCondition> simpleConditions) {
            this.simpleConditions = simpleConditions;
            return this;
        }

        public CompositeCondition create() {
            CompositeCondition condition = new CompositeCondition();
            condition.setInverted(this.inverted);
            condition.setBooleanMode(this.booleanMode);
            condition.setCompositeConditions(this.compositeConditions);
            condition.setSimpleConditions(this.simpleConditions);
            return condition;
        }
    }
}

