/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.dictionary.DictionaryWebServiceBase;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractAssociationsGet
extends DictionaryWebServiceBase {
    private static final String MODEL_PROP_KEY_ASSOCIATION_DETAILS = "assocdefs";
    private static final String MODEL_PROP_KEY_INDIVIDUAL_PROPERTY_DEFS = "individualproperty";
    private static final String REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX = "nsp";
    private static final String REQ_URL_TEMPL_VAR_NAME = "n";
    private static final String REQ_URL_TEMPL_VAR_ASSOCIATION_FILTER = "af";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String associationFilter = req.getParameter(REQ_URL_TEMPL_VAR_ASSOCIATION_FILTER);
        String namespacePrefix = req.getParameter(REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX);
        String name = req.getParameter(REQ_URL_TEMPL_VAR_NAME);
        HashMap<String, Object> model = new HashMap<String, Object>();
        HashMap<QName, AssociationDefinition> assocdef = new HashMap<QName, AssociationDefinition>();
        QName associationQname = null;
        QName classQname = this.getClassQname(req);
        if (associationFilter == null) {
            associationFilter = "all";
        }
        if (!this.isValidAssociationFilter(associationFilter)) {
            throw new WebScriptException(404, "Check the associationFilter - " + associationFilter + " - parameter in the URL");
        }
        if (name == null && namespacePrefix != null || name != null && namespacePrefix == null) {
            throw new WebScriptException(404, "Missing either name or namespaceprefix parameter in the URL - both combination of name and namespaceprefix is needed");
        }
        if (associationFilter.equals("child")) {
            model.put(MODEL_PROP_KEY_ASSOCIATION_DETAILS, this.dictionaryservice.getClass(classQname).getChildAssociations().values());
        } else if (associationFilter.equals("general")) {
            for (AssociationDefinition assocname : this.dictionaryservice.getClass(classQname).getAssociations().values()) {
                if (assocname.isChild()) continue;
                assocdef.put(assocname.getName(), assocname);
            }
            model.put(MODEL_PROP_KEY_ASSOCIATION_DETAILS, assocdef.values());
        } else if (associationFilter.equals("all")) {
            model.put(MODEL_PROP_KEY_ASSOCIATION_DETAILS, this.dictionaryservice.getClass(classQname).getAssociations().values());
        }
        if (name != null && namespacePrefix != null) {
            associationQname = this.getAssociationQname(namespacePrefix, name);
            if (this.dictionaryservice.getClass(classQname).getAssociations().get(associationQname) == null) {
                throw new WebScriptException(404, "not a Valid - namespaceprefix_name combination");
            }
            model.put(MODEL_PROP_KEY_INDIVIDUAL_PROPERTY_DEFS, this.dictionaryservice.getClass(classQname).getAssociations().get(associationQname));
        }
        model.put("messages", this.dictionaryservice);
        return model;
    }

    protected abstract QName getClassQname(WebScriptRequest var1);

    protected abstract QName getAssociationQname(String var1, String var2);
}

