/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Collections;
import java.util.Map;
import org.alfresco.repo.content.ContentRestoreParams;
import org.alfresco.rest.api.ContentStorageInformation;
import org.alfresco.rest.api.model.ArchiveContentRequest;
import org.alfresco.rest.api.model.ContentStorageInfo;
import org.alfresco.rest.api.model.RestoreArchivedContentRequest;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.RestoreInProgressException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class ContentStorageInformationImpl
implements ContentStorageInformation {
    public static final char PREFIX_SEPARATOR = '_';
    private final ContentService contentService;
    private final NamespaceService namespaceService;

    public ContentStorageInformationImpl(ContentService contentService, NamespaceService namespaceService) {
        this.contentService = contentService;
        this.namespaceService = namespaceService;
    }

    @Override
    public ContentStorageInfo getStorageInfo(NodeRef nodeRef, String contentPropName, Parameters parameters) {
        QName propQName = this.getQName(contentPropName);
        Map storageProperties = this.contentService.getStorageProperties(nodeRef, propQName);
        ContentStorageInfo storageInfo = new ContentStorageInfo();
        storageInfo.setId(propQName.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        storageInfo.setStorageProperties(storageProperties);
        return storageInfo;
    }

    @Override
    public boolean requestArchiveContent(NodeRef nodeRef, String contentPropName, ArchiveContentRequest archiveContentRequest) {
        QName propQName = this.getQName(contentPropName);
        Map<Object, Object> archiveParams = archiveContentRequest == null ? Collections.emptyMap() : archiveContentRequest.getArchiveParams();
        return this.contentService.requestSendContentToArchive(nodeRef, propQName, archiveParams);
    }

    @Override
    public boolean requestRestoreContentFromArchive(NodeRef nodeRef, String contentPropName, RestoreArchivedContentRequest restoreArchivedContentRequest) {
        QName propQName = this.getQName(contentPropName);
        Map restoreParams = restoreArchivedContentRequest == null || restoreArchivedContentRequest.getRestorePriority() == null ? Collections.emptyMap() : Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), restoreArchivedContentRequest.getRestorePriority());
        try {
            return this.contentService.requestRestoreContentFromArchive(nodeRef, propQName, restoreParams);
        }
        catch (RestoreInProgressException e) {
            throw new org.alfresco.rest.framework.core.exceptions.RestoreInProgressException(e.getMsgId(), e);
        }
    }

    private QName getQName(String contentPropName) {
        String properContentPropName = contentPropName.replace('_', ':');
        return QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)properContentPropName);
    }
}

