/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.Authorization;
import org.alfresco.repo.web.auth.BasicAuthCredentials;
import org.alfresco.repo.web.auth.TicketCredentials;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter {
    private static Log logger = LogFactory.getLog(AuthenticationFilter.class);
    private static final String PPT_EXTN = ".ppt";
    private static final String[] ENCODINGS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletContext context, ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        try {
            this.doFilterInternal(context, req, resp, chain);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.debug((Object)"About to clear the security context");
            }
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    protected void doFilterInternal(ServletContext context, ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResp;
        HttpServletRequest httpReq;
        SessionUser user;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering AuthenticationFilter.");
        }
        if ((user = this.getSessionUser(context, httpReq = (HttpServletRequest)req, httpResp = (HttpServletResponse)resp, false)) == null) {
            String authHdr;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"There is no user in the session.");
            }
            if ((authHdr = httpReq.getHeader("Authorization")) != null && authHdr.length() > 5 && authHdr.substring(0, 5).equalsIgnoreCase("BASIC")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Basic authentication details present in the header.");
                }
                byte[] encodedString = Base64.decodeBase64((byte[])authHdr.substring(5).getBytes());
                HashSet<String> attemptedAuths = new HashSet<String>(ENCODINGS.length * 2);
                for (String encoding : ENCODINGS) {
                    CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT);
                    try {
                        String basicAuth = decoder.decode(ByteBuffer.wrap(encodedString)).toString();
                        if (!attemptedAuths.add(basicAuth)) continue;
                        String username = null;
                        String password = null;
                        int pos = basicAuth.indexOf(":");
                        if (pos != -1) {
                            username = basicAuth.substring(0, pos);
                            password = basicAuth.substring(pos + 1);
                        } else {
                            username = basicAuth;
                            password = "";
                        }
                        Authorization auth = new Authorization(username, password);
                        if (auth.isTicket()) {
                            this.authenticationService.validate(auth.getTicket());
                        } else {
                            this.authenticationService.authenticate(username, password.toCharArray());
                            if (this.authenticationListener != null) {
                                this.authenticationListener.userAuthenticated(new BasicAuthCredentials(username, password));
                            }
                        }
                        user = this.createUserEnvironment(httpReq.getSession(), this.authenticationService.getCurrentUserName(), this.authenticationService.getCurrentTicket(), false);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Successfully created user environment, login using basic auth or ROLE_TICKET for user: " + AuthenticationUtil.maskUsername((String)user.getUserName())));
                        }
                        break;
                    }
                    catch (CharacterCodingException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Didn't decode using " + decoder.getClass().getName()), (Throwable)e);
                    }
                    catch (AuthenticationException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"Authentication error ", (Throwable)ex);
                    }
                    catch (NoSuchPersonException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"There is no such person error ", (Throwable)e);
                    }
                }
            } else {
                String ticket = req.getParameter("ticket");
                if (ticket != null && ticket.length() > 0) {
                    if (ticket.endsWith(PPT_EXTN)) {
                        ticket = ticket.substring(0, ticket.length() - PPT_EXTN.length());
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Logon via ticket from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ") ticket=" + ticket));
                    }
                    this.authenticationService.validate(ticket);
                    if (this.authenticationListener != null) {
                        this.authenticationListener.userAuthenticated(new TicketCredentials(ticket));
                    }
                    String currentUsername = this.authenticationService.getCurrentUserName();
                    user = this.createUserEnvironment(httpReq.getSession(), currentUsername, ticket, false);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Successfully created user environment, login using TICKET for user: " + AuthenticationUtil.maskUsername((String)user.getUserName())));
                    }
                }
            }
            if (user == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No user/ticket, force the client to prompt for logon details.");
                }
                httpResp.setHeader("WWW-Authenticate", "BASIC realm=\"Alfresco DAV Server\"");
                httpResp.setStatus(401);
                httpResp.flushBuffer();
                return;
            }
        } else {
            if (this.authenticationListener != null) {
                this.authenticationListener.userAuthenticated(new TicketCredentials(user.getTicket()));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("User already set to: " + AuthenticationUtil.maskUsername((String)user.getUserName())));
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    static {
        String[] encodings = new String[]{"UTF-8", System.getProperty("file.encoding"), "ISO-8859-1"};
        LinkedHashSet<String> encodingsSet = new LinkedHashSet<String>();
        for (String encoding : encodings) {
            encodingsSet.add(encoding);
        }
        ENCODINGS = new String[encodingsSet.size()];
        encodingsSet.toArray(ENCODINGS);
    }
}

