/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.Company;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.service.cmr.repository.NodeRef;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Person
extends org.alfresco.rest.api.model.Person
implements Serializable,
Comparable<Person>,
ExpectedComparison {
    private static final long serialVersionUID = 3185698391792389751L;
    private String id;
    private static Collator collator = Collator.getInstance();
    private static ThreadLocal<UserContext> userContext = new ThreadLocal();

    public Person() {
    }

    public Person(String id, String username, Boolean enabled, String firstName, String lastName, Company company, String skype, String location, String tel, String mob, String instantmsg, String google, String description) {
        super(username, enabled, null, firstName, lastName, null, location, tel, mob, null, skype, instantmsg, null, null, google, null, null, null, description, (org.alfresco.rest.api.model.Company)company);
        this.id = id;
    }

    public Person(String userName, Boolean enabled, NodeRef avatarId, String firstName, String lastName, String jobTitle, String location, String telephone, String mobile, String email, String skypeId, String instantMessageId, String userStatus, Date statusUpdatedAt, String googleId, Long quota, Long quotaUsed, Boolean emailNotificationsEnabled, String description, org.alfresco.rest.api.model.Company company, Map<String, Object> properties, List<String> aspectNames, Map<String, Boolean> capabilities) {
        super(userName, enabled, avatarId, firstName, lastName, jobTitle, location, telephone, mobile, email, skypeId, instantMessageId, userStatus, statusUpdatedAt, googleId, quota, quotaUsed, emailNotificationsEnabled, description, company);
        this.id = userName;
        this.properties = properties;
        this.aspectNames = aspectNames;
        this.capabilities = capabilities;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "Person [" + (String)(this.id != null ? "id=" + this.id + ", " : "") + (String)(this.enabled != null ? "enabled=" + this.enabled + ", " : "") + (String)(this.firstName != null ? "firstName=" + this.firstName + ", " : "") + (String)(this.lastName != null ? "lastName=" + this.lastName + ", " : "") + (this.company != null ? "company=" + String.valueOf(this.company) + ", " : "company=" + new Company().toString() + ", ") + (String)(this.skypeId != null ? "skype=" + this.skypeId + ", " : "") + (String)(this.location != null ? "location=" + this.location + ", " : "") + (String)(this.telephone != null ? "tel=" + this.telephone + ", " : "") + (String)(this.mobile != null ? "mob=" + this.mobile + ", " : "") + (String)(this.instantMessageId != null ? "instantmsg=" + this.instantMessageId + ", " : "") + (String)(this.googleId != null ? "google=" + this.googleId + ", " : "") + (String)(this.description != null ? "description=" + this.description + ", " : "") + "]";
    }

    public JSONObject toJSON(boolean fullVisibility) {
        JSONObject personJson = new JSONObject();
        if (this.getUserName() != null) {
            personJson.put((Object)"id", (Object)this.getUserName());
        }
        personJson.put((Object)"firstName", (Object)this.getFirstName());
        personJson.put((Object)"lastName", (Object)this.getLastName());
        if (fullVisibility) {
            personJson.put((Object)"description", (Object)this.getDescription());
            personJson.put((Object)"email", (Object)this.getEmail());
            personJson.put((Object)"skypeId", (Object)this.getSkypeId());
            personJson.put((Object)"googleId", (Object)this.getGoogleId());
            personJson.put((Object)"instantMessageId", (Object)this.getInstantMessageId());
            personJson.put((Object)"jobTitle", (Object)this.getJobTitle());
            personJson.put((Object)"location", (Object)this.getLocation());
            if (this.company != null) {
                personJson.put((Object)"company", (Object)new Company(this.company).toJSON());
            }
            personJson.put((Object)"mobile", (Object)this.getMobile());
            personJson.put((Object)"telephone", (Object)this.getTelephone());
            personJson.put((Object)"userStatus", (Object)this.getUserStatus());
            personJson.put((Object)"enabled", (Object)this.isEnabled());
            personJson.put((Object)"emailNotificationsEnabled", (Object)this.isEmailNotificationsEnabled());
            personJson.put((Object)"properties", (Object)this.getProperties());
            personJson.put((Object)"aspectNames", (Object)this.getAspectNames());
            personJson.put((Object)"capabilities", (Object)this.getCapabilities());
        }
        return personJson;
    }

    public static Person parsePerson(JSONObject jsonObject) {
        String userId = (String)jsonObject.get((Object)"id");
        String firstName = (String)jsonObject.get((Object)"firstName");
        String lastName = (String)jsonObject.get((Object)"lastName");
        String description = (String)jsonObject.get((Object)"description");
        String email = (String)jsonObject.get((Object)"email");
        String skypeId = (String)jsonObject.get((Object)"skypeId");
        String googleId = (String)jsonObject.get((Object)"googleId");
        String instantMessageId = (String)jsonObject.get((Object)"instantMessageId");
        String jobTitle = (String)jsonObject.get((Object)"jobTitle");
        String location = (String)jsonObject.get((Object)"location");
        Company company = null;
        JSONObject companyJSON = (JSONObject)jsonObject.get((Object)"company");
        if (companyJSON != null) {
            String organization = (String)companyJSON.get((Object)"organization");
            String address1 = (String)companyJSON.get((Object)"address1");
            String address2 = (String)companyJSON.get((Object)"address2");
            String address3 = (String)companyJSON.get((Object)"address3");
            String postcode = (String)companyJSON.get((Object)"postcode");
            String companyTelephone = (String)companyJSON.get((Object)"telephone");
            String fax = (String)companyJSON.get((Object)"fax");
            String companyEmail = (String)companyJSON.get((Object)"email");
            company = organization != null || address2 != null || address3 != null || postcode != null || companyTelephone != null || fax != null || companyEmail != null ? new Company(organization, address1, address2, address3, postcode, companyTelephone, fax, companyEmail) : new Company();
        }
        String mobile = (String)jsonObject.get((Object)"mobile");
        String telephone = (String)jsonObject.get((Object)"telephone");
        String userStatus = (String)jsonObject.get((Object)"userStatus");
        Boolean enabled = (Boolean)jsonObject.get((Object)"enabled");
        Boolean emailNotificationsEnabled = (Boolean)jsonObject.get((Object)"emailNotificationsEnabled");
        List aspectNames = (List)jsonObject.get((Object)"aspectNames");
        Map properties = (Map)jsonObject.get((Object)"properties");
        Map capabilities = (Map)jsonObject.get((Object)"capabilities");
        Person person = new Person(userId, enabled, null, firstName, lastName, jobTitle, location, telephone, mobile, email, skypeId, instantMessageId, userStatus, null, googleId, null, null, emailNotificationsEnabled, description, company, properties, aspectNames, capabilities);
        return person;
    }

    public static void setUserContext(String personId) {
        String networkId = Person.getNetworkId(personId);
        userContext.set(new UserContext(networkId, personId));
    }

    public static void clearUserContext() {
        userContext.set(null);
    }

    public static UserContext gettUserContext() {
        return userContext.get();
    }

    public static String getNetworkId(String personId) {
        int idx = personId.indexOf("@");
        return idx == -1 ? "" : personId.substring(idx + 1);
    }

    private String getNetworkId() {
        return Person.getNetworkId(this.id);
    }

    public boolean isVisible() {
        boolean ret = true;
        UserContext uc = Person.gettUserContext();
        String networkId = this.getNetworkId();
        if (uc != null && !networkId.equals(uc.getNetworkId())) {
            ret = false;
        }
        return ret;
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((String)("o is an instance of " + String.valueOf(o.getClass())), (boolean)(o instanceof Person));
        Person other = (Person)o;
        AssertUtil.assertEquals("userId", this.getId(), other.getId());
        AssertUtil.assertEquals("firstName", this.firstName, other.getFirstName());
        AssertUtil.assertEquals("lastName", this.lastName, other.getLastName());
        AssertUtil.assertEquals("enabled", this.enabled, other.isEnabled());
        if (this.isVisible()) {
            AssertUtil.assertEquals("skype", this.getSkypeId(), other.getSkypeId());
            AssertUtil.assertEquals("location", this.getLocation(), other.getLocation());
            AssertUtil.assertEquals("tel", this.getTelephone(), other.getTelephone());
            AssertUtil.assertEquals("mobile", this.getMobile(), other.getMobile());
            AssertUtil.assertEquals("instanceMessageId", this.getInstantMessageId(), other.getInstantMessageId());
            AssertUtil.assertEquals("googleId", this.getGoogleId(), other.getGoogleId());
            if (this.company != null) {
                new Company(this.company).expected(this.getCompany());
            }
        }
    }

    @Override
    public int compareTo(Person o) {
        int ret = collator.compare(this.lastName, o.getLastName());
        if (ret == 0) {
            ret = collator.compare(this.firstName, o.getFirstName());
        }
        return ret;
    }

    public static PublicApiClient.ListResponse<Person> parsePeople(JSONObject jsonObject) {
        ArrayList<Person> people = new ArrayList<Person>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            people.add(Person.parsePerson(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<Person> resp = new PublicApiClient.ListResponse<Person>(paging, people);
        return resp;
    }

    private static class UserContext {
        private String networkId;
        private String personId;

        UserContext(String networkId, String personId) {
            this.networkId = networkId;
            this.personId = personId;
        }

        String getNetworkId() {
            return this.networkId;
        }

        String getPersonId() {
            return this.personId;
        }
    }
}

