/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.replication;

import java.io.IOException;
import java.util.Map;
import org.alfresco.repo.web.scripts.replication.AbstractReplicationWebscript;
import org.alfresco.repo.web.scripts.replication.ReplicationModelBuilder;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ReplicationDefinitionPut
extends AbstractReplicationWebscript {
    @Override
    protected Map<String, Object> buildModel(ReplicationModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        String replicationDefinitionName = (String)req.getServiceMatch().getTemplateVars().get("replication_definition_name");
        ReplicationDefinition replicationDefinition = this.replicationService.loadReplicationDefinition(replicationDefinitionName);
        if (replicationDefinition == null) {
            throw new WebScriptException(404, "No Replication Definition found with that name");
        }
        try {
            String jsonName;
            JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            if (json.has("name") && !(jsonName = json.getString("name")).equals(replicationDefinitionName)) {
                if (this.replicationService.loadReplicationDefinition(jsonName) != null) {
                    throw new WebScriptException(400, "The specified new name is already in use");
                }
                this.replicationService.renameReplicationDefinition(replicationDefinitionName, jsonName);
                replicationDefinition = this.replicationService.loadReplicationDefinition(jsonName);
            }
            this.updateDefinitionProperties(replicationDefinition, json);
            this.replicationService.saveReplicationDefinition(replicationDefinition);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from request.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from request.", (Throwable)je);
        }
        return modelBuilder.buildDetails(replicationDefinition);
    }
}

