/*
 * #%L
 * Alfresco Remote API
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.api.nodes;

import org.springframework.beans.factory.InitializingBean;

import org.alfresco.rest.api.Audit;
import org.alfresco.rest.api.model.AuditEntry;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;

/**
 * Node AuditEntries
 * 
 * -list audit-entries
 * 
 * @author anechifor
 *
 */
@RelationshipResource(name = "audit-entries", entityResource = NodesEntityResource.class, title = "Audit Entries")
public class NodeAuditEntriesRelation implements RelationshipResourceAction.Read<AuditEntry>, InitializingBean
{

    private Audit audit;

    public void setAudit(Audit audit)
    {
        this.audit = audit;
    }

    @Override
    public void afterPropertiesSet() throws Exception
    {
        ParameterCheck.mandatory("audit", this.audit);

    }

    @WebApiDescription(title = "Returns audit entries for node id")
    @Override
    public CollectionWithPagingInfo<AuditEntry> readAll(String nodeId, Parameters parameters)
    {
        return audit.listAuditEntriesByNodeId(nodeId, parameters);
    }

}
