/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class SiteImpl
implements Serializable,
Site,
Comparable<SiteImpl>,
ExpectedComparison {
    private static final long serialVersionUID = -3774392026234649419L;
    public static final String FIELD_SITE_ID = "siteId";
    public static final String FIELD_CREATED = "created";
    public static final String FIELD_HAS_MEMBERS = "hasMembers";
    protected Boolean created = false;
    protected String networkId;
    protected String siteId;
    protected String guid;
    protected String title;
    protected String description;
    protected SiteRole role;
    protected String visibility;
    protected String preset;
    protected String type;

    public SiteImpl() {
    }

    public SiteImpl(String title, String visibility) {
        if (title == null) {
            throw new IllegalArgumentException();
        }
        if (visibility == null) {
            throw new IllegalArgumentException();
        }
        this.title = title;
        this.visibility = visibility;
    }

    public SiteImpl(String networkId, String siteId, String guid) {
        if (siteId == null) {
            throw new IllegalArgumentException();
        }
        if (guid == null) {
            throw new IllegalArgumentException();
        }
        this.networkId = networkId;
        this.siteId = siteId;
        this.guid = guid;
    }

    public SiteImpl(SiteInfo siteInfo, SiteRole siteRole, Boolean created) {
        this.siteId = siteInfo.getShortName();
        this.description = siteInfo.getDescription();
        this.title = siteInfo.getTitle();
        this.visibility = siteInfo.getVisibility().toString();
        this.created = created;
        this.guid = siteInfo.getNodeRef().getId();
    }

    public SiteImpl(String siteId, String title, String description, String visibility) {
        this.siteId = siteId;
        this.title = title;
        this.description = description;
        this.visibility = visibility;
    }

    public SiteImpl(String networkId, String siteId, String guid, String title, String description, String visibility, String type, SiteRole siteRole) {
        this.networkId = networkId;
        this.siteId = siteId;
        this.title = title;
        this.description = description;
        this.visibility = visibility;
        this.type = type;
        this.role = siteRole;
        this.guid = guid;
    }

    @Override
    public Site withCreated(Boolean created) {
        this.setCreated(created);
        return this;
    }

    @Override
    public SiteImpl withNetworkId(String networkId) {
        this.setNetworkId(networkId);
        return this;
    }

    @Override
    public SiteImpl withSiteId(String siteId) {
        this.setSiteId(siteId);
        return this;
    }

    @Override
    public SiteImpl withGuid(String guid) {
        this.setGuid(guid);
        return this;
    }

    @Override
    public SiteImpl withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    @Override
    public SiteImpl withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public SiteImpl withRole(SiteRole role) {
        this.setRole(role);
        return this;
    }

    @Override
    public SiteImpl withVisibility(String visibility) {
        this.setVisibility(visibility);
        return this;
    }

    @Override
    public SiteImpl withPreset(String preset) {
        this.setPreset(preset);
        return this;
    }

    @Override
    public SiteImpl withType(String type) {
        this.setType(type);
        return this;
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof SiteImpl));
        SiteImpl site = (SiteImpl)o;
        AssertUtil.assertEquals(FIELD_SITE_ID, this.getSiteId(), site.getSiteId());
        AssertUtil.assertEquals("guid", this.getGuid(), site.getGuid());
        AssertUtil.assertEquals("title", this.getTitle(), site.getTitle());
        AssertUtil.assertEquals("description", this.getDescription(), site.getDescription());
        AssertUtil.assertEquals("visibility", this.getVisibility(), site.getVisibility());
        AssertUtil.assertEquals("role", (Object)this.getRole(), (Object)site.getRole());
    }

    @Override
    public Boolean getCreated() {
        return this.created;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public String getNetworkId() {
        return this.networkId;
    }

    @Override
    public Boolean isCreated() {
        return this.created;
    }

    public void setCreated(Boolean created) {
        this.created = created;
    }

    @Override
    public String getSiteId() {
        return this.siteId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVisibility() {
        return this.visibility;
    }

    @Override
    public String getPreset() {
        return this.preset;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static Site parseSite(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String id = (String)jsonObject.get((Object)"id");
        String guid = (String)jsonObject.get((Object)"guid");
        String title = (String)jsonObject.get((Object)"title");
        String description = (String)jsonObject.get((Object)"description");
        String visibility = (String)jsonObject.get((Object)"visibility");
        String roleStr = (String)jsonObject.get((Object)"role");
        SiteRole role = null;
        if (roleStr != null) {
            role = SiteRole.valueOf(roleStr);
        }
        SiteImpl site = new SiteImpl(null, id, guid, title, description, visibility, "st:site", role);
        return site;
    }

    public static PublicApiClient.ListResponse<Site> parseSites(JSONObject jsonObject) {
        ArrayList<Site> sites = new ArrayList<Site>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            sites.add(SiteImpl.parseSite(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<Site> resp = new PublicApiClient.ListResponse<Site>(paging, sites);
        return resp;
    }

    @Override
    public SiteRole getRole() {
        return this.role;
    }

    public void setRole(SiteRole role) {
        this.role = role;
    }

    public String toString() {
        return "Site [created=" + this.created + ", networkId=" + this.networkId + ", siteId=" + this.siteId + ", guid=" + this.guid + ", title=" + this.title + ", description=" + this.description + ", role=" + String.valueOf((Object)this.role) + ", visibility=" + this.visibility + ", type=" + this.type + "]";
    }

    @Override
    public JSONObject toJSON() {
        JSONObject siteJson = new JSONObject();
        if (this.getSiteId() != null) {
            siteJson.put((Object)"id", (Object)this.getSiteId());
        }
        if (this.getGuid() != null) {
            siteJson.put((Object)"guid", (Object)this.getGuid());
        }
        if (this.getTitle() != null) {
            siteJson.put((Object)"title", (Object)this.getTitle());
        }
        if (this.getDescription() != null) {
            siteJson.put((Object)"description", (Object)this.getDescription());
        }
        if (this.getVisibility() != null) {
            siteJson.put((Object)"visibility", (Object)this.getVisibility());
        }
        if (this.getPreset() != null) {
            siteJson.put((Object)"preset", (Object)this.getPreset());
        }
        return siteJson;
    }

    @Override
    public int compareTo(SiteImpl site) {
        return this.siteId.compareTo(site.getSiteId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.networkId == null ? 0 : this.networkId.hashCode());
        result = 31 * result + (this.siteId == null ? 0 : this.siteId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteImpl other = (SiteImpl)obj;
        if (this.networkId == null ? other.networkId != null : !this.networkId.equals(other.networkId)) {
            return false;
        }
        return !(this.siteId == null ? other.siteId != null : !this.siteId.equals(other.siteId));
    }
}

