/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util.paging;

import java.io.Serializable;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.repo.web.util.paging.Paging;

public class PagedCursor
implements Cursor,
Serializable {
    private static final long serialVersionUID = -1041155610387669590L;
    private boolean zeroBasedPage;
    private boolean zeroBasedRow;
    private int totalRows;
    private int pageSize;
    private int rowsPerPage;
    private int page;

    PagedCursor(boolean zeroBasedRow, int totalRows, boolean zeroBasedPage, int page, int pageSize) {
        this.zeroBasedRow = zeroBasedRow;
        this.totalRows = totalRows;
        this.zeroBasedPage = zeroBasedPage;
        this.page = zeroBasedPage ? page : page - 1;
        this.pageSize = pageSize;
        this.rowsPerPage = pageSize <= 0 ? totalRows : pageSize;
    }

    @Override
    public String getPageType() {
        return Paging.PageType.PAGE.toString();
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getTotalPages() {
        if (this.totalRows <= 0) {
            return 0;
        }
        int totalPages = this.totalRows / this.rowsPerPage;
        return totalPages += this.totalRows % this.rowsPerPage != 0 ? 1 : 0;
    }

    @Override
    public int getTotalRows() {
        return this.totalRows;
    }

    @Override
    public int getCurrentPage() {
        return this.page + (this.zeroBasedPage ? 0 : 1);
    }

    @Override
    public int getFirstPage() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.zeroBasedPage ? 0 : 1;
    }

    @Override
    public int getLastPage() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.getTotalPages() - (this.zeroBasedPage ? 1 : 0);
    }

    @Override
    public int getNextPage() {
        return this.getCurrentPage() < this.getLastPage() ? this.getCurrentPage() + 1 : -1;
    }

    @Override
    public int getPrevPage() {
        return this.page > 0 ? this.getCurrentPage() - 1 : -1;
    }

    @Override
    public boolean isInRange() {
        return this.page >= 0 && this.getCurrentPage() <= this.getLastPage();
    }

    @Override
    public boolean getHasFirstPage() {
        return this.getFirstPage() != -1;
    }

    @Override
    public boolean getHasLastPage() {
        return this.getLastPage() != -1;
    }

    @Override
    public boolean getHasNextPage() {
        return this.getNextPage() != -1;
    }

    @Override
    public boolean getHasPrevPage() {
        return this.getPrevPage() != -1;
    }

    @Override
    public int getStartRow() {
        if (this.totalRows <= 0) {
            return 0;
        }
        return this.page * this.rowsPerPage + (this.zeroBasedRow ? 0 : 1);
    }

    @Override
    public int getEndRow() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.getStartRow() + Math.min(this.rowsPerPage, this.totalRows - this.page * this.rowsPerPage) - 1;
    }

    @Override
    public int getRowCount() {
        if (this.totalRows <= 0) {
            return 0;
        }
        return this.getEndRow() - this.getStartRow() + 1;
    }
}

