/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.alfresco.rest.api.NodeRatings;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.node.ratings.RatingScheme;
import org.alfresco.rest.api.model.NodeRating;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.TypeConstraint;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeRatingsImpl
implements NodeRatings {
    private static Log logger = LogFactory.getLog(NodeRatingsImpl.class);
    private Nodes nodes;
    private RatingService ratingService;
    private NamedObjectRegistry<RatingScheme> nodeRatingSchemeRegistry;
    private TypeConstraint typeConstraint;

    public void setTypeConstraint(TypeConstraint typeConstraint) {
        this.typeConstraint = typeConstraint;
    }

    public void setRatingService(RatingService ratingService) {
        this.ratingService = ratingService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setNodeRatingSchemeRegistry(NamedObjectRegistry<RatingScheme> nodeRatingSchemeRegistry) {
        this.nodeRatingSchemeRegistry = nodeRatingSchemeRegistry;
    }

    @Override
    public RatingScheme validateRatingScheme(String ratingSchemeId) {
        RatingScheme ratingScheme = (RatingScheme)this.nodeRatingSchemeRegistry.getNamedObject(ratingSchemeId);
        if (ratingScheme == null) {
            throw new InvalidArgumentException("Invalid ratingSchemeId " + ratingSchemeId);
        }
        return ratingScheme;
    }

    @Override
    public NodeRating getNodeRating(String nodeId, String ratingSchemeId) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        RatingScheme ratingScheme = this.validateRatingScheme(ratingSchemeId);
        return ratingScheme.getNodeRating(nodeRef);
    }

    @Override
    public CollectionWithPagingInfo<NodeRating> getNodeRatings(String nodeId, Paging paging) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        TreeSet schemes = new TreeSet(this.ratingService.getRatingSchemes().keySet());
        Iterator it = schemes.iterator();
        int skipCount = paging.getSkipCount();
        int maxItems = paging.getMaxItems();
        int totalSize = schemes.size();
        int count = 0;
        int end = skipCount + maxItems;
        if (end < 0) {
            end = Integer.MAX_VALUE;
        }
        ArrayList<NodeRating> ratings = new ArrayList<NodeRating>(totalSize);
        for (int i = 0; i < end && it.hasNext(); ++i) {
            String schemeName = (String)it.next();
            if (i < skipCount) continue;
            ++count;
            RatingScheme ratingScheme = this.validateRatingScheme(schemeName);
            NodeRating nodeRating = ratingScheme.getNodeRating(nodeRef);
            ratings.add(nodeRating);
        }
        boolean hasMoreItems = skipCount + count < totalSize;
        return CollectionWithPagingInfo.asPaged(paging, ratings, hasMoreItems, totalSize);
    }

    @Override
    public void addRating(String nodeId, String ratingSchemeId, Object rating) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        RatingScheme ratingScheme = this.validateRatingScheme(ratingSchemeId);
        if (!this.typeConstraint.matches(nodeRef)) {
            throw new UnsupportedResourceOperationException("Cannot rate this node");
        }
        ratingScheme.applyRating(nodeRef, rating);
    }

    @Override
    public void removeRating(String nodeId, String ratingSchemeId) {
        RatingScheme ratingScheme = this.validateRatingScheme(ratingSchemeId);
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        ratingScheme.removeRating(nodeRef);
    }
}

