/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.Iterator;
import java.util.Map;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.junit.Assert;
import org.junit.Test;

public class TestPublicApiCaching
extends EnterpriseTestApi {
    @Test
    public void testMNT13938() throws Exception {
        Iterator<RepoService.TestNetwork> accountsIt = this.getTestFixture().getNetworksIt();
        RepoService.TestNetwork account1 = accountsIt.next();
        Iterator<String> personIt1 = account1.getPersonIds().iterator();
        String person1 = personIt1.next();
        this.publicApiClient.setRequestContext(new RequestContext(account1.getId(), person1));
        HttpResponse response = this.publicApiClient.get("public", "people", person1, null, null, null);
        int responseCode = response.getStatusCode();
        Assert.assertTrue((String)"Response code should be 200", (responseCode == 200 ? 1 : 0) != 0);
        Map<String, String> headers = response.getHeaders();
        Assert.assertNotNull((String)"HTTP headers should be present on response", headers);
        String cacheControlHeader = headers.get("Cache-Control");
        Assert.assertNotNull((String)"Cache-Control header should be present", (Object)cacheControlHeader);
        Assert.assertTrue((String)("Cache-Control header should be set to no-cache but it was: " + cacheControlHeader), (boolean)cacheControlHeader.equals("no-cache"));
        String pragmaHeader = headers.get("Pragma");
        Assert.assertNotNull((String)"Pragma header should be present", (Object)pragmaHeader);
        Assert.assertTrue((String)("Pragma header should be set to no-cache but it was: " + pragmaHeader), (boolean)pragmaHeader.equals("no-cache"));
        String expiresHeader = headers.get("Expires");
        Assert.assertNotNull((String)"Expires header should be present", (Object)expiresHeader);
    }
}

