/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.archive.AbstractArchivedNodeWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ArchivedNodePut
extends AbstractArchivedNodeWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String userID = AuthenticationUtil.getFullyAuthenticatedUser();
        if (userID == null) {
            throw new WebScriptException(401, "Web Script [" + String.valueOf(req.getServiceMatch().getWebScript().getDescription()) + "] requires user authentication.");
        }
        NodeRef nodeRefToBeRestored = this.parseRequestForNodeRef(req);
        if (nodeRefToBeRestored == null) {
            throw new WebScriptException(400, "nodeRef not recognised. Could not restore.");
        }
        this.validatePermission(nodeRefToBeRestored, userID);
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(nodeRefToBeRestored);
        if (report.getStatus().equals((Object)RestoreNodeReport.RestoreStatus.FAILURE_INVALID_ARCHIVE_NODE)) {
            throw new WebScriptException(404, "Unable to find archive node: " + String.valueOf(nodeRefToBeRestored));
        }
        if (report.getStatus().equals((Object)RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION)) {
            throw new WebScriptException(403, "Unable to restore archive node: " + String.valueOf(nodeRefToBeRestored));
        }
        if (report.getStatus().equals((Object)RestoreNodeReport.RestoreStatus.FAILURE_DUPLICATE_CHILD_NODE_NAME)) {
            throw new WebScriptException(409, "Unable to restore archive node: " + String.valueOf(nodeRefToBeRestored) + ". Duplicate child node name");
        }
        if (report.getStatus().equals((Object)RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT) || report.getStatus().equals((Object)RestoreNodeReport.RestoreStatus.FAILURE_INTEGRITY) || report.getStatus().equals((Object)RestoreNodeReport.RestoreStatus.FAILURE_OTHER)) {
            throw new WebScriptException(500, "Unable to restore archive node: " + String.valueOf(nodeRefToBeRestored));
        }
        model.put("restoreNodeReport", report);
        return model;
    }
}

