/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.audit;

import java.util.Map;
import org.alfresco.service.cmr.audit.AuditService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractAuditWebScript
extends DeclarativeWebScript {
    public static final String PARAM_APPLICATION = "application";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_ENABLE = "enable";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_VALUE_TYPE = "valueType";
    public static final String PARAM_FROM_TIME = "fromTime";
    public static final String PARAM_TO_TIME = "toTime";
    public static final String PARAM_FROM_ID = "fromId";
    public static final String PARAM_TO_ID = "toId";
    public static final String PARAM_USER = "user";
    public static final String PARAM_FORWARD = "forward";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_VERBOSE = "verbose";
    public static final Long DEFAULT_FROM_TIME = null;
    public static final Long DEFAULT_TO_TIME = null;
    public static final Long DEFAULT_FROM_ID = null;
    public static final Long DEFAULT_TO_ID = null;
    public static final String DEFAULT_USER = null;
    public static final boolean DEFAULT_FORWARD = true;
    public static final int DEFAULT_LIMIT = 100;
    public static final boolean DEFAULT_VERBOSE = false;
    public static final boolean DEFAULT_ENABLE = false;
    public static final String JSON_KEY_ENABLED = "enabled";
    public static final String JSON_KEY_APPLICATIONS = "applications";
    public static final String JSON_KEY_NAME = "name";
    public static final String JSON_KEY_PATH = "path";
    public static final String JSON_KEY_CLEARED = "cleared";
    public static final String JSON_KEY_DELETED = "deleted";
    public static final String JSON_KEY_ENTRY_COUNT = "count";
    public static final String JSON_KEY_ENTRIES = "entries";
    public static final String JSON_KEY_ENTRY_ID = "id";
    public static final String JSON_KEY_ENTRY_APPLICATION = "application";
    public static final String JSON_KEY_ENTRY_USER = "user";
    public static final String JSON_KEY_ENTRY_TIME = "time";
    public static final String JSON_KEY_ENTRY_VALUES = "values";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected AuditService auditService;

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    protected String getI18NMessage(String key, Object ... args) {
        return I18NUtil.getMessage((String)key, (Object[])args);
    }

    protected final String getParamAppName(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String app = (String)templateVars.get("application");
        if (app == null || app.length() == 0) {
            return null;
        }
        return app;
    }

    protected Long getId(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String id = (String)templateVars.get(JSON_KEY_ENTRY_ID);
        if (id == null || id.length() == 0) {
            return null;
        }
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected String getParamPath(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        Object paramPath = (String)templateVars.get("path");
        if (paramPath == null || ((String)paramPath).length() == 0) {
            paramPath = null;
        } else if (!((String)paramPath).startsWith("/")) {
            paramPath = "/" + (String)paramPath;
        }
        return paramPath;
    }

    protected boolean getParamEnableDisable(WebScriptRequest req) {
        return this.getBooleanParam(req.getParameter(PARAM_ENABLE), false);
    }

    protected String getParamValue(WebScriptRequest req) {
        return req.getParameter(PARAM_VALUE);
    }

    protected String getParamValueType(WebScriptRequest req) {
        return req.getParameter(PARAM_VALUE_TYPE);
    }

    protected Long getParamFromTime(WebScriptRequest req) {
        return this.getLongParam(req.getParameter(PARAM_FROM_TIME), DEFAULT_FROM_TIME);
    }

    protected Long getParamToTime(WebScriptRequest req) {
        return this.getLongParam(req.getParameter(PARAM_TO_TIME), DEFAULT_TO_TIME);
    }

    protected Long getParamFromId(WebScriptRequest req) {
        return this.getLongParam(req.getParameter(PARAM_FROM_ID), DEFAULT_FROM_ID);
    }

    protected Long getParamToId(WebScriptRequest req) {
        return this.getLongParam(req.getParameter(PARAM_TO_ID), DEFAULT_TO_ID);
    }

    protected String getParamUser(WebScriptRequest req) {
        return req.getParameter("user");
    }

    protected boolean getParamForward(WebScriptRequest req) {
        return this.getBooleanParam(req.getParameter(PARAM_FORWARD), true);
    }

    protected int getParamLimit(WebScriptRequest req) {
        return this.getIntParam(req.getParameter(PARAM_LIMIT), 100);
    }

    protected boolean getParamVerbose(WebScriptRequest req) {
        return this.getBooleanParam(req.getParameter(PARAM_VERBOSE), false);
    }

    private Long getLongParam(String paramStr, Long defaultVal) {
        if (paramStr == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(paramStr);
        }
        catch (NumberFormatException e) {
            throw new WebScriptException(400, e.getMessage());
        }
    }

    private boolean getBooleanParam(String paramStr, boolean defaultVal) {
        if (paramStr == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(paramStr);
    }

    private int getIntParam(String paramStr, int defaultVal) {
        if (paramStr == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(paramStr);
        }
        catch (NumberFormatException e) {
            throw new WebScriptException(400, e.getMessage());
        }
    }
}

