/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.repo.webdav.auth.BaseKerberosAuthenticationFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KerberosAuthenticationFilter
extends BaseKerberosAuthenticationFilter {
    private static Log logger = LogFactory.getLog(KerberosAuthenticationFilter.class);

    @Override
    protected void init() throws ServletException {
        super.init();
        this.setUserAttributeName("_alfAuthTicket");
    }

    @Override
    protected void onValidateFailed(ServletContext sc, HttpServletRequest req, HttpServletResponse res, HttpSession session, WebCredentials credentials) throws IOException {
        super.onValidateFailed(sc, req, res, session, credentials);
        this.redirectToLoginPage(req, res);
    }

    @Override
    protected void writeLoginPageLink(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html; charset=UTF-8");
        resp.setStatus(401);
        try (PrintWriter out = resp.getWriter();){
            out.println("<html><head>");
            out.println("</head><body><p>Login failed. Please try again.</p>");
            out.println("</body></html>");
        }
    }

    @Override
    protected final Log getLogger() {
        return logger;
    }
}

