/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LuceneTests.class})
public class WherePredicateApiTest
extends AbstractSingleNetworkSiteTest {
    private static final boolean NOT = true;
    private String folder0Id;
    private String file0Id;
    private PublicApiClient.Paging paging;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String folder0Name = "folder " + this.RUNID;
        this.folder0Id = this.createFolder(myNodeId, folder0Name, null).getId();
        String file0Name = "file " + this.RUNID;
        this.file0Id = this.createEmptyTextFile(this.folder0Id, file0Name).getId();
        this.paging = this.getPaging(0, 100);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testLogicalOperatorsGetChildren() throws Exception {
        String childrenUrl = this.getNodeChildrenUrl(this.folder0Id);
        String clause = new WhereClauseBuilder().predicate("isFolder=true").build();
        this.getAll(childrenUrl, this.paging, this.getWhereClause(clause), 200);
        clause = new WhereClauseBuilder().predicate("isFolder=true").and("isFile=false").build();
        this.getAll(childrenUrl, this.paging, this.getWhereClause(clause), 200);
        clause = new WhereClauseBuilder().predicate("isFolder=true", true).build();
        this.getAll(childrenUrl, this.paging, this.getWhereClause(clause), 400);
        clause = new WhereClauseBuilder().predicate("isFolder=true").or("isFile=false").build();
        this.getAll(childrenUrl, this.paging, this.getWhereClause(clause), 400);
        clause = new WhereClauseBuilder().predicate("isFolder=true", true).and("isFile=false").build();
        this.getAll(childrenUrl, this.paging, this.getWhereClause(clause), 400);
    }

    @Test
    public void testLogicalOperatorsGetSecondaryChildren() throws Exception {
        String clause = new WhereClauseBuilder().predicate("assocType=cm:contains").build();
        this.getAll(this.getNodeSecondaryChildrenUrl(this.folder0Id), this.paging, this.getWhereClause(clause), 200);
        clause = new WhereClauseBuilder().predicate("assocType=cm:contains", true).build();
        this.getAll(this.getNodeSecondaryChildrenUrl(this.folder0Id), this.paging, this.getWhereClause(clause), 400);
    }

    @Test
    public void testLogicalOperatorsGetRenditions() throws Exception {
        String clause = new WhereClauseBuilder().predicate("status=CREATED").build();
        this.getAll(this.getNodeRenditionsUrl(this.file0Id), this.paging, this.getWhereClause(clause), 200);
        clause = new WhereClauseBuilder().predicate("status=CREATED", true).build();
        this.getAll(this.getNodeRenditionsUrl(this.file0Id), this.paging, this.getWhereClause(clause), 400);
    }

    @Test
    public void testLogicalOperatorsGetShareLinks() throws Exception {
        String clause = new WhereClauseBuilder().predicate("sharedByUser='-me-'").build();
        this.getAll("shared-links", this.paging, this.getWhereClause(clause), 200);
        clause = new WhereClauseBuilder().predicate("sharedByUser='-me-'", true).build();
        this.getAll("shared-links", this.paging, this.getWhereClause(clause), 400);
    }

    @Test
    public void testLogicalOperatorsGetFavorites() throws Exception {
        String favoritesUrl = this.getFavoritesUrl("-me-");
        String clause = new WhereClauseBuilder().predicate("EXISTS(target/file)").build();
        this.getAll(favoritesUrl, this.paging, this.getWhereClause(clause), 200);
        clause = new WhereClauseBuilder().predicate("EXISTS(target/file)").or("EXISTS(target/folder)").build();
        this.getAll(favoritesUrl, this.paging, this.getWhereClause(clause), 200);
        clause = new WhereClauseBuilder().predicate("EXISTS(target/file)").and("EXISTS(target/folder)").build();
        this.getAll(favoritesUrl, this.paging, this.getWhereClause(clause), 400);
    }

    private Map<String, String> getWhereClause(String whereparams) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("where", whereparams);
        return params;
    }

    private String getNodeSecondaryChildrenUrl(String nodeId) {
        return "nodes/" + nodeId + "/secondary-children";
    }

    private String getFavoritesUrl(String nodeId) {
        return "people/" + nodeId + "/favorites";
    }

    private class WhereClauseBuilder {
        private WhereClause whereClause;

        private WhereClauseBuilder() {
        }

        public WhereClauseBuilder predicate(String predicate, boolean negated) {
            this.whereClause = new WhereClause(predicate, negated);
            return this;
        }

        public WhereClauseBuilder predicate(String predicate) {
            return this.predicate(predicate, false);
        }

        public WhereClauseBuilder and(String predicate, boolean negated) {
            this.whereClause.and(new WhereClause(predicate, negated));
            return this;
        }

        public WhereClauseBuilder and(String predicate) {
            return this.and(predicate, false);
        }

        public WhereClauseBuilder or(String predicate, boolean negated) {
            this.whereClause.or(new WhereClause(predicate, negated));
            return this;
        }

        public WhereClauseBuilder or(String predicate) {
            return this.or(predicate, false);
        }

        public WhereClauseBuilder not() {
            this.whereClause.negate();
            return this;
        }

        public String build() {
            this.whereClause.group();
            return this.whereClause.toString();
        }

        private class WhereClause {
            private final String[] operators = new String[]{"MATCHES", "IN", "BETWEEN"};
            private String clause;

            public WhereClause(String clause, boolean negated) {
                this.clause = clause;
                if (negated) {
                    this.negate();
                }
            }

            private void group() {
                this.clause = "(" + this.clause + ")";
            }

            private void and(WhereClause otherClause) {
                this.clause = this.clause + " AND " + String.valueOf(otherClause);
            }

            private void or(WhereClause otherClause) {
                this.clause = this.clause + " OR " + String.valueOf(otherClause);
            }

            public void negate() {
                for (String op : this.operators) {
                    if (!this.clause.contains(op)) continue;
                    this.clause.replace(op, "NOT " + op);
                    return;
                }
                this.clause = "NOT " + this.clause;
            }

            public String toString() {
                return this.clause;
            }
        }
    }
}

